/*
 * Decompiled with CFR 0.152.
 */
package muramasa.antimatter.tile;

import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import muramasa.antimatter.Ref;
import muramasa.antimatter.block.BlockProxy;
import muramasa.antimatter.capability.ICoverHandler;
import muramasa.antimatter.client.dynamic.DynamicTexturer;
import muramasa.antimatter.client.dynamic.DynamicTexturers;
import muramasa.antimatter.cover.CoverFactory;
import muramasa.antimatter.cover.ICover;
import muramasa.antimatter.tile.TileEntityTickable;
import muramasa.antimatter.tile.multi.TileEntityBasicMultiMachine;
import muramasa.antimatter.util.Utils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.LongTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class TileEntityFakeBlock
extends TileEntityTickable<TileEntityFakeBlock> {
    private BlockState state = Blocks.f_50016_.m_49966_();
    public final Set<TileEntityBasicMultiMachine<?>> controllers = new ObjectOpenHashSet();
    public Map<Direction, ICover> covers = new EnumMap<Direction, ICover>(Direction.class);
    public Direction facing;
    public final Map<Direction, DynamicTexturer<ICover, ICover.DynamicKey>> coverTexturer = new Object2ObjectOpenHashMap();
    public List<BlockPos> controllerPos;

    public TileEntityFakeBlock(BlockProxy proxy, BlockPos pos, BlockState state) {
        super(proxy.TYPE, pos, state);
    }

    public void addController(TileEntityBasicMultiMachine<?> controller) {
        if (this.f_58857_ != null) {
            this.f_58857_.m_46672_(this.f_58858_, this.m_58900_().m_60734_());
        }
        this.controllers.add(controller);
    }

    @Override
    public void serverTick(Level level, BlockPos pos, BlockState state) {
        this.covers.forEach((s, c) -> {
            if (c.ticks()) {
                c.onUpdate();
            }
        });
    }

    public ICover[] covers() {
        ICover[] ret = new ICover[6];
        for (Direction dir : Ref.DIRS) {
            ICover c = this.covers.get(dir);
            ret[dir.m_122411_()] = c == null ? ICover.empty : c;
        }
        return ret;
    }

    public void removeController(TileEntityBasicMultiMachine<?> controller) {
        if (this.f_58857_ != null) {
            this.f_58857_.m_46672_(this.f_58858_, this.m_58900_().m_60734_());
        }
        this.controllers.remove(controller);
    }

    public TileEntityFakeBlock setCovers(Map<Direction, CoverFactory> covers) {
        ICoverHandler<?> handler = ICoverHandler.empty(this);
        for (Map.Entry<Direction, CoverFactory> entry : covers.entrySet()) {
            Direction dir = entry.getKey();
            CoverFactory factory = entry.getValue();
            Direction rot = Utils.coverRotateFacing(dir, this.facing);
            if (rot.m_122434_() == Direction.Axis.X) {
                rot = rot.m_122424_();
            }
            ICover cover = factory.get().get(handler, null, rot, factory);
            this.covers.put(rot, cover);
        }
        this.m_6596_();
        return this;
    }

    public TileEntityFakeBlock setFacing(Direction facing) {
        this.facing = facing;
        this.m_6596_();
        return this;
    }

    @OnlyIn(value=Dist.CLIENT)
    public DynamicTexturer<ICover, ICover.DynamicKey> getTexturer(Direction side) {
        return this.coverTexturer.computeIfAbsent(side, dir -> new DynamicTexturer<ICover, ICover.DynamicKey>(DynamicTexturers.COVER_DYNAMIC_TEXTURER));
    }

    @Nullable
    public ICover getCover(Direction side) {
        return this.covers.get(side);
    }

    public void m_142466_(CompoundTag nbt) {
        super.m_142466_(nbt);
        this.state = NbtUtils.m_129241_((CompoundTag)nbt.m_128469_("B"));
        this.facing = nbt.m_128441_("F") ? Direction.m_122376_((int)nbt.m_128451_("F")) : Direction.NORTH;
        if (this.f_58857_ != null && this.f_58857_.f_46443_) {
            Utils.markTileForRenderUpdate(this);
        }
        this.covers = new EnumMap<Direction, ICover>(Direction.class);
        CompoundTag c = nbt.m_128469_("C");
        for (Direction dir : Ref.DIRS) {
            ICover cover = CoverFactory.readCover(ICoverHandler.empty(this), dir, c);
            if (cover == null) continue;
            this.covers.put(dir, cover);
        }
        if (nbt.m_128441_("P")) {
            ListTag list = nbt.m_128437_("P", 4);
            this.controllerPos = new ObjectArrayList(list.size());
            list.forEach(n -> this.controllerPos.add(BlockPos.m_122022_((long)((LongTag)n).m_7046_())));
        }
    }

    @Nonnull
    public CompoundTag m_5995_() {
        CompoundTag nbt = new CompoundTag();
        this.writeTag(nbt, true);
        return nbt;
    }

    protected void m_183515_(CompoundTag nbt) {
        this.writeTag(nbt, false);
    }

    private void writeTag(CompoundTag compound, boolean send) {
        compound.m_128365_("B", (Tag)NbtUtils.m_129202_((BlockState)this.state));
        if (this.facing != null) {
            compound.m_128405_("F", this.facing.ordinal());
        }
        CompoundTag n = new CompoundTag();
        this.covers.forEach((k, v) -> CoverFactory.writeCover(n, v));
        compound.m_128365_("C", (Tag)n);
        if (!send) {
            ListTag list = new ListTag();
            for (TileEntityBasicMultiMachine<?> controller : this.controllers) {
                list.add((Object)LongTag.m_128882_((long)controller.m_58899_().m_121878_()));
            }
            compound.m_128365_("P", (Tag)list);
        }
    }

    public BlockState getState() {
        return this.state;
    }

    public TileEntityFakeBlock setState(BlockState state) {
        this.state = state;
        return this;
    }

    @Override
    public List<String> getInfo() {
        List<String> list = super.getInfo();
        if (this.getState() != null) {
            list.add("State: " + this.getState().toString());
        }
        if (this.facing != null) {
            list.add("Facing: " + this.facing.m_122433_());
        }
        this.covers.forEach((k, v) -> list.add("Cover on " + k.m_122433_() + ": " + v.getId()));
        if (this.controllers.size() > 0) {
            list.add("Controller positions: " + this.controllers.stream().map(t -> t.m_58899_().toString()).reduce((k, v) -> k + ", " + v).orElse(""));
        }
        return list;
    }
}

