/*
 * Decompiled with CFR 0.152.
 */
package muramasa.antimatter.tile;

import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.List;
import javax.annotation.Nullable;
import muramasa.antimatter.capability.Dispatch;
import muramasa.antimatter.util.Utils;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.Connection;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;

public abstract class TileEntityBase<T extends TileEntityBase<T>>
extends BlockEntity {
    protected final Dispatch dispatch = new Dispatch();

    public TileEntityBase(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
    }

    public void m_7651_() {
        super.m_7651_();
        this.onRemove();
    }

    public void onRemove() {
    }

    public boolean isClientSide() {
        return this.f_58857_.f_46443_;
    }

    public boolean isServerSide() {
        return !this.f_58857_.f_46443_;
    }

    public List<String> getInfo() {
        ObjectArrayList info = new ObjectArrayList();
        info.add("Tile: " + ((Object)((Object)this)).getClass().getSimpleName());
        return info;
    }

    public void sidedSync(boolean renderUpdate) {
        if (this.f_58859_) {
            return;
        }
        if (this.m_58904_() == null) {
            return;
        }
        if (!this.m_58904_().f_46443_) {
            this.m_6596_();
            Utils.markTileForNBTSync(this);
        } else if (renderUpdate) {
            Utils.markTileForRenderUpdate(this);
        }
    }

    @Nullable
    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    public void onDataPacket(Connection net, ClientboundBlockEntityDataPacket pkt) {
        CompoundTag compoundtag = pkt.m_131708_();
        if (compoundtag != null) {
            this.m_142466_(compoundtag);
        }
        this.sidedSync(true);
    }

    public static interface BlockEntitySupplier<T extends BlockEntity, U> {
        public T create(U var1, BlockPos var2, BlockState var3);
    }

    public static class BlockEntityGetter<T extends BlockEntity, U>
    implements BlockEntityType.BlockEntitySupplier<T> {
        private final U value;
        private final BlockEntitySupplier<T, U> supplier;

        public BlockEntityGetter(BlockEntitySupplier<T, U> supp, U value) {
            this.value = value;
            this.supplier = supp;
        }

        public T m_155267_(BlockPos p_155268_, BlockState p_155269_) {
            return this.supplier.create(this.value, p_155268_, p_155269_);
        }
    }
}

