/*
 * Decompiled with CFR 0.152.
 */
package muramasa.antimatter.structure.impl;

import com.google.common.collect.ImmutableMap;
import it.unimi.dsi.fastutil.longs.LongArrayList;
import it.unimi.dsi.fastutil.longs.LongList;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import muramasa.antimatter.structure.Structure;
import muramasa.antimatter.structure.StructureElement;
import muramasa.antimatter.structure.StructureResult;
import muramasa.antimatter.tile.multi.TileEntityBasicMultiMachine;
import muramasa.antimatter.util.Dir;
import muramasa.antimatter.util.int2;
import muramasa.antimatter.util.int3;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;

public class SimpleStructure
extends Structure {
    private final int3 size;
    private final int2 offset = new int2();
    private final ImmutableMap<int3, StructureElement> elements;
    private final Set<Direction> allowedFacings;

    public SimpleStructure(int3 size, ImmutableMap<int3, StructureElement> elements, Set<Direction> facings) {
        this.elements = elements;
        this.size = size;
        this.allowedFacings = facings;
    }

    public SimpleStructure offset(int x, int y) {
        this.offset.set(x, y);
        return this;
    }

    @Override
    public List<BlockPos> allShared(StructureElement element, TileEntityBasicMultiMachine<?> tile) {
        ObjectArrayList ret = new ObjectArrayList();
        Iterable iter = () -> this.forAllElements(tile.m_58899_(), tile.getFacing());
        for (Structure.Point point : iter) {
            if (!point.el.equals(element)) continue;
            ret.add(point.pos.m_7949_());
        }
        return ret;
    }

    @Override
    public StructureResult evaluate(@Nonnull TileEntityBasicMultiMachine<?> tile) {
        StructureResult result = new StructureResult(this);
        if (!this.allowedFacings.contains(tile.getFacing())) {
            result.withError("Invalid facing in machine");
            return result;
        }
        Iterator<Structure.Point> it = this.forAllElements(tile.m_58899_(), tile.getFacing());
        while (it.hasNext()) {
            Structure.Point point = it.next();
            if (!point.el.evaluate(tile, point.pos, result)) {
                return result;
            }
            result.register(point.pos.m_7949_(), point.el);
        }
        return result;
    }

    @Override
    public LongList allPositions(TileEntityBasicMultiMachine<?> tile) {
        LongArrayList l = new LongArrayList();
        Iterator<Structure.Point> it = this.forAllElements(tile.m_58899_(), tile.getFacing());
        while (it.hasNext()) {
            l.add(it.next().pos.m_121878_());
        }
        return l;
    }

    @Override
    public int3 size() {
        return this.size;
    }

    @Override
    public int2 offset() {
        return this.offset;
    }

    public Iterator<Structure.Point> forAllElements(final @Nonnull BlockPos source, final @Nonnull Direction facing) {
        return new Iterator<Structure.Point>(){
            final int3 corner;
            final int3 working;
            final Structure.Point point;
            final Iterator<Map.Entry<int3, StructureElement>> it;
            {
                this.corner = new int3(source, facing).left(SimpleStructure.this.size().m_123341_() / 2).back(SimpleStructure.this.offset().x).above(SimpleStructure.this.offset().y);
                this.working = new int3(facing);
                this.point = new Structure.Point();
                this.it = SimpleStructure.this.elements.entrySet().iterator();
            }

            @Override
            public boolean hasNext() {
                return this.it.hasNext();
            }

            @Override
            public Structure.Point next() {
                Map.Entry<int3, StructureElement> next = this.it.next();
                this.working.set((BlockPos)this.corner).offset(next.getKey(), Dir.RIGHT, Dir.UP, Dir.FORWARD);
                this.point.el = next.getValue();
                this.point.pos = this.working;
                return this.point;
            }
        };
    }
}

