/*
 * Decompiled with CFR 0.152.
 */
package muramasa.antimatter.structure;

import com.google.common.collect.Lists;
import it.unimi.dsi.fastutil.longs.LongArrayList;
import it.unimi.dsi.fastutil.longs.LongList;
import it.unimi.dsi.fastutil.objects.Object2ObjectMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.List;
import java.util.Map;
import muramasa.antimatter.capability.IComponentHandler;
import muramasa.antimatter.machine.MachineState;
import muramasa.antimatter.structure.IRequirement;
import muramasa.antimatter.structure.Structure;
import muramasa.antimatter.structure.StructureCache;
import muramasa.antimatter.structure.StructureElement;
import muramasa.antimatter.tile.multi.TileEntityBasicMultiMachine;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.block.state.BlockState;

public class StructureResult {
    private final Structure structure;
    private boolean hasError;
    private String error = "";
    public Object2ObjectMap<String, List<IComponentHandler>> components = new Object2ObjectOpenHashMap();
    public Object2ObjectMap<String, List<BlockState>> states = new Object2ObjectOpenHashMap();
    private final Map<BlockPos, StructureElement> elementLookup = new Object2ObjectOpenHashMap();
    private final Map<BlockPos, StructureElement> tickingElements = new Object2ObjectOpenHashMap();
    public final LongList positions = new LongArrayList();

    public StructureResult(Structure structure) {
        this.structure = structure;
    }

    public void withError(String error) {
        this.error = error;
        this.hasError = true;
    }

    public StructureResult register(BlockPos pos, StructureElement el) {
        this.elementLookup.put(pos, el);
        if (el.ticks()) {
            this.tickingElements.put(pos, el);
        }
        return this;
    }

    public StructureElement get(BlockPos pos) {
        return this.elementLookup.get(pos);
    }

    public String getError() {
        return "[Structure Debug] " + this.error;
    }

    public void addComponent(String elementId, IComponentHandler component) {
        List existing = (List)this.components.get((Object)component.getId());
        if (existing == null) {
            this.components.put((Object)component.getId(), (Object)Lists.newArrayList((Object[])new IComponentHandler[]{component}));
        } else {
            existing.add(component);
        }
        if (!elementId.isEmpty() && !elementId.equals(component.getId())) {
            existing = (List)this.components.get((Object)elementId);
            if (existing == null) {
                this.components.put((Object)elementId, (Object)Lists.newArrayList((Object[])new IComponentHandler[]{component}));
            } else {
                existing.add(component);
            }
        }
        this.positions.add(component.getTile().m_58899_().m_121878_());
    }

    public void addState(String elementId, BlockPos pos, BlockState state) {
        if (!elementId.equals(StructureElement.IGNORE.elementId)) {
            List existing = (List)this.states.get((Object)elementId);
            if (existing == null) {
                this.states.put((Object)elementId, (Object)Lists.newArrayList((Object[])new BlockState[]{state}));
            } else {
                existing.add(state);
            }
            this.positions.add(pos.m_121878_());
        }
    }

    public boolean evaluate() {
        if (this.hasError) {
            return false;
        }
        for (Map.Entry<String, IRequirement> entry : this.structure.getRequirements().entrySet()) {
            if (entry.getValue().test(this)) continue;
            this.withError("Failed Element Requirement: " + entry.getKey());
            return false;
        }
        return true;
    }

    public void build(TileEntityBasicMultiMachine<?> machine, StructureResult result) {
        for (Map.Entry<BlockPos, StructureElement> entry : this.elementLookup.entrySet()) {
            int count = StructureCache.refCount(machine.m_58904_(), entry.getKey());
            entry.getValue().onBuild(machine, entry.getKey(), result, count);
        }
    }

    public void remove(TileEntityBasicMultiMachine<?> machine, StructureResult result) {
        for (Map.Entry<BlockPos, StructureElement> entry : this.elementLookup.entrySet()) {
            int count = StructureCache.refCount(machine.m_58904_(), entry.getKey());
            entry.getValue().onRemove(machine, entry.getKey(), result, count);
        }
    }

    public void updateState(TileEntityBasicMultiMachine<?> machine, StructureResult result) {
        MachineState proper = machine.getMachineState().getTextureState();
        for (Map.Entry<BlockPos, StructureElement> entry : this.elementLookup.entrySet()) {
            int count = StructureCache.refCount(machine.m_58904_(), entry.getKey());
            entry.getValue().onStateChange(machine, proper, entry.getKey(), result, count);
        }
    }

    public void tick(TileEntityBasicMultiMachine<?> machine) {
        if (this.tickingElements.isEmpty()) {
            return;
        }
        for (Map.Entry<BlockPos, StructureElement> entry : this.tickingElements.entrySet()) {
            entry.getValue().tick(machine, this, entry.getKey());
        }
    }
}

