/*
 * Decompiled with CFR 0.152.
 */
package muramasa.antimatter.structure;

import java.util.Collections;
import java.util.List;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import muramasa.antimatter.structure.StructureCache;
import muramasa.antimatter.tile.multi.TileEntityBasicMultiMachine;
import muramasa.antimatter.util.Dir;
import muramasa.antimatter.util.int3;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;

public class StructureHandle<T extends TileEntityBasicMultiMachine<T>> {
    private final boolean debug = false;
    private final TileEntityBasicMultiMachine<?> source;
    private final List<int3> offsets;
    private final Consumer<T> onRemoval;
    private final Consumer<T> onAdd;
    private final Class<T> clazz;
    @Nullable
    private T object;

    public StructureHandle(Class<T> clazz, TileEntityBasicMultiMachine<?> tile, int3 off, @Nullable Consumer<T> onRemoval, @Nullable Consumer<T> onAdd) {
        this(clazz, tile, Collections.singletonList(off), onRemoval, onAdd);
    }

    public StructureHandle(Class<T> clazz, TileEntityBasicMultiMachine<?> tile, List<int3> off, @Nullable Consumer<T> onRemoval, @Nullable Consumer<T> onAdd) {
        this.source = tile;
        this.offsets = off;
        this.onRemoval = onRemoval;
        this.onAdd = onAdd;
        this.clazz = clazz;
        tile.addStructureHandle(this);
    }

    public TileEntityBasicMultiMachine<?> getSource() {
        return this.source;
    }

    public void register() {
        BlockState state = this.source.m_58900_();
        boolean vertical = this.source.getMachineType().allowVerticalFacing();
        Direction facing = vertical ? (Direction)state.m_61143_((Property)BlockStateProperties.f_61372_) : (Direction)state.m_61143_((Property)BlockStateProperties.f_61374_);
        int3 newOff = new int3(facing);
        for (int3 offset : this.offsets) {
            newOff.set(this.source.m_58899_()).offset(offset, Dir.RIGHT, Dir.UP, Dir.FORWARD);
            StructureCache.addListener(this, this.source.m_58904_(), (BlockPos)newOff);
        }
    }

    public void deregister() {
        BlockState state = this.source.m_58900_();
        boolean vertical = this.source.getMachineType().allowVerticalFacing();
        Direction facing = vertical ? (Direction)state.m_61143_((Property)BlockStateProperties.f_61372_) : (Direction)state.m_61143_((Property)BlockStateProperties.f_61374_);
        int3 newOff = new int3(facing);
        for (int3 offset : this.offsets) {
            newOff.set(this.source.m_58899_()).offset(offset, Dir.RIGHT, Dir.UP, Dir.FORWARD);
            StructureCache.removeListener(this, this.source.m_58904_(), (BlockPos)newOff);
        }
    }

    public void structureCacheRemoval() {
        T obj = this.object;
        this.object = null;
        if (this.onRemoval != null && obj != null) {
            this.onRemoval.accept(obj);
        }
    }

    public void structureCacheAddition(BlockEntity t) {
        if (!this.clazz.isInstance(t)) {
            return;
        }
        this.object = (TileEntityBasicMultiMachine)t;
        if (this.onAdd != null) {
            this.onAdd.accept(this.object);
        }
    }

    @Nullable
    public T get() {
        return this.object;
    }
}

