/*
 * Decompiled with CFR 0.152.
 */
package muramasa.antimatter.structure;

import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.longs.LongList;
import it.unimi.dsi.fastutil.longs.LongListIterator;
import it.unimi.dsi.fastutil.longs.LongLists;
import it.unimi.dsi.fastutil.objects.Object2BooleanMap;
import it.unimi.dsi.fastutil.objects.Object2BooleanOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import java.util.Collections;
import java.util.Set;
import javax.annotation.Nullable;
import muramasa.antimatter.Antimatter;
import muramasa.antimatter.AntimatterAPI;
import muramasa.antimatter.structure.StructureHandle;
import muramasa.antimatter.tile.multi.TileEntityBasicMultiMachine;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.entity.BlockEntity;

public class StructureCache {
    private static final Object2ObjectMap<Level, DimensionEntry> LOOKUP = new Object2ObjectOpenHashMap();
    private static final Object2ObjectMap<Level, Long2ObjectMap<Set<StructureHandle<?>>>> CALLBACKS = new Object2ObjectOpenHashMap();

    public static boolean validate(Level world, BlockPos pos, LongList structure, int maxAmount) {
        DimensionEntry e = (DimensionEntry)LOOKUP.get((Object)world);
        if (e != null && !StructureCache.has(world, pos)) {
            boolean ok = e.validate(pos, maxAmount, structure);
            if (ok) {
                StructureCache.notifyListenersAdd(world, pos);
            }
            return ok;
        }
        return false;
    }

    public static int refCount(Level world, BlockPos pos) {
        DimensionEntry entry = (DimensionEntry)LOOKUP.get((Object)world);
        if (entry == null) {
            return 0;
        }
        Object2BooleanMap<BlockPos> e = entry.get(pos);
        return e == null ? 0 : e.values().stream().mapToInt(t -> t != false ? 1 : 0).sum();
    }

    public static boolean has(Level world, BlockPos pos) {
        DimensionEntry entry = (DimensionEntry)LOOKUP.get((Object)world);
        if (entry == null) {
            return false;
        }
        long p = pos.m_121878_();
        LongList l = (LongList)entry.CONTROLLER_TO_STRUCTURE.get(p);
        if (l == null || l.size() == 0) {
            return false;
        }
        return ((Object2BooleanMap)entry.STRUCTURE_TO_CONTROLLER.get(l.iterator().nextLong())).getBoolean((Object)pos);
    }

    @Nullable
    public static Object2BooleanMap<BlockPos> get(Level world, BlockPos pos) {
        DimensionEntry entry = (DimensionEntry)LOOKUP.get((Object)world);
        return entry != null ? entry.get(pos) : null;
    }

    @Nullable
    public static <T extends TileEntityBasicMultiMachine> T getAnyMulti(Level world, BlockPos pos, Class<T> clazz) {
        DimensionEntry entry = (DimensionEntry)LOOKUP.get((Object)world);
        if (entry == null) {
            return null;
        }
        Object2BooleanMap<BlockPos> list = entry.get(pos);
        if (list == null || list.size() == 0) {
            return null;
        }
        for (Object2BooleanMap.Entry e : list.object2BooleanEntrySet()) {
            BlockEntity tile = world.m_7702_((BlockPos)e.getKey());
            if (tile == null || !clazz.isInstance(tile) || !e.getBooleanValue()) continue;
            return (T)((TileEntityBasicMultiMachine)tile);
        }
        return null;
    }

    public static void add(Level world, BlockPos pos, LongList structure) {
        DimensionEntry entry = (DimensionEntry)LOOKUP.computeIfAbsent((Object)world, e -> new DimensionEntry());
        entry.add(pos, structure);
    }

    public static void remove(Level world, BlockPos pos) {
        DimensionEntry entry = (DimensionEntry)LOOKUP.get((Object)world);
        if (entry == null) {
            return;
        }
        entry.remove(pos);
    }

    public static void invalidate(Level world, BlockPos pos, LongList structure) {
        DimensionEntry entry = (DimensionEntry)LOOKUP.get((Object)world);
        if (entry != null && StructureCache.has(world, pos)) {
            StructureCache.notifyListenersRemove(world, pos);
            entry.invalidate(pos, structure);
        }
    }

    private static void refreshController(Level world, BlockPos controller, BlockPos at) {
        BlockEntity tile = world.m_7702_(controller);
        if (tile instanceof TileEntityBasicMultiMachine) {
            ((TileEntityBasicMultiMachine)tile).onBlockUpdate(at);
        }
    }

    public static void addListener(StructureHandle<?> handle, Level world, BlockPos pos) {
        Long2ObjectMap map = (Long2ObjectMap)CALLBACKS.computeIfAbsent((Object)world, k -> new Long2ObjectOpenHashMap());
        Set set = (Set)map.computeIfAbsent(pos.m_121878_(), k -> new ObjectOpenHashSet());
        set.add(handle);
        BlockEntity tile = world.m_7702_(pos);
        if (tile != null && StructureCache.has(world, pos)) {
            handle.structureCacheAddition(tile);
        }
    }

    public static void removeListener(StructureHandle<?> handle, Level world, BlockPos pos) {
        Set set;
        Long2ObjectMap map = (Long2ObjectMap)CALLBACKS.get((Object)world);
        if (map != null && (set = (Set)map.get(pos.m_121878_())) != null) {
            set.remove(handle);
        }
    }

    private static void notifyListenersAdd(Level world, BlockPos pos) {
        Long2ObjectMap map = (Long2ObjectMap)CALLBACKS.get((Object)world);
        if (map != null) {
            BlockEntity tile = world.m_7702_(pos);
            ((Set)map.getOrDefault(pos.m_121878_(), Collections.emptySet())).forEach(handle -> handle.structureCacheAddition(tile));
        }
    }

    private static void notifyListenersRemove(Level world, BlockPos pos) {
        Long2ObjectMap map = (Long2ObjectMap)CALLBACKS.get((Object)world);
        if (map != null) {
            ((Set)map.getOrDefault(pos.m_121878_(), Collections.emptySet())).forEach(StructureHandle::structureCacheRemoval);
        }
    }

    public static void onWorldUnload(LevelAccessor world) {
        LOOKUP.remove((Object)((Level)world));
        Long2ObjectMap map = (Long2ObjectMap)CALLBACKS.remove((Object)((Level)world));
        if (map != null) {
            map.forEach((k, v) -> v.forEach(StructureHandle::structureCacheRemoval));
        }
    }

    static {
        AntimatterAPI.registerBlockUpdateHandler((world, pos, oldState, newState, flags) -> {
            if (oldState == newState) {
                return;
            }
            if ((flags & 1) == 0) {
                return;
            }
            DimensionEntry entry = (DimensionEntry)LOOKUP.get((Object)world);
            if (entry == null) {
                return;
            }
            Object2BooleanMap<BlockPos> controllerPos = entry.get(pos);
            if (controllerPos != null && controllerPos.size() > 0) {
                controllerPos.forEach((p, valid) -> {
                    if (!p.equals((Object)pos)) {
                        StructureCache.refreshController(world, p, pos);
                    }
                });
            }
        });
    }

    public static class DimensionEntry {
        private final Long2ObjectMap<Object2BooleanMap<BlockPos>> STRUCTURE_TO_CONTROLLER = new Long2ObjectOpenHashMap();
        private final Long2ObjectMap<LongList> CONTROLLER_TO_STRUCTURE = new Long2ObjectOpenHashMap();

        public DimensionEntry() {
            this.CONTROLLER_TO_STRUCTURE.defaultReturnValue((Object)LongLists.EMPTY_LIST);
        }

        @Nullable
        public Object2BooleanMap<BlockPos> get(BlockPos pos) {
            return (Object2BooleanMap)this.STRUCTURE_TO_CONTROLLER.get(pos.m_121878_());
        }

        public void add(BlockPos pos, LongList structure) {
            long at = pos.m_121878_();
            this.CONTROLLER_TO_STRUCTURE.put(at, (Object)structure);
            LongListIterator longListIterator = structure.iterator();
            while (longListIterator.hasNext()) {
                long s = (Long)longListIterator.next();
                this.STRUCTURE_TO_CONTROLLER.compute(s, (k, v) -> {
                    if (v == null) {
                        v = new Object2BooleanOpenHashMap();
                    }
                    v.put((Object)pos, false);
                    return v;
                });
            }
        }

        public boolean validate(BlockPos pos, int maxAmount, LongList structure) {
            long at = pos.m_121878_();
            int i = structure.stream().mapToInt(t -> {
                Object2BooleanMap map = (Object2BooleanMap)this.STRUCTURE_TO_CONTROLLER.get(t.longValue());
                if (map == null) {
                    Antimatter.LOGGER.warn("Invalid state in StructureCache, map should not be null");
                    return Integer.MAX_VALUE;
                }
                return map.values().stream().mapToInt(j -> j != false ? 1 : 0).sum();
            }).max().orElse(0);
            if (i <= maxAmount) {
                LongList old = (LongList)this.CONTROLLER_TO_STRUCTURE.remove(at);
                old.forEach(l -> this.STRUCTURE_TO_CONTROLLER.compute(l, (k, v) -> {
                    if (v == null) {
                        return null;
                    }
                    if (v.size() == 1) {
                        return null;
                    }
                    v.remove((Object)pos);
                    return v;
                }));
                this.CONTROLLER_TO_STRUCTURE.put(at, (Object)structure);
                structure.forEach(t -> this.STRUCTURE_TO_CONTROLLER.compute(t, (k, v) -> {
                    if (v == null) {
                        v = new Object2BooleanOpenHashMap();
                    }
                    v.put((Object)pos, true);
                    return v;
                }));
                return true;
            }
            return false;
        }

        public void invalidate(BlockPos pos, LongList structure) {
            long at = pos.m_121878_();
            LongList old = (LongList)this.CONTROLLER_TO_STRUCTURE.put(at, (Object)structure);
            old.forEach(l -> this.STRUCTURE_TO_CONTROLLER.compute(l, (k, v) -> {
                if (v == null) {
                    return null;
                }
                if (v.size() == 1) {
                    return null;
                }
                v.remove((Object)pos);
                return v;
            }));
            LongListIterator longListIterator = structure.iterator();
            while (longListIterator.hasNext()) {
                long s = (Long)longListIterator.next();
                this.STRUCTURE_TO_CONTROLLER.compute(s, (k, v) -> {
                    if (v == null) {
                        v = new Object2BooleanOpenHashMap();
                    }
                    v.put((Object)pos, false);
                    return v;
                });
            }
        }

        public void remove(BlockPos pos) {
            long at = pos.m_121878_();
            LongList structure = (LongList)this.CONTROLLER_TO_STRUCTURE.remove(at);
            LongListIterator longListIterator = structure.iterator();
            while (longListIterator.hasNext()) {
                long s = (Long)longListIterator.next();
                this.STRUCTURE_TO_CONTROLLER.compute(s, (k, v) -> {
                    if (v == null) {
                        return null;
                    }
                    if (v.size() == 1) {
                        return null;
                    }
                    v.remove((Object)pos);
                    return v;
                });
            }
        }
    }
}

