/*
 * Decompiled with CFR 0.152.
 */
package muramasa.antimatter.structure;

import com.google.common.collect.ImmutableMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import muramasa.antimatter.Ref;
import muramasa.antimatter.registration.IAntimatterObject;
import muramasa.antimatter.structure.ComponentElement;
import muramasa.antimatter.structure.StructureElement;
import muramasa.antimatter.structure.impl.SimpleStructure;
import muramasa.antimatter.util.int3;
import net.minecraft.core.Direction;

public class StructureBuilder {
    private static final Object2ObjectMap<String, StructureElement> globalElementLookup = new Object2ObjectOpenHashMap();
    private final List<String[]> slices = new ObjectArrayList();
    private final Object2ObjectMap<String, StructureElement> elementLookup = new Object2ObjectOpenHashMap();
    private Set<Direction> allowedFacings = Set.of(Ref.DIRS);

    public static void addGlobalElement(String key, StructureElement element) {
        globalElementLookup.put((Object)key, (Object)element);
    }

    public StructureBuilder of(String ... slices) {
        this.slices.add(slices);
        return this;
    }

    public StructureBuilder of(int i) {
        this.slices.add(this.slices.get(i));
        return this;
    }

    public StructureBuilder at(String key, StructureElement element) {
        this.elementLookup.put((Object)key, (Object)element);
        return this;
    }

    public StructureBuilder at(String key, IAntimatterObject ... objects) {
        this.elementLookup.put((Object)key, (Object)new ComponentElement(objects));
        return this;
    }

    public StructureBuilder at(String key, String name, IAntimatterObject ... objects) {
        this.elementLookup.put((Object)key, (Object)new ComponentElement(name, objects));
        return this;
    }

    public StructureBuilder at(String key, Collection<? extends IAntimatterObject> objects) {
        this.elementLookup.put((Object)key, (Object)new ComponentElement(objects.toArray(new IAntimatterObject[0])));
        return this;
    }

    public StructureBuilder at(String key, String name, Collection<? extends IAntimatterObject> objects) {
        this.elementLookup.put((Object)key, (Object)new ComponentElement(name, objects.toArray(new IAntimatterObject[0])));
        return this;
    }

    public StructureBuilder facings(Direction ... faces) {
        this.allowedFacings = Set.of(faces);
        return this;
    }

    public SimpleStructure build() {
        ImmutableMap.Builder elements = ImmutableMap.builder();
        int3 size = new int3(this.slices.get(0).length, this.slices.size(), this.slices.get(0)[0].length());
        for (int y = 0; y < size.m_123342_(); ++y) {
            for (int x = 0; x < size.m_123341_(); ++x) {
                for (int z = 0; z < size.m_123343_(); ++z) {
                    StructureElement e = (StructureElement)this.elementLookup.get((Object)this.slices.get(y)[x].substring(z, z + 1));
                    if (e == null) {
                        e = (StructureElement)globalElementLookup.get((Object)this.slices.get(y)[x].substring(z, z + 1));
                    }
                    if (e == null) {
                        throw new NullPointerException("StructureBuilder failed to parse slice: " + this.slices.get(y)[x]);
                    }
                    if (e.excludes()) continue;
                    elements.put((Object)new int3(x, y, z), (Object)e);
                }
            }
        }
        return new SimpleStructure(size, (ImmutableMap<int3, StructureElement>)elements.build(), this.allowedFacings);
    }
}

