/*
 * Decompiled with CFR 0.152.
 */
package muramasa.antimatter.structure;

import it.unimi.dsi.fastutil.longs.LongList;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import muramasa.antimatter.registration.IAntimatterObject;
import muramasa.antimatter.structure.IRequirement;
import muramasa.antimatter.structure.StructureElement;
import muramasa.antimatter.structure.StructureResult;
import muramasa.antimatter.tile.multi.TileEntityBasicMultiMachine;
import muramasa.antimatter.util.int2;
import muramasa.antimatter.util.int3;
import net.minecraft.core.BlockPos;

public abstract class Structure {
    private final Map<String, IRequirement> requirements = new Object2ObjectOpenHashMap();

    public abstract StructureResult evaluate(@Nonnull TileEntityBasicMultiMachine<?> var1);

    public abstract LongList allPositions(TileEntityBasicMultiMachine<?> var1);

    public abstract int3 size();

    public abstract int2 offset();

    public Structure exact(int i, IAntimatterObject ... objects) {
        Arrays.stream(objects).forEach(o -> this.addReq(o.getId(), r -> r.components.containsKey((Object)o.getId()) && ((List)r.components.get((Object)o.getId())).size() == i || r.states.containsKey((Object)o.getId()) && ((List)r.states.get((Object)o.getId())).size() == i));
        return this;
    }

    public Structure min(int i, IAntimatterObject ... objects) {
        Arrays.stream(objects).forEach(o -> this.addReq(o.getId(), r -> r.components.containsKey((Object)o.getId()) && ((List)r.components.get((Object)o.getId())).size() >= i || r.states.containsKey((Object)o.getId()) && ((List)r.states.get((Object)o.getId())).size() >= i));
        return this;
    }

    public Structure combined(String id, int i, IAntimatterObject ... objects) {
        this.addReq(id, r -> {
            int amount = 0;
            for (IAntimatterObject object : objects) {
                List list = (List)r.components.get((Object)object.getId());
                List states = (List)r.states.get((Object)object.getId());
                amount += list != null ? list.size() : 0;
                amount += states != null ? states.size() : 0;
            }
            return amount >= i;
        });
        return this;
    }

    public Structure addReq(String id, IRequirement req) {
        this.requirements.put(id, req);
        return this;
    }

    public List<BlockPos> allShared(StructureElement element, TileEntityBasicMultiMachine<?> tile) {
        return Collections.emptyList();
    }

    public Map<String, IRequirement> getRequirements() {
        return this.requirements;
    }

    public boolean evaluatePosition(@Nonnull StructureResult res, @Nonnull TileEntityBasicMultiMachine<?> tile, @Nonnull BlockPos pos) {
        StructureElement el = res.get(pos);
        if (el != null) {
            return el.evaluate(tile, new int3(pos.m_123341_(), pos.m_123342_(), pos.m_123343_()), res);
        }
        return true;
    }

    public static class Point {
        public int3 pos = new int3();
        public StructureElement el;
    }
}

