/*
 * Decompiled with CFR 0.152.
 */
package muramasa.antimatter.structure;

import it.unimi.dsi.fastutil.objects.Object2ObjectMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.List;
import muramasa.antimatter.machine.BlockMachine;
import muramasa.antimatter.machine.Tier;
import muramasa.antimatter.machine.types.Machine;
import muramasa.antimatter.structure.BlockInfo;
import muramasa.antimatter.structure.Pattern;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;

public class PatternBuilder {
    private List<String[]> slices = new ObjectArrayList();
    private Object2ObjectMap<String, BlockInfo> elementLookup = new Object2ObjectOpenHashMap();
    private Component description = new TranslatableComponent("");

    public PatternBuilder of(String ... slices) {
        this.slices.add(slices);
        return this;
    }

    public PatternBuilder of(int i) {
        this.slices.add(this.slices.get(i));
        return this;
    }

    public PatternBuilder of(int i, String ... slices) {
        this.slices.set(i, slices);
        return this;
    }

    public PatternBuilder at(String key, BlockInfo value) {
        this.elementLookup.put((Object)key, (Object)value);
        return this;
    }

    public PatternBuilder at(String key, BlockState blockState) {
        return this.at(key, new BlockInfo(blockState));
    }

    public PatternBuilder at(String key, Machine<?> machine, Tier tier, Direction frontSide) {
        BlockMachine block = machine.getBlockState(tier);
        BlockState state = block.getType().allowVerticalFacing() ? (BlockState)block.m_49966_().m_61124_((Property)BlockStateProperties.f_61372_, (Comparable)(frontSide.m_122434_() == Direction.Axis.Y ? frontSide : frontSide.m_122424_())) : (BlockState)block.m_49966_().m_61124_((Property)BlockStateProperties.f_61374_, (Comparable)frontSide);
        BlockEntity te = block.m_142194_(null, state);
        return this.at(key, new BlockInfo(state, te));
    }

    public PatternBuilder shallowCopy() {
        PatternBuilder builder = new PatternBuilder();
        builder.slices = new ObjectArrayList(this.slices);
        builder.elementLookup = new Object2ObjectOpenHashMap(this.elementLookup);
        builder.description = this.description;
        return builder;
    }

    public PatternBuilder description(String description) {
        return this.description((Component)new TranslatableComponent(description));
    }

    public PatternBuilder description(Component description) {
        this.description = description;
        return this;
    }

    public Pattern build() {
        return new Pattern(this.bakeArray(), this.description);
    }

    private BlockInfo[][][] bakeArray() {
        BlockInfo[][][] blockInfos = new BlockInfo[this.slices.size()][][];
        for (int i = 0; i < blockInfos.length; ++i) {
            String[] aisleEntry = this.slices.get(i);
            BlockInfo[][] aisleData = new BlockInfo[aisleEntry.length][];
            for (int j = 0; j < aisleData.length; ++j) {
                String columnEntry = aisleEntry[j];
                BlockInfo[] columnData = new BlockInfo[columnEntry.length()];
                for (int k = 0; k < columnData.length; ++k) {
                    columnData[k] = (BlockInfo)this.elementLookup.getOrDefault((Object)("" + columnEntry.charAt(k)), (Object)BlockInfo.EMPTY);
                }
                aisleData[j] = columnData;
            }
            blockInfos[i] = aisleData;
        }
        return blockInfos;
    }
}

