/*
 * Decompiled with CFR 0.152.
 */
package muramasa.antimatter.structure;

import java.util.Arrays;
import java.util.EnumMap;
import java.util.List;
import muramasa.antimatter.Data;
import muramasa.antimatter.cover.CoverFactory;
import muramasa.antimatter.structure.IBlockStatePredicate;
import muramasa.antimatter.structure.StructureCache;
import muramasa.antimatter.structure.StructureElement;
import muramasa.antimatter.structure.StructureResult;
import muramasa.antimatter.tile.TileEntityFakeBlock;
import muramasa.antimatter.tile.multi.TileEntityBasicMultiMachine;
import muramasa.antimatter.util.int3;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;

public class FakeTileElement
extends StructureElement {
    private final IBlockStatePredicate[] preds;
    private final EnumMap<Direction, CoverFactory> covers = new EnumMap(Direction.class);

    public FakeTileElement(IBlockStatePredicate ... pred) {
        this.preds = pred;
    }

    public FakeTileElement(Block ... pred) {
        this.preds = (IBlockStatePredicate[])Arrays.stream(pred).map(t -> (reader, pos, state) -> state.m_60734_() == Data.PROXY_INSTANCE || state.m_60713_(t)).toArray(IBlockStatePredicate[]::new);
    }

    public FakeTileElement(BlockState ... pred) {
        this.preds = (IBlockStatePredicate[])Arrays.stream(pred).map(t -> (reader, pos, state) -> state.m_60734_() == Data.PROXY_INSTANCE || state.equals(t)).toArray(IBlockStatePredicate[]::new);
    }

    public FakeTileElement() {
        this.preds = new IBlockStatePredicate[0];
    }

    @Override
    public boolean evaluate(TileEntityBasicMultiMachine<?> machine, int3 pos, StructureResult result) {
        BlockState state = machine.m_58904_().m_8055_((BlockPos)pos);
        if (state.m_60713_((Block)Data.PROXY_INSTANCE)) {
            BlockEntity tile = machine.m_58904_().m_7702_((BlockPos)pos);
            if (tile instanceof TileEntityFakeBlock) {
                BlockState st = ((TileEntityFakeBlock)tile).getState();
                if (st == null) {
                    return true;
                }
                for (IBlockStatePredicate pred : this.preds) {
                    if (!pred.evaluate((LevelReader)machine.m_58904_(), (BlockPos)pos, st)) continue;
                    result.addState("fake", (BlockPos)pos, st);
                    return true;
                }
                if (this.preds.length == 0) {
                    result.addState("fake", (BlockPos)pos, st);
                    return true;
                }
            }
            result.withError("Invalid BlockProxy state.");
            return false;
        }
        if (StructureCache.refCount(machine.m_58904_(), (BlockPos)pos) > 0) {
            result.withError("FakeTile sharing a block that is not of proxy type.");
            return false;
        }
        if (state.m_155947_()) {
            result.withError("BlockProxy replacement should not have Tile.");
            return false;
        }
        if (this.preds.length == 0) {
            result.addState("fake", (BlockPos)pos, state);
            return true;
        }
        for (IBlockStatePredicate pred : this.preds) {
            if (!pred.evaluate((LevelReader)machine.m_58904_(), (BlockPos)pos, state)) continue;
            result.addState("fake", (BlockPos)pos, state);
            return true;
        }
        result.withError("No matching blocks for FakeTile");
        return false;
    }

    public FakeTileElement cover(Direction side, CoverFactory cover) {
        this.covers.put(side, cover);
        return this;
    }

    public void onBuild(TileEntityBasicMultiMachine machine, BlockPos pos, StructureResult result, int count) {
        Level world = machine.m_58904_();
        BlockState oldState = world.m_8055_(pos);
        if (count > 1 || oldState.m_60713_((Block)Data.PROXY_INSTANCE)) {
            ((TileEntityFakeBlock)world.m_7702_(pos)).addController(machine);
            return;
        }
        world.m_7731_(pos, Data.PROXY_INSTANCE.m_49966_(), 10);
        TileEntityFakeBlock tile = (TileEntityFakeBlock)world.m_7702_(pos);
        tile.setState(oldState).setFacing(machine.getFacing()).setCovers(this.covers);
        tile.addController(machine);
        super.onBuild(machine, pos, result, count);
    }

    @Override
    public void onInfoTooltip(List<Component> text, long count, TileEntityBasicMultiMachine<?> machine) {
        super.onInfoTooltip(text, count, machine);
        text.add((Component)new TextComponent("Element replaced with a TileEntity to allow input/output."));
    }

    public void onRemove(TileEntityBasicMultiMachine machine, BlockPos pos, StructureResult result, int count) {
        Level world = machine.m_58904_();
        BlockEntity tile = world.m_7702_(pos);
        if (!(tile instanceof TileEntityFakeBlock)) {
            return;
        }
        if (count == 0) {
            BlockState state = ((TileEntityFakeBlock)tile).getState();
            world.m_7731_(pos, state, 11);
            return;
        }
        ((TileEntityFakeBlock)tile).removeController(machine);
        super.onRemove(machine, pos, result, count);
    }
}

