/*
 * Decompiled with CFR 0.152.
 */
package muramasa.antimatter.structure;

import java.util.List;
import muramasa.antimatter.capability.IComponentHandler;
import muramasa.antimatter.registration.IAntimatterObject;
import muramasa.antimatter.structure.IComponent;
import muramasa.antimatter.structure.StructureElement;
import muramasa.antimatter.structure.StructureResult;
import muramasa.antimatter.tile.multi.TileEntityBasicMultiMachine;
import muramasa.antimatter.util.int3;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;

public class ComponentElement
extends StructureElement {
    private IAntimatterObject[] objects;

    public ComponentElement(String elementId, IAntimatterObject ... objects) {
        super(elementId);
        this.objects = objects;
    }

    public ComponentElement(IAntimatterObject ... objects) {
        this.objects = objects;
    }

    @Override
    public boolean evaluate(TileEntityBasicMultiMachine<?> machine, int3 pos, StructureResult result) {
        BlockEntity tile = machine.m_58904_().m_7702_((BlockPos)pos);
        if (tile instanceof IComponent && ((IComponent)tile).getComponentHandler().isPresent()) {
            IComponentHandler component = (IComponentHandler)((IComponent)tile).getComponentHandler().orElse(null);
            for (int i = 0; i < this.objects.length; ++i) {
                if (!this.objects[i].getId().equals(component.getId())) continue;
                result.addComponent(this.elementId, component);
                return true;
            }
            result.withError("Expected: '" + this.elementId + "' Found: '" + component.getId() + "' @" + pos);
            return false;
        }
        BlockState state = machine.m_58904_().m_8055_((BlockPos)pos);
        if (state.m_60734_() instanceof IAntimatterObject) {
            for (int i = 0; i < this.objects.length; ++i) {
                if (!this.objects[i].getId().equals(((IAntimatterObject)state.m_60734_()).getId())) continue;
                if (!this.elementId.isEmpty()) {
                    result.addState(this.elementId, (BlockPos)pos, state);
                } else {
                    result.addState(((IAntimatterObject)state.m_60734_()).getId(), (BlockPos)pos, state);
                }
                return true;
            }
        }
        result.withError("No valid component found @" + pos);
        return false;
    }

    @Override
    public boolean renderShared() {
        return true;
    }

    @Override
    public void onInfoTooltip(List<Component> text, long count, TileEntityBasicMultiMachine<?> machine) {
        super.onInfoTooltip(text, count, machine);
        if (count > 0L) {
            text.add((Component)new TextComponent("Can be in multiple positions."));
        }
    }
}

