/*
 * Decompiled with CFR 0.152.
 */
package muramasa.antimatter.structure;

import java.util.function.BiFunction;
import muramasa.antimatter.machine.MachineState;
import muramasa.antimatter.structure.IBlockStatePredicate;
import muramasa.antimatter.structure.StructureElement;
import muramasa.antimatter.structure.StructureResult;
import muramasa.antimatter.tile.multi.TileEntityBasicMultiMachine;
import muramasa.antimatter.util.int3;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.state.BlockState;

public class ChangingStateElement
extends StructureElement {
    private final IBlockStatePredicate regular;
    private final IBlockStatePredicate built;
    private final BiFunction<MachineState, BlockState, BlockState> builder;

    public ChangingStateElement(IBlockStatePredicate defaultValidator, IBlockStatePredicate builtValidator, BiFunction<MachineState, BlockState, BlockState> builder) {
        this.regular = defaultValidator;
        this.built = builtValidator;
        this.builder = builder;
    }

    @Override
    public boolean evaluate(TileEntityBasicMultiMachine<?> machine, int3 pos, StructureResult result) {
        IBlockStatePredicate pred;
        BlockState state = machine.m_58904_().m_8055_((BlockPos)pos);
        IBlockStatePredicate iBlockStatePredicate = pred = machine.getMachineState() == MachineState.INVALID_STRUCTURE ? this.regular : this.built;
        if (pred.evaluate((LevelReader)machine.m_58904_(), (BlockPos)pos, machine.m_58904_().m_8055_((BlockPos)pos))) {
            result.addState("changing", (BlockPos)pos, state);
            return true;
        }
        return super.evaluate(machine, pos, result);
    }

    @Override
    public void onBuild(TileEntityBasicMultiMachine<?> machine, BlockPos pos, StructureResult result, int count) {
        super.onBuild(machine, pos, result, count);
        if (count > 1) {
            return;
        }
        Level world = machine.m_58904_();
        world.m_7731_(pos, this.builder.apply(MachineState.IDLE, world.m_8055_(pos)), 10);
    }

    @Override
    public void onRemove(TileEntityBasicMultiMachine<?> machine, BlockPos pos, StructureResult result, int count) {
        super.onRemove(machine, pos, result, count);
        if (count == 0) {
            Level world = machine.m_58904_();
            BlockState state = world.m_8055_(pos);
            if (this.built.evaluate((LevelReader)machine.m_58904_(), pos, state)) {
                world.m_7731_(pos, this.builder.apply(MachineState.INVALID_STRUCTURE, world.m_8055_(pos)), 10);
            }
        }
    }

    @Override
    public void onStateChange(TileEntityBasicMultiMachine<?> machine, MachineState newState, BlockPos pos, StructureResult result, int count) {
        super.onStateChange(machine, newState, pos, result, count);
        Level world = machine.m_58904_();
        BlockState bs = this.builder.apply(newState, world.m_8055_(pos));
        if (!bs.equals(world.m_8055_(pos))) {
            world.m_7731_(pos, bs, 10);
        }
    }
}

