/*
 * Decompiled with CFR 0.152.
 */
package muramasa.antimatter.registration.forge;

import com.google.gson.JsonObject;
import java.util.List;
import muramasa.antimatter.Antimatter;
import muramasa.antimatter.AntimatterAPI;
import muramasa.antimatter.Data;
import muramasa.antimatter.MaterialDataInit;
import muramasa.antimatter.block.AntimatterItemBlock;
import muramasa.antimatter.event.MaterialEvent;
import muramasa.antimatter.fluid.AntimatterFluid;
import muramasa.antimatter.integration.kubejs.AntimatterKubeJS;
import muramasa.antimatter.recipe.forge.condition.ConfigCondition;
import muramasa.antimatter.recipe.forge.condition.TomlConfigCondition;
import muramasa.antimatter.recipe.ingredient.IAntimatterIngredientSerializer;
import muramasa.antimatter.registration.IAntimatterRegistrar;
import muramasa.antimatter.registration.IItemBlockProvider;
import muramasa.antimatter.registration.IRegistryEntryProvider;
import muramasa.antimatter.registration.RegistrationEvent;
import muramasa.antimatter.registration.RegistryType;
import muramasa.antimatter.tool.AntimatterToolType;
import muramasa.antimatter.tool.IAntimatterArmor;
import muramasa.antimatter.tool.IAntimatterTool;
import muramasa.antimatter.tool.armor.AntimatterArmorType;
import muramasa.antimatter.worldgen.feature.IAntimatterFeature;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraftforge.common.crafting.CraftingHelper;
import net.minecraftforge.common.crafting.IIngredientSerializer;
import net.minecraftforge.common.crafting.conditions.IConditionSerializer;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ModContainer;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;

@Mod.EventBusSubscriber(modid="antimatter", bus=Mod.EventBusSubscriber.Bus.MOD)
public final class AntimatterRegistration {
    @SubscribeEvent
    public static void onRegister(RegistryEvent.Register<?> e) {
        String domain = ModLoadingContext.get().getActiveNamespace();
        List list2 = AntimatterAPI.all(IAntimatterRegistrar.class).stream().sorted((c1, c2) -> Integer.compare(c2.getPriority(), c1.getPriority())).toList();
        if (list2.size() < 4) {
            Antimatter.LOGGER.info("Mod ID: " + domain + " & event: " + e.getRegistry().getRegistryName());
        }
        AntimatterRegistration.onRegister(domain, e);
        AntimatterRegistration.onRegister("antimatter_shared", e);
        List list = AntimatterAPI.all(IAntimatterRegistrar.class).stream().sorted((c1, c2) -> Integer.compare(c2.getPriority(), c1.getPriority())).toList();
        list.forEach(r -> AntimatterRegistration.onRegister(r.getId(), e));
    }

    public static void onRegister(String domain, RegistryEvent.Register<?> e) {
        ModContainer previous = ModLoadingContext.get().getActiveContainer();
        ModContainer newContainer = ModList.get().getModContainerById(domain).orElse(null);
        if (newContainer == null) {
            return;
        }
        if (!domain.equals("antimatter")) {
            ModLoadingContext.get().setActiveContainer(newContainer);
        }
        if (domain.equals("antimatter")) {
            List list = AntimatterAPI.all(IAntimatterRegistrar.class).stream().sorted((c1, c2) -> Integer.compare(c2.getPriority(), c1.getPriority())).toList();
            if (e.getRegistry() == ForgeRegistries.BLOCKS) {
                AntimatterAPI.onRegistration(RegistrationEvent.DATA_INIT);
                AntimatterAPI.all(SoundEvent.class, t -> {
                    if (t.getRegistryName() == null) {
                        t.setRegistryName(t.m_11660_());
                    }
                });
                MaterialEvent event = new MaterialEvent();
                MaterialDataInit.onMaterialEvent(event);
                list.forEach(r -> r.onMaterialEvent(event));
                if (AntimatterAPI.isModLoaded("kubejs")) {
                    AntimatterKubeJS.loadMaterialEvent(event);
                }
                Data.postInit();
            }
            AntimatterAPI.all(IRegistryEntryProvider.class, domain, p -> p.onRegistryBuild(AntimatterRegistration.getRegistryType(e.getRegistry())));
            AntimatterAPI.all(IRegistryEntryProvider.class, "antimatter_shared", p -> p.onRegistryBuild(AntimatterRegistration.getRegistryType(e.getRegistry())));
            list.forEach(r -> AntimatterAPI.all(IRegistryEntryProvider.class, r.getDomain(), p -> p.onRegistryBuild(AntimatterRegistration.getRegistryType(e.getRegistry()))));
        }
        if (e.getRegistry() == ForgeRegistries.BLOCKS) {
            AntimatterAPI.all(Block.class, domain, (b, d, i) -> {
                IItemBlockProvider pb;
                if (b.getRegistryName() == null) {
                    b.setRegistryName(d, i);
                }
                if (!(b instanceof IItemBlockProvider) || (pb = (IItemBlockProvider)b).generateItemBlock()) {
                    AntimatterItemBlock antimatterItemBlock;
                    if (b instanceof IItemBlockProvider) {
                        IItemBlockProvider pb2 = (IItemBlockProvider)b;
                        antimatterItemBlock = pb2.getItemBlock();
                    } else {
                        antimatterItemBlock = new AntimatterItemBlock((Block)b);
                    }
                    AntimatterAPI.register(Item.class, i, d, (Object)antimatterItemBlock);
                }
                e.getRegistry().register((IForgeRegistryEntry)b);
            });
        } else if (e.getRegistry() == ForgeRegistries.ITEMS) {
            AntimatterAPI.all(Item.class, domain, (i, d, id) -> {
                if (i.getRegistryName() == null) {
                    i.setRegistryName(d, id);
                }
                e.getRegistry().register((IForgeRegistryEntry)i);
            });
            AntimatterRegistration.registerTools(domain, e.getRegistry());
        } else if (e.getRegistry() == ForgeRegistries.BLOCK_ENTITIES) {
            AntimatterAPI.all(BlockEntityType.class, domain, (t, d, i) -> {
                if (t.getRegistryName() == null) {
                    t.setRegistryName(d, i);
                }
                e.getRegistry().register((IForgeRegistryEntry)t);
            });
        } else if (e.getRegistry() == ForgeRegistries.FLUIDS) {
            AntimatterAPI.all(AntimatterFluid.class, domain, f -> {
                if (f.getFluid().getRegistryName() == null) {
                    f.getFluid().setRegistryName(domain, f.getId());
                }
                if (f.getFlowingFluid().getRegistryName() == null) {
                    f.getFlowingFluid().setRegistryName(domain, "flowing_".concat(f.getId()));
                }
                e.getRegistry().registerAll(new IForgeRegistryEntry[]{f.getFluid(), f.getFlowingFluid()});
            });
        } else if (e.getRegistry() == ForgeRegistries.CONTAINERS) {
            AntimatterAPI.all(MenuType.class, domain, (h, d, i) -> {
                if (h.getRegistryName() == null) {
                    h.setRegistryName(d, i);
                }
                e.getRegistry().register((IForgeRegistryEntry)h);
            });
        } else if (e.getRegistry() == ForgeRegistries.SOUND_EVENTS) {
            AntimatterAPI.all(SoundEvent.class, domain, (t, d, i) -> {
                if (t.getRegistryName() == null) {
                    t.setRegistryName(d, i);
                }
                e.getRegistry().register((IForgeRegistryEntry)t);
            });
        } else if (e.getRegistry() == ForgeRegistries.RECIPE_SERIALIZERS) {
            AntimatterAPI.all(IAntimatterIngredientSerializer.class, domain, (s, d, i) -> {
                IIngredientSerializer serializer = new IIngredientSerializer((IAntimatterIngredientSerializer)s){
                    final /* synthetic */ IAntimatterIngredientSerializer val$s;
                    {
                        this.val$s = iAntimatterIngredientSerializer;
                    }

                    public Ingredient parse(FriendlyByteBuf arg) {
                        return this.val$s.parse(arg);
                    }

                    public Ingredient parse(JsonObject jsonObject) {
                        return this.val$s.parse(jsonObject);
                    }

                    public void write(FriendlyByteBuf arg, Ingredient arg2) {
                        this.val$s.write(arg, arg2);
                    }
                };
                AntimatterAPI.register(IIngredientSerializer.class, i, d, serializer);
                CraftingHelper.register((ResourceLocation)new ResourceLocation(d, i), (IIngredientSerializer)serializer);
            });
            if (domain.equals("antimatter")) {
                CraftingHelper.register((IConditionSerializer)ConfigCondition.Serializer.INSTANCE);
                CraftingHelper.register((IConditionSerializer)TomlConfigCondition.Serializer.INSTANCE);
            }
            AntimatterAPI.all(RecipeSerializer.class, domain, (r, d, i) -> {
                if (r.getRegistryName() == null) {
                    r.setRegistryName(new ResourceLocation(d, i));
                }
                e.getRegistry().register((IForgeRegistryEntry)r);
            });
        } else if (e.getRegistry() == ForgeRegistries.FEATURES) {
            AntimatterAPI.all(IAntimatterFeature.class, domain, (t, d, i) -> {
                if (t.asFeature().getRegistryName() == null) {
                    t.asFeature().setRegistryName(d, i);
                }
                e.getRegistry().register(t.asFeature());
            });
        }
        if (!domain.equals("antimatter")) {
            ModLoadingContext.get().setActiveContainer(previous);
        }
    }

    public static void registerTools(String domain, IForgeRegistry registry) {
        AntimatterAPI.all(AntimatterToolType.class, domain, t -> {
            if (t.isPowered()) {
                for (IAntimatterTool i : t.instantiatePoweredTools(domain)) {
                    if (i.getItem().getRegistryName() == null) {
                        i.getItem().setRegistryName(domain, i.getId());
                    }
                    registry.register((IForgeRegistryEntry)i.getItem());
                }
            } else {
                IAntimatterTool i = t.instantiateTools(domain);
                if (i.getItem().getRegistryName() == null) {
                    i.getItem().setRegistryName(domain, i.getId());
                }
                registry.register((IForgeRegistryEntry)i.getItem());
            }
        });
        if (!domain.equals("antimatter_shared")) {
            return;
        }
        AntimatterAPI.all(AntimatterArmorType.class, t -> {
            List<IAntimatterArmor> i = t.instantiateTools();
            i.forEach(a -> {
                if (a.getItem().getRegistryName() == null) {
                    a.getItem().setRegistryName("antimatter_shared", a.getId());
                }
                registry.register((IForgeRegistryEntry)a.getItem());
            });
        });
    }

    public static RegistryType getRegistryType(IForgeRegistry<?> registry) {
        if (registry == ForgeRegistries.BLOCKS) {
            return RegistryType.BLOCKS;
        }
        if (registry == ForgeRegistries.ITEMS) {
            return RegistryType.ITEMS;
        }
        if (registry == ForgeRegistries.FLUIDS) {
            return RegistryType.FLUIDS;
        }
        if (registry == ForgeRegistries.BLOCK_ENTITIES) {
            return RegistryType.BLOCK_ENTITIES;
        }
        return RegistryType.WORLD;
    }
}

