/*
 * Decompiled with CFR 0.152.
 */
package muramasa.antimatter.recipe.map;

import com.mojang.datafixers.util.Either;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import muramasa.antimatter.AntimatterAPI;
import muramasa.antimatter.gui.GuiData;
import muramasa.antimatter.integration.jeirei.renderer.IRecipeInfoRenderer;
import muramasa.antimatter.integration.jeirei.renderer.InfoRenderers;
import muramasa.antimatter.machine.Tier;
import muramasa.antimatter.machine.types.Machine;
import muramasa.antimatter.recipe.IRecipe;
import muramasa.antimatter.recipe.RecipeUtil;
import muramasa.antimatter.recipe.ingredient.AbstractMapIngredient;
import muramasa.antimatter.recipe.ingredient.FluidIngredient;
import muramasa.antimatter.recipe.ingredient.MapFluidIngredient;
import muramasa.antimatter.recipe.ingredient.MapItemIngredient;
import muramasa.antimatter.recipe.ingredient.MapItemStackIngredient;
import muramasa.antimatter.recipe.ingredient.MapTagIngredient;
import muramasa.antimatter.recipe.ingredient.RecipeIngredient;
import muramasa.antimatter.recipe.ingredient.SpecialIngredientWrapper;
import muramasa.antimatter.recipe.map.IRecipeMap;
import muramasa.antimatter.recipe.map.Proxy;
import muramasa.antimatter.recipe.map.RecipeBuilder;
import muramasa.antimatter.registration.ISharedAntimatterObject;
import muramasa.antimatter.util.Utils;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Tuple;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fluids.FluidStack;

public class RecipeMap<B extends RecipeBuilder>
implements ISharedAntimatterObject,
IRecipeMap {
    private static final ItemStack[] EMPTY_ITEM = new ItemStack[0];
    private static final FluidStack[] EMPTY_FLUID = new FluidStack[0];
    private final ResourceLocation loc;
    private final String domainCreatedWith;
    private final B builder;
    private final Branch LOOKUP = new Branch();
    private final List<IRecipe> RECIPES_TO_COMPILE = new ObjectArrayList();
    private final Set<AbstractMapIngredient> ROOT = new ObjectOpenHashSet();
    private final List<AbstractMapIngredient> ROOT_SPECIAL = new ObjectArrayList();
    @Nullable
    private GuiData GUI;
    @Nullable
    private Tier guiTier;
    @Nullable
    private Proxy PROXY;
    @Nullable
    private Object icon;
    @OnlyIn(value=Dist.CLIENT)
    private IRecipeInfoRenderer infoRenderer;

    public RecipeMap(String domain, String categoryId, B builder) {
        this.loc = new ResourceLocation("antimatter_shared", categoryId);
        this.domainCreatedWith = domain;
        this.builder = builder;
        ((RecipeBuilder)this.builder).setMap(this);
        AntimatterAPI.register(IRecipeMap.class, this);
    }

    public static ItemStack[] uniqueItems(ItemStack[] input) {
        ObjectArrayList list = new ObjectArrayList(input.length);
        block0: for (ItemStack item : input) {
            for (ItemStack obj : list) {
                if (!ItemStack.m_41728_((ItemStack)item, (ItemStack)obj)) continue;
                obj.m_41769_(item.m_41613_());
                continue block0;
            }
            list.add(item.m_41777_());
        }
        return list.toArray(new ItemStack[0]);
    }

    @Override
    @Nullable
    public Tier getGuiTier() {
        return this.guiTier;
    }

    public RecipeMap<B> setIcon(Object object) {
        this.icon = object;
        return this;
    }

    @Override
    @Nullable
    public Object getIcon() {
        return this.icon;
    }

    @Override
    @Nonnull
    @OnlyIn(value=Dist.CLIENT)
    public IRecipeInfoRenderer getInfoRenderer() {
        if (this.infoRenderer == null) {
            return InfoRenderers.DEFAULT_RENDERER;
        }
        return this.infoRenderer;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void setInfoRenderer(IRecipeInfoRenderer renderer) {
        this.infoRenderer = renderer;
    }

    public RecipeMap<B> setGuiTier(Tier tier) {
        this.guiTier = tier;
        return this;
    }

    public RecipeMap<B> setGuiData(GuiData gui) {
        this.GUI = gui;
        AntimatterAPI.registerJEICategory(this, this.GUI);
        return this;
    }

    public RecipeMap<B> setGuiData(GuiData gui, Machine<?> machine) {
        this.GUI = gui;
        AntimatterAPI.registerJEICategory(this, this.GUI, machine, true);
        return this;
    }

    public RecipeMap<B> setProxy(Proxy proxy) {
        this.PROXY = proxy;
        return this;
    }

    @Override
    @Nullable
    public GuiData getGui() {
        return this.GUI;
    }

    @Override
    public String getId() {
        return this.loc.m_135815_();
    }

    public B RB() {
        ((RecipeBuilder)this.builder).clear();
        return this.builder;
    }

    @Override
    public Collection<IRecipe> getRecipes(boolean filterHidden) {
        return this.LOOKUP.getRecipes(filterHidden).sorted(Comparator.comparingLong(IRecipe::getPower)).collect(Collectors.toCollection(LinkedHashSet::new));
    }

    @Override
    public void add(IRecipe recipe) {
        this.RECIPES_TO_COMPILE.add(recipe);
    }

    @Override
    public void compileRecipe(IRecipe recipe) {
        List<List<AbstractMapIngredient>> items;
        if (recipe == null) {
            return;
        }
        if (recipe.hasOutputItems()) {
            for (ItemStack stack : recipe.getOutputItems()) {
                if (!stack.m_41619_()) continue;
                Utils.onInvalidData("RECIPE WITH EMPTY OUTPUT ITEM");
                return;
            }
        }
        boolean flag = false;
        if (recipe.hasInputItems()) {
            for (Ingredient inputItem : recipe.getInputItems()) {
                if (RecipeMap.isIngredientSpecial(inputItem)) {
                    flag = true;
                    continue;
                }
                if (!inputItem.m_43947_() && (inputItem.m_43908_().length != 1 || inputItem.m_43908_()[0].m_41720_() != Items.f_42127_)) continue;
                Utils.onInvalidData("RECIPE WITH EMPTY INPUT (MAP): " + this.loc.m_135815_());
                return;
            }
        }
        if (flag) {
            recipe.sortInputItems();
        }
        if (this.recurseItemTreeAdd(recipe, items = this.fromRecipe(recipe, true), this.LOOKUP, 0, 0)) {
            items.forEach(t -> t.forEach(ing -> {
                if (!ing.isSpecial()) {
                    this.ROOT.add((AbstractMapIngredient)ing);
                } else {
                    this.ROOT_SPECIAL.add((AbstractMapIngredient)ing);
                }
            }));
        }
        recipe.setMapId(this.loc.m_135815_());
    }

    protected void buildFromFluids(List<List<AbstractMapIngredient>> builder, List<FluidIngredient> ingredients, boolean insideMap) {
        for (FluidIngredient t : ingredients) {
            ObjectArrayList inner = new ObjectArrayList(t.getStacks().length);
            for (FluidStack stack : t.getStacks()) {
                inner.add(new MapFluidIngredient(stack, insideMap));
            }
            builder.add((List<AbstractMapIngredient>)inner);
        }
    }

    protected void buildFromFluidStacks(List<List<AbstractMapIngredient>> builder, List<FluidStack> ingredients, boolean insideMap) {
        for (FluidStack t : ingredients) {
            builder.add(Collections.singletonList(new MapFluidIngredient(t, insideMap)));
        }
    }

    protected List<List<AbstractMapIngredient>> fromRecipe(IRecipe r, boolean insideMap) {
        ObjectArrayList list = new ObjectArrayList((r.hasInputItems() ? r.getInputItems().size() : 0) + (r.hasInputFluids() ? r.getInputFluids().size() : 0));
        if (r.hasInputItems()) {
            this.buildFromItems((List<List<AbstractMapIngredient>>)list, r.getInputItems(), insideMap);
        }
        if (r.hasInputFluids()) {
            this.buildFromFluids((List<List<AbstractMapIngredient>>)list, r.getInputFluids(), insideMap);
        }
        return list;
    }

    protected void buildFromItems(List<List<AbstractMapIngredient>> list, List<Ingredient> ingredients, boolean insideMap) {
        for (Ingredient t : ingredients) {
            if (!RecipeMap.isIngredientSpecial(t)) {
                Optional rl = Optional.empty();
                if (rl.isPresent()) {
                    list.add(Collections.singletonList(new MapTagIngredient((ResourceLocation)rl.get(), insideMap)));
                    continue;
                }
                ObjectArrayList inner = new ObjectArrayList(t.m_43908_().length);
                for (ItemStack stack : t.m_43908_()) {
                    if (t instanceof RecipeIngredient && ((RecipeIngredient)t).ignoreNbt()) {
                        inner.add(new MapItemIngredient(stack.m_41720_(), insideMap));
                        continue;
                    }
                    inner.add(new MapItemStackIngredient(stack, insideMap));
                }
                list.add((List<AbstractMapIngredient>)inner);
                continue;
            }
            list.add(Collections.singletonList(new SpecialIngredientWrapper(t)));
        }
    }

    protected void buildFromItemStacks(List<List<AbstractMapIngredient>> list, ItemStack[] ingredients) {
        for (ItemStack t : ingredients) {
            int c = (int)t.m_41720_().m_204114_().m_203616_().count();
            ObjectArrayList ls = new ObjectArrayList(2 + c);
            ls.add(new MapItemIngredient(t.m_41720_(), false));
            ls.add(new MapItemStackIngredient(t, false));
            list.add((List<AbstractMapIngredient>)ls);
        }
    }

    boolean recurseItemTreeAdd(@Nonnull IRecipe recipe, @Nonnull List<List<AbstractMapIngredient>> ingredients, @Nonnull Branch map, int index, int count) {
        if (count >= ingredients.size()) {
            return true;
        }
        if (index >= ingredients.size()) {
            throw new RuntimeException("Index out of bounds for recurseItemTreeAdd, should not happen");
        }
        List<AbstractMapIngredient> current = ingredients.get(index);
        for (AbstractMapIngredient obj : current) {
            if (!obj.isSpecial()) {
                Either r = map.NODES.compute(obj, (k, v) -> {
                    if (count == ingredients.size() - 1) {
                        if (v == null) {
                            v = Either.left((Object)new ObjectArrayList());
                        }
                        v.ifLeft(list -> list.add(recipe));
                        return v;
                    }
                    if (v == null) {
                        Branch traverse = new Branch();
                        v = Either.right((Object)traverse);
                    }
                    return v;
                });
                if (count == ingredients.size() - 1 || !r.right().map(m -> !this.recurseItemTreeAdd(recipe, ingredients, (Branch)m, (index + 1) % ingredients.size(), count + 1)).orElse(false).booleanValue()) continue;
                current.forEach(map.NODES::remove);
                return false;
            }
            if (count == ingredients.size() - 1) {
                map.SPECIAL_NODES.add((Tuple<AbstractMapIngredient, Either<IRecipe, Branch>>)new Tuple((Object)obj, (Object)Either.left((Object)recipe)));
                continue;
            }
            Branch branch = new Branch();
            boolean ok = this.recurseItemTreeAdd(recipe, ingredients, branch, (index + 1) % ingredients.size(), count + 1);
            if (!ok) {
                current.forEach(map.NODES::remove);
                return false;
            }
            map.SPECIAL_NODES.add((Tuple<AbstractMapIngredient, Either<IRecipe, Branch>>)new Tuple((Object)obj, (Object)Either.right((Object)branch)));
        }
        return true;
    }

    IRecipe recurseItemTreeFind(@Nonnull List<List<AbstractMapIngredient>> items, @Nonnull Branch map, @Nonnull Predicate<IRecipe> canHandle) {
        for (int i = 0; i < items.size(); ++i) {
            IRecipe r = this.recurseItemTreeFind(items, map, canHandle, i, 0, 1L << i);
            if (r == null) continue;
            return r;
        }
        return null;
    }

    IRecipe recurseItemTreeFind(@Nonnull List<List<AbstractMapIngredient>> items, @Nonnull Branch map, @Nonnull Predicate<IRecipe> canHandle, int index, int count, long skip) {
        if (count == items.size()) {
            return null;
        }
        List<AbstractMapIngredient> wr = items.get(index);
        for (AbstractMapIngredient t : wr) {
            IRecipe r2;
            Either<List<IRecipe>, Branch> result = map.NODES.get(t);
            if (result != null && (r2 = (IRecipe)result.map(left -> {
                for (IRecipe recipe : left) {
                    if (!canHandle.test(recipe)) continue;
                    return recipe;
                }
                return null;
            }, right -> this.callback(items, (Branch)right, canHandle, index, count, skip))) != null) {
                return r2;
            }
            if (map.SPECIAL_NODES.size() <= 0) continue;
            for (Tuple<AbstractMapIngredient, Either<IRecipe, Branch>> tuple : map.SPECIAL_NODES) {
                AbstractMapIngredient special = (AbstractMapIngredient)tuple.m_14418_();
                if (!special.equals(t)) continue;
                return (IRecipe)((Either)tuple.m_14419_()).map(r -> canHandle.test((IRecipe)r) ? r : null, branch -> this.callback(items, (Branch)branch, canHandle, index, count, skip));
            }
        }
        return null;
    }

    private IRecipe callback(@Nonnull List<List<AbstractMapIngredient>> items, @Nonnull Branch map, Predicate<IRecipe> canHandle, int index, int count, long skip) {
        int counter = (index + 1) % items.size();
        while (counter != index) {
            IRecipe found;
            if ((skip & 1L << counter) == 0L && (found = this.recurseItemTreeFind(items, map, canHandle, counter, count + 1, skip | 1L << counter)) != null) {
                return found;
            }
            counter = (counter + 1) % items.size();
        }
        return null;
    }

    @Override
    @Nullable
    public IRecipe find(@Nonnull ItemStack[] items, @Nonnull FluidStack[] fluids, Tier tier, @Nonnull Predicate<IRecipe> canHandle) {
        if (items.length + fluids.length > 64) {
            Utils.onInvalidData("ERROR! TOO LARGE INPUT IN RECIPEMAP, time to fix a real bitmap. Probably never get this!");
            return null;
        }
        if (items.length == 0 && fluids.length == 0) {
            return null;
        }
        ObjectArrayList list = new ObjectArrayList(items.length + fluids.length);
        if (items.length > 0) {
            this.buildFromItemStacks((List<List<AbstractMapIngredient>>)list, RecipeMap.uniqueItems(items));
        }
        if (fluids.length > 0) {
            ObjectArrayList stack = new ObjectArrayList(fluids.length);
            for (FluidStack f : fluids) {
                if (f.isEmpty()) continue;
                stack.add(f);
            }
            if (stack.size() > 0) {
                this.buildFromFluidStacks((List<List<AbstractMapIngredient>>)list, (List<FluidStack>)stack, false);
            }
        }
        if (list.size() == 0) {
            return null;
        }
        IRecipe r = this.recurseItemTreeFind((List<List<AbstractMapIngredient>>)list, this.LOOKUP, canHandle);
        return r;
    }

    @Override
    public Proxy getProxy() {
        return this.PROXY;
    }

    public void reset() {
        this.RECIPES_TO_COMPILE.clear();
    }

    @Override
    public void resetCompiled() {
        this.getRecipes(false).forEach(IRecipe::invalidate);
        this.LOOKUP.clear();
        this.ROOT.clear();
        this.ROOT_SPECIAL.clear();
    }

    @Override
    public void compile(RecipeManager reg) {
        this.resetCompiled();
        if (this.RECIPES_TO_COMPILE.size() > 0) {
            ObjectArrayList regular = new ObjectArrayList(this.RECIPES_TO_COMPILE.size());
            ObjectArrayList special = new ObjectArrayList();
            for (IRecipe recipe : this.RECIPES_TO_COMPILE) {
                if (recipe.hasSpecialIngredients()) {
                    special.add(recipe);
                    continue;
                }
                regular.add(recipe);
            }
            special.forEach(this::compileRecipe);
            regular.forEach(this::compileRecipe);
        }
        this.LOOKUP.finish();
    }

    @Override
    public boolean acceptsItem(ItemStack item) {
        MapItemStackIngredient i = new MapItemStackIngredient(item, false);
        MapItemIngredient j = new MapItemIngredient(item.m_41720_(), false);
        if (this.ROOT.contains(i)) {
            return true;
        }
        if (this.ROOT.contains(j)) {
            return true;
        }
        MapTagIngredient tag = new MapTagIngredient(null, false);
        return item.m_41720_().m_204114_().m_203616_().anyMatch(t -> {
            tag.setTag(t.f_203868_());
            if (this.ROOT.contains(tag)) {
                return true;
            }
            return this.ROOT_SPECIAL.contains(tag);
        });
    }

    @Override
    public boolean acceptsFluid(FluidStack fluid) {
        MapFluidIngredient i = new MapFluidIngredient(fluid, false);
        if (this.ROOT.contains(i)) {
            return true;
        }
        MapTagIngredient tag = new MapTagIngredient(null, false);
        return fluid.getFluid().m_205069_().m_203616_().anyMatch(t -> {
            tag.setTag(t.f_203868_());
            return this.ROOT.contains(tag);
        });
    }

    public static boolean isIngredientSpecial(Ingredient i) {
        Class<?> clazz = i.getClass();
        if (clazz == RecipeIngredient.class) {
            return false;
        }
        return clazz != Ingredient.class && !RecipeUtil.isNBTIngredient(clazz) && !RecipeUtil.isCompoundIngredient(clazz);
    }

    protected static class Branch {
        private Map<AbstractMapIngredient, Either<List<IRecipe>, Branch>> NODES = new Object2ObjectOpenHashMap();
        private final List<Tuple<AbstractMapIngredient, Either<IRecipe, Branch>>> SPECIAL_NODES = new ObjectArrayList();

        protected Branch() {
        }

        public Stream<IRecipe> getRecipes(boolean filterHidden) {
            Stream<IRecipe> stream = this.NODES.values().stream().flatMap(t -> (Stream)t.map(Collection::stream, branch -> branch.getRecipes(filterHidden)));
            if (this.SPECIAL_NODES.size() > 0) {
                stream = Stream.concat(stream, this.SPECIAL_NODES.stream().flatMap(t -> (Stream)((Either)t.m_14419_()).map(Stream::of, branch -> branch.getRecipes(filterHidden))));
            }
            if (filterHidden) {
                stream = stream.filter(t -> !t.isHidden());
            }
            return stream;
        }

        public void clear() {
            this.NODES = new Object2ObjectOpenHashMap();
            this.SPECIAL_NODES.clear();
        }

        public void finish() {
        }
    }
}

