/*
 * Decompiled with CFR 0.152.
 */
package muramasa.antimatter.recipe.map;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import it.unimi.dsi.fastutil.objects.Object2ObjectArrayMap;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import muramasa.antimatter.datagen.AntimatterDynamics;
import muramasa.antimatter.recipe.IRecipe;
import muramasa.antimatter.recipe.Recipe;
import muramasa.antimatter.recipe.RecipeTag;
import muramasa.antimatter.recipe.RecipeUtil;
import muramasa.antimatter.recipe.ingredient.FluidIngredient;
import muramasa.antimatter.recipe.map.RecipeMap;
import muramasa.antimatter.recipe.serializer.AntimatterRecipeSerializer;
import muramasa.antimatter.util.AntimatterPlatformUtils;
import muramasa.antimatter.util.Utils;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.AdvancementRewards;
import net.minecraft.advancements.CriterionTriggerInstance;
import net.minecraft.advancements.RequirementsStrategy;
import net.minecraft.advancements.critereon.RecipeUnlockedTrigger;
import net.minecraft.data.recipes.FinishedRecipe;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraftforge.fluids.FluidStack;
import org.jetbrains.annotations.Nullable;

public class RecipeBuilder {
    private static final Map<String, IRecipe> ID_MAP = new Object2ObjectArrayMap();
    private static String CURRENT_MOD_ID = "antimatter_shared";
    private RecipeMap<? extends RecipeBuilder> recipeMap;
    protected List<ItemStack> itemsOutput = new ObjectArrayList();
    protected List<Ingredient> ingredientInput = new ObjectArrayList();
    protected List<FluidIngredient> fluidsInput = new ObjectArrayList();
    protected List<FluidStack> fluidsOutput = new ObjectArrayList();
    protected int[] chances;
    protected int duration;
    protected int special;
    protected long power;
    protected int amps;
    protected boolean hidden;
    protected Set<RecipeTag> tags = new ObjectOpenHashSet();
    protected ResourceLocation id;
    protected boolean recipeMapOnly = false;
    private Advancement.Builder advancementBuilder = null;

    public IRecipe add(String modid, String id) {
        this.id(modid, id);
        return this.build();
    }

    public IRecipe add(String id) {
        return this.add(this.recipeMap.getDomain(), id);
    }

    public static void clearList() {
        ID_MAP.clear();
    }

    public static Map<String, IRecipe> getIdMap() {
        return ID_MAP;
    }

    public static void setCurrentModId(String id) {
        CURRENT_MOD_ID = id;
    }

    protected void addToMap(IRecipe r) {
        this.recipeMap.add(r);
    }

    public IRecipe build() {
        if (this.itemsOutput != null && this.itemsOutput.size() > 0 && !Utils.areItemsValid(this.itemsOutput.toArray(new ItemStack[0]))) {
            String id = this.id == null ? "" : " Recipe ID: " + this.id;
            Utils.onInvalidData("RECIPE BUILDER ERROR - OUTPUT ITEMS INVALID!" + id + " Recipe map ID:" + this.recipeMap.getId());
            return Utils.getEmptyRecipe();
        }
        if (this.fluidsOutput != null && this.fluidsOutput.size() > 0 && !Utils.areFluidsValid(this.fluidsOutput.toArray(new FluidStack[0]))) {
            String id = this.id == null ? "" : " Recipe ID: " + this.id;
            Utils.onInvalidData("RECIPE BUILDER ERROR - OUTPUT FLUIDS INVALID!" + id + " Recipe map ID:" + this.recipeMap.getId());
            return Utils.getEmptyRecipe();
        }
        if (this.ingredientInput == null) {
            this.ingredientInput = Collections.emptyList();
        }
        if (this.amps < 1) {
            this.amps = 1;
        }
        if (!this.recipeMapOnly) {
            ResourceLocation advancementID;
            ResourceLocation resourceLocation = advancementID = this.advancementBuilder != null ? new ResourceLocation(this.id.m_135827_(), "recipes/" + this.id.m_135815_()) : null;
            if (this.advancementBuilder != null) {
                this.advancementBuilder.m_138396_(new ResourceLocation("recipes/root")).m_138386_("has_the_recipe", (CriterionTriggerInstance)RecipeUnlockedTrigger.m_63728_((ResourceLocation)this.id)).m_138354_(AdvancementRewards.Builder.m_10009_((ResourceLocation)this.id)).m_138360_(RequirementsStrategy.f_15979_);
            }
            AntimatterDynamics.FINISHED_RECIPE_CONSUMER.accept(new Result(this.id, advancementID));
        }
        if (this.amps < 1) {
            this.amps = 1;
        }
        Recipe recipe = new Recipe(this.ingredientInput, this.itemsOutput != null ? this.itemsOutput.toArray(new ItemStack[0]) : null, this.fluidsInput != null ? this.fluidsInput : Collections.emptyList(), this.fluidsOutput != null ? this.fluidsOutput.toArray(new FluidStack[0]) : null, this.duration, this.power, this.special, this.amps);
        if (this.chances != null) {
            recipe.addChances(this.chances);
        }
        recipe.setHidden(this.hidden);
        recipe.addTags((Set<RecipeTag>)new ObjectOpenHashSet(this.tags));
        return recipe;
    }

    public void getID() {
        if (this.id == null) {
            if (this.itemsOutput != null && this.itemsOutput.size() > 0) {
                String id = AntimatterPlatformUtils.getIdFromItem(this.itemsOutput.get(0).m_41720_()).toString() + "_recipe";
                this.checkID(id);
            } else if (this.fluidsOutput != null && this.fluidsOutput.size() > 0) {
                String id = AntimatterPlatformUtils.getIdFromFluid(this.fluidsOutput.get(0).getFluid()).toString() + "_recipe";
                this.checkID(id);
            } else if (!this.ingredientInput.isEmpty() && this.ingredientInput.get(0).m_43908_().length > 0) {
                ItemStack stack = this.ingredientInput.get(0).m_43908_()[0];
                String id = AntimatterPlatformUtils.getIdFromItem(stack.m_41720_()).toString() + "_recipe";
                this.checkID(id);
            } else if (!this.fluidsInput.isEmpty()) {
                List<FluidStack> list;
                FluidIngredient ing = this.fluidsInput.get(0);
                String id = ing.getTag() != null ? ing.getTag().f_203868_().toString() + "_recipe" : (!(list = Arrays.asList(ing.getStacks())).isEmpty() ? AntimatterPlatformUtils.getIdFromFluid(list.get(0).getFluid()).toString() + "_recipe" : "antimatter:unknown_in_" + this.recipeMap.getId());
                this.checkID(id);
            }
        }
    }

    private void checkID(String id) {
        if (ID_MAP.containsKey(id)) {
            String newID;
            int i = 1;
            do {
                newID = (String)id + "_" + i;
                ++i;
            } while (ID_MAP.containsKey(newID));
            id = newID;
        }
        this.id = new ResourceLocation((String)id);
    }

    public IRecipe add(String id, long duration, long power, long special) {
        return this.add(id, duration, power, special, 1);
    }

    public IRecipe add(String domain, String id, long duration, long power, long special, int amps) {
        this.duration = (int)duration;
        this.power = power;
        this.special = (int)special;
        this.amps = amps;
        return this.add(domain, id);
    }

    public IRecipe add(String id, long duration, long power, long special, int amps) {
        return this.add(CURRENT_MOD_ID, id, duration, power, special, amps);
    }

    public IRecipe add(String id, long duration, long power) {
        return this.add(id, duration, power, this.special);
    }

    public IRecipe add(String id, long duration) {
        return this.add(id, duration, 0L, this.special);
    }

    public RecipeBuilder ii(Ingredient ... stacks) {
        this.ingredientInput.addAll(Arrays.asList(stacks));
        return this;
    }

    public RecipeBuilder ii(List<Ingredient> stacks) {
        this.ingredientInput.addAll(stacks);
        return this;
    }

    public RecipeBuilder io(ItemStack ... stacks) {
        this.itemsOutput.addAll(Arrays.asList(stacks));
        return this;
    }

    public RecipeBuilder io(Item ... stacks) {
        this.itemsOutput.addAll(Arrays.stream(stacks).map(Item::m_7968_).toList());
        return this;
    }

    public RecipeBuilder io(List<ItemStack> stacks) {
        this.itemsOutput.addAll(stacks);
        return this;
    }

    public RecipeBuilder fi(FluidStack ... stacks) {
        this.fluidsInput.addAll(Arrays.stream(stacks).map(FluidIngredient::of).toList());
        return this;
    }

    public RecipeBuilder fi(FluidIngredient ... stacks) {
        this.fluidsInput.addAll(Arrays.asList(stacks));
        return this;
    }

    public RecipeBuilder fi(List<FluidStack> stacks) {
        this.fluidsInput.addAll(stacks.stream().map(FluidIngredient::of).toList());
        return this;
    }

    public RecipeBuilder fo(FluidStack ... stacks) {
        this.fluidsOutput.addAll(Arrays.asList(stacks));
        return this;
    }

    public RecipeBuilder fo(List<FluidStack> stacks) {
        this.fluidsOutput.addAll(stacks);
        return this;
    }

    public RecipeBuilder id(ResourceLocation id) {
        this.id = id;
        return this;
    }

    public RecipeBuilder id(String modid, String name) {
        return this.id(new ResourceLocation(modid, this.recipeMap.getId() + "/" + name));
    }

    public RecipeBuilder id(String name) {
        return this.id(this.recipeMap.getDomain(), name);
    }

    public RecipeBuilder chances(double ... values) {
        int[] newChances = new int[values.length];
        for (int i = 0; i < values.length; ++i) {
            double chance = values[i];
            newChances[i] = (int)(chance * 10000.0);
        }
        return this.chances(newChances);
    }

    public RecipeBuilder chances(int ... values) {
        this.chances = values;
        return this;
    }

    public RecipeBuilder hide() {
        this.hidden = true;
        return this;
    }

    public RecipeBuilder recipeMapOnly() {
        this.recipeMapOnly = true;
        return this;
    }

    public RecipeBuilder tags(RecipeTag ... tags) {
        this.tags = new ObjectOpenHashSet((Object[])tags);
        return this;
    }

    public RecipeBuilder addCriterion(String name, CriterionTriggerInstance criterionIn) {
        if (this.advancementBuilder == null) {
            this.advancementBuilder = Advancement.Builder.m_138353_();
        }
        this.advancementBuilder.m_138386_(name, criterionIn);
        return this;
    }

    public void clear() {
        this.itemsOutput = new ObjectArrayList();
        this.ingredientInput = new ObjectArrayList();
        this.fluidsInput = new ObjectArrayList();
        this.fluidsOutput = new ObjectArrayList();
        this.chances = null;
        this.special = 0;
        this.duration = 0;
        this.power = 0L;
        this.hidden = false;
        this.tags.clear();
    }

    public RecipeMap<?> getMap() {
        return this.recipeMap;
    }

    public void setMap(RecipeMap<?> recipeMap) {
        this.recipeMap = recipeMap;
    }

    private class Result
    implements FinishedRecipe {
        ResourceLocation id;
        ResourceLocation advancementID = null;

        public Result(ResourceLocation id) {
            this.id = id;
        }

        public Result(ResourceLocation id, ResourceLocation advancementID) {
            this.id = id;
            this.advancementID = advancementID;
        }

        public void m_7917_(JsonObject json) {
            JsonArray array = new JsonArray();
            for (Ingredient ingredient : RecipeBuilder.this.ingredientInput) {
                array.add(ingredient.m_43942_());
            }
            if (!array.isEmpty()) {
                json.add("item_in", (JsonElement)array);
            }
            array = new JsonArray();
            for (ItemStack itemStack : RecipeBuilder.this.itemsOutput) {
                array.add((JsonElement)RecipeUtil.itemstackToJson(itemStack));
            }
            if (!array.isEmpty()) {
                json.add("item_out", (JsonElement)array);
            }
            array = new JsonArray();
            for (FluidIngredient fluidIngredient : RecipeBuilder.this.fluidsInput) {
                array.add((JsonElement)fluidIngredient.toJson());
            }
            if (!array.isEmpty()) {
                json.add("fluid_in", (JsonElement)array);
            }
            array = new JsonArray();
            for (FluidStack fluidStack : RecipeBuilder.this.fluidsOutput) {
                array.add((JsonElement)RecipeUtil.fluidstackToJson(fluidStack));
            }
            if (!array.isEmpty()) {
                json.add("fluid_out", (JsonElement)array);
            }
            array = new JsonArray();
            json.addProperty("eu", (Number)RecipeBuilder.this.power);
            json.addProperty("duration", (Number)RecipeBuilder.this.duration);
            json.addProperty("amps", (Number)RecipeBuilder.this.amps);
            json.addProperty("special", (Number)RecipeBuilder.this.special);
            if (RecipeBuilder.this.chances != null) {
                for (Object d : (Iterator<RecipeTag>)RecipeBuilder.this.chances) {
                    array.add((Number)((int)d));
                }
            }
            if (!array.isEmpty()) {
                json.add("chances", (JsonElement)array);
            }
            json.addProperty("hidden", Boolean.valueOf(RecipeBuilder.this.hidden));
            array = new JsonArray();
            for (RecipeTag recipeTag : RecipeBuilder.this.tags) {
                array.add(recipeTag.getLoc().toString());
            }
            if (!array.isEmpty()) {
                json.add("tags", (JsonElement)array);
            }
            json.addProperty("map", RecipeBuilder.this.recipeMap.getId());
        }

        public ResourceLocation m_6445_() {
            return this.id;
        }

        public RecipeSerializer<?> m_6637_() {
            return AntimatterRecipeSerializer.INSTANCE;
        }

        @Nullable
        public JsonObject m_5860_() {
            if (RecipeBuilder.this.advancementBuilder != null) {
                return RecipeBuilder.this.advancementBuilder.m_138400_();
            }
            return null;
        }

        @Nullable
        public ResourceLocation m_6448_() {
            return this.advancementID;
        }
    }
}

