/*
 * Decompiled with CFR 0.152.
 */
package muramasa.antimatter.recipe.map;

import java.util.Collection;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import muramasa.antimatter.capability.FluidHandler;
import muramasa.antimatter.capability.Holder;
import muramasa.antimatter.capability.machine.MachineFluidHandler;
import muramasa.antimatter.capability.machine.MachineItemHandler;
import muramasa.antimatter.gui.GuiData;
import muramasa.antimatter.integration.jeirei.renderer.IRecipeInfoRenderer;
import muramasa.antimatter.integration.jeirei.renderer.InfoRenderers;
import muramasa.antimatter.machine.Tier;
import muramasa.antimatter.recipe.IRecipe;
import muramasa.antimatter.recipe.map.Proxy;
import muramasa.antimatter.registration.ISharedAntimatterObject;
import muramasa.antimatter.tile.TileEntityMachine;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.items.IItemHandler;

public interface IRecipeMap
extends ISharedAntimatterObject {
    public static final ItemStack[] EMPTY_ITEM = new ItemStack[0];
    public static final FluidStack[] EMPTY_FLUID = new FluidStack[0];

    public IRecipe find(@Nonnull ItemStack[] var1, @Nonnull FluidStack[] var2, Tier var3, @Nonnull Predicate<IRecipe> var4);

    default public IRecipe findByID(ResourceLocation id) {
        return this.getRecipes(false).stream().filter(r -> r.m_6423_().equals((Object)id)).findFirst().orElse(null);
    }

    public void add(IRecipe var1);

    public void compileRecipe(IRecipe var1);

    public void compile(RecipeManager var1);

    public void resetCompiled();

    public Collection<IRecipe> getRecipes(boolean var1);

    public boolean acceptsItem(ItemStack var1);

    public boolean acceptsFluid(FluidStack var1);

    @Nullable
    default public Tier getGuiTier() {
        return null;
    }

    default public Object getIcon() {
        return null;
    }

    default public <T extends TileEntityMachine<T>> IRecipe find(Holder<IItemHandler, MachineItemHandler<T>> itemHandler, Holder<IFluidHandler, MachineFluidHandler<T>> fluidHandler, Tier tier, Predicate<IRecipe> validateRecipe) {
        return this.find(itemHandler.map(MachineItemHandler::getInputs).orElse(EMPTY_ITEM), fluidHandler.map(FluidHandler::getInputs).orElse(EMPTY_FLUID), tier, validateRecipe);
    }

    default public IRecipe find(@Nonnull LazyOptional<MachineItemHandler<?>> itemHandler, @Nonnull LazyOptional<MachineFluidHandler<?>> fluidHandler, Tier tier, Predicate<IRecipe> validator) {
        return this.find(itemHandler.map(MachineItemHandler::getInputs).orElse(EMPTY_ITEM), fluidHandler.map(FluidHandler::getInputs).orElse(EMPTY_FLUID), tier, validator);
    }

    @Nullable
    default public GuiData getGui() {
        return null;
    }

    default public Proxy getProxy() {
        return null;
    }

    @Nonnull
    @OnlyIn(value=Dist.CLIENT)
    default public IRecipeInfoRenderer getInfoRenderer() {
        return InfoRenderers.DEFAULT_RENDERER;
    }

    default public Component getDisplayName() {
        return new TranslatableComponent("jei.category." + this.getLoc().m_135815_());
    }
}

