/*
 * Decompiled with CFR 0.152.
 */
package muramasa.antimatter.recipe.ingredient;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import com.google.common.collect.Streams;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import it.unimi.dsi.fastutil.objects.Object2BooleanMap;
import it.unimi.dsi.fastutil.objects.Object2BooleanOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectArraySet;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import muramasa.antimatter.AntimatterAPI;
import muramasa.antimatter.material.IMaterialTag;
import muramasa.antimatter.material.Material;
import muramasa.antimatter.material.MaterialTag;
import muramasa.antimatter.material.MaterialTags;
import muramasa.antimatter.material.MaterialTypeItem;
import muramasa.antimatter.recipe.ingredient.IAntimatterIngredientSerializer;
import muramasa.antimatter.recipe.ingredient.MultiItemValue;
import muramasa.antimatter.tool.AntimatterToolType;
import muramasa.antimatter.util.AntimatterPlatformUtils;
import muramasa.antimatter.util.TagUtils;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;

public class PropertyIngredient
extends Ingredient {
    private static final Map<ResourceLocation, Getter> getters = new Object2ObjectOpenHashMap();
    private final Set<MaterialTypeItem<?>> type;
    private final Set<TagKey<Item>> itemTags;
    private final Set<ItemLike> items;
    private final String id;
    private final IMaterialTag[] tags;
    private final Object2BooleanMap<AntimatterToolType> optionalTools;
    private final Set<Material> fixedMats;
    private final boolean inverse;

    protected static PropertyIngredient build(Set<MaterialTypeItem<?>> type, Set<TagKey<Item>> itemTags, Set<ItemLike> items, String id, IMaterialTag[] tags, Set<Material> fixedMats, boolean inverse, Object2BooleanMap<AntimatterToolType> tools) {
        Predicate<Material> filter = t -> {
            boolean ok = t.has(tags);
            boolean types = true;
            if (tools.size() > 0) {
                if (t.has(MaterialTags.TOOLS)) {
                    HashSet<AntimatterToolType> set = new HashSet<AntimatterToolType>(MaterialTags.TOOLS.get((Material)t).toolTypes());
                    for (Object2BooleanMap.Entry entry : tools.object2BooleanEntrySet()) {
                        types &= entry.getBooleanValue() == set.contains(entry.getKey());
                    }
                } else {
                    types = false;
                }
            }
            if (inverse) {
                return !ok && types;
            }
            return ok && types;
        };
        Stream<Ingredient.Value> stream = Stream.concat(Stream.concat(itemTags.stream().map(Ingredient.TagValue::new), type.stream().map(i -> {
            Stream materialStream = fixedMats.size() == 0 ? i.all().stream() : fixedMats.stream();
            return materialStream.filter(filter).map(i::getMaterialTag).collect(Collectors.toList());
        }).flatMap(t -> t.stream().map(Ingredient.TagValue::new))), Stream.of(new MultiItemValue(items.stream().map(ItemStack::new).collect(Collectors.toList()))));
        return new PropertyIngredient(stream, type, itemTags, items, id, tags, fixedMats, inverse, tools);
    }

    protected PropertyIngredient(Stream<Ingredient.Value> stream, Set<MaterialTypeItem<?>> type, Set<TagKey<Item>> itemTags, Set<ItemLike> items, String id, IMaterialTag[] tags, Set<Material> fixedMats, boolean inverse, Object2BooleanMap<AntimatterToolType> tools) {
        super(stream);
        this.type = type;
        this.id = id;
        this.tags = tags == null ? new MaterialTag[]{} : tags;
        this.inverse = inverse;
        this.optionalTools = tools;
        this.itemTags = itemTags;
        this.items = items;
        this.fixedMats = fixedMats;
    }

    public static PropertyIngredient of(MaterialTypeItem<?> type, String id) {
        return PropertyIngredient.build(ImmutableSet.of(type), Collections.emptySet(), Collections.emptySet(), id, new IMaterialTag[0], Collections.emptySet(), false, (Object2BooleanMap<AntimatterToolType>)new Object2BooleanOpenHashMap());
    }

    public Set<MaterialTypeItem<?>> getTypes() {
        return this.type;
    }

    public Object getMat(ItemStack stack) {
        for (MaterialTypeItem<?> materialTypeItem : this.getTypes()) {
            Material mat = materialTypeItem.getMaterialFromStack(stack);
            if (mat == null) continue;
            return mat;
        }
        for (ItemLike itemLike : this.items) {
            if (itemLike.m_5456_() != stack.m_41720_()) continue;
            return stack;
        }
        for (TagKey tagKey : this.itemTags) {
            Object o;
            Getter getter = getters.get(tagKey.f_203868_());
            if (getter == null || (o = getter.get(stack)) == null) continue;
            return o;
        }
        return null;
    }

    public static void addGetter(ResourceLocation loc, Getter get) {
        getters.put(loc, get);
    }

    public Set<TagKey<Item>> getTags() {
        return this.itemTags;
    }

    public String getId() {
        return this.id;
    }

    public JsonElement m_43942_() {
        JsonArray arr;
        JsonObject obj = new JsonObject();
        JsonArray materialArr = new JsonArray();
        for (MaterialTypeItem<?> materialTypeItem : this.type) {
            materialArr.add(materialTypeItem.getId());
        }
        obj.add("material_type", (JsonElement)materialArr);
        materialArr = new JsonArray();
        for (TagKey tagKey : this.itemTags) {
            materialArr.add(tagKey.f_203868_().toString());
        }
        obj.add("item_tags", (JsonElement)materialArr);
        materialArr = new JsonArray();
        for (ItemLike itemLike : this.items) {
            ResourceLocation name = AntimatterPlatformUtils.getIdFromItem(itemLike.m_5456_());
            if (name == null) continue;
            materialArr.add(name.toString());
        }
        obj.add("items", (JsonElement)materialArr);
        obj.addProperty("type", Serializer.ID.toString());
        obj.addProperty("id", this.id);
        obj.addProperty("inverse", Boolean.valueOf(this.inverse));
        if (this.tags.length > 0) {
            arr = new JsonArray();
            for (IMaterialTag tag : this.tags) {
                arr.add(tag.getId());
            }
            obj.add("tags", (JsonElement)arr);
        }
        if (this.optionalTools.size() > 0) {
            JsonObject map = new JsonObject();
            for (Object2BooleanMap.Entry entry : this.optionalTools.object2BooleanEntrySet()) {
                map.addProperty(((AntimatterToolType)entry.getKey()).getId(), Boolean.valueOf(entry.getBooleanValue()));
            }
            obj.add("tools", (JsonElement)map);
        }
        if (this.fixedMats.size() > 0) {
            arr = new JsonArray();
            for (Material mat : this.fixedMats) {
                arr.add(mat.getId());
            }
            obj.add("fixed", (JsonElement)arr);
        }
        return obj;
    }

    public boolean test(@Nullable ItemStack test) {
        if (test == null || test.m_41619_()) {
            return false;
        }
        for (TagKey<Item> itemTag : this.itemTags) {
            if (!test.m_204117_(itemTag)) continue;
            return true;
        }
        return super.test(test);
    }

    public static Builder builder(String id) {
        return new Builder(id);
    }

    public static interface Getter {
        @Nullable
        public Object get(@Nonnull ItemStack var1);
    }

    public static class Serializer
    implements IAntimatterIngredientSerializer<PropertyIngredient> {
        public static Serializer INSTANCE = new Serializer();
        public static final ResourceLocation ID = new ResourceLocation("antimatter", "material");

        public static void init() {
            AntimatterAPI.register(IAntimatterIngredientSerializer.class, "material", "antimatter", INSTANCE);
        }

        @Override
        public PropertyIngredient parse(FriendlyByteBuf buffer) {
            String id = buffer.m_130277_();
            int size = buffer.m_130242_();
            ObjectArraySet items = new ObjectArraySet(size);
            for (int i = 0; i < size; ++i) {
                items.add(AntimatterAPI.get(MaterialTypeItem.class, buffer.m_130277_()));
            }
            size = buffer.m_130242_();
            ObjectArraySet t = new ObjectArraySet(size);
            for (int i = 0; i < size; ++i) {
                t.add(TagUtils.getItemTag(buffer.m_130281_()));
            }
            boolean inverse = buffer.readBoolean();
            IMaterialTag[] tags = new IMaterialTag[buffer.m_130242_()];
            for (int i = 0; i < tags.length; ++i) {
                tags[i] = AntimatterAPI.get(IMaterialTag.class, buffer.m_130277_());
            }
            size = buffer.m_130242_();
            Object2BooleanOpenHashMap map = new Object2BooleanOpenHashMap(size);
            for (int i = 0; i < size; ++i) {
                map.put((Object)AntimatterAPI.get(AntimatterToolType.class, buffer.m_130277_()), buffer.readBoolean());
            }
            size = buffer.m_130242_();
            ObjectArraySet fixedMats = new ObjectArraySet(size);
            for (int i = 0; i < size; ++i) {
                fixedMats.add(AntimatterAPI.get(Material.class, buffer.m_130277_()));
            }
            size = buffer.m_130242_();
            ObjectArraySet itemProviders = new ObjectArraySet(size);
            for (int i = 0; i < size; ++i) {
                ResourceLocation name = new ResourceLocation(buffer.m_130277_());
                if (!AntimatterPlatformUtils.itemExists(name)) continue;
                itemProviders.add(AntimatterPlatformUtils.getItemFromID(name));
            }
            ItemStack[] stacks = new ItemStack[buffer.m_130242_()];
            for (int i = 0; i < stacks.length; ++i) {
                stacks[i] = buffer.m_130267_();
            }
            return new PropertyIngredient(Stream.of(new MultiItemValue(Arrays.asList(stacks))), (Set<MaterialTypeItem<?>>)items, (Set<TagKey<Item>>)t, (Set<ItemLike>)itemProviders, id, tags, (Set<Material>)fixedMats, inverse, (Object2BooleanMap<AntimatterToolType>)map);
        }

        @Override
        public PropertyIngredient parse(JsonObject json) {
            JsonArray arr = json.getAsJsonArray("material_type");
            ObjectArraySet items = new ObjectArraySet(arr.size());
            arr.forEach(arg_0 -> Serializer.lambda$parse$0((Set)items, arg_0));
            arr = json.getAsJsonArray("item_tags");
            ObjectArraySet itemTags = new ObjectArraySet(arr.size());
            arr.forEach(arg_0 -> Serializer.lambda$parse$1((Set)itemTags, arg_0));
            arr = json.getAsJsonArray("items");
            ObjectArraySet items2 = new ObjectArraySet(arr.size());
            arr.forEach(arg_0 -> Serializer.lambda$parse$2((Set)items2, arg_0));
            String ingId = json.get("id").getAsString();
            boolean inverse = json.get("inverse").getAsBoolean();
            IMaterialTag[] tags = json.has("tags") ? (IMaterialTag[])Streams.stream((Iterable)GsonHelper.m_13933_((JsonObject)json, (String)"tags")).map(t -> AntimatterAPI.get(IMaterialTag.class, t.getAsString())).toArray(IMaterialTag[]::new) : new IMaterialTag[]{};
            Object2BooleanOpenHashMap map = new Object2BooleanOpenHashMap();
            if (json.has("tools")) {
                for (Map.Entry entry : GsonHelper.m_13930_((JsonObject)json, (String)"tools").entrySet()) {
                    map.put((Object)AntimatterAPI.get(AntimatterToolType.class, (String)entry.getKey()), ((JsonElement)entry.getValue()).getAsBoolean());
                }
            }
            Set<Material> fixedMats = Collections.emptySet();
            if (json.has("fixed")) {
                fixedMats = Streams.stream((Iterable)GsonHelper.m_13933_((JsonObject)json, (String)"fixed")).map(t -> AntimatterAPI.get(Material.class, t.getAsString())).collect(Collectors.toSet());
            }
            return PropertyIngredient.build(items, (Set<TagKey<Item>>)itemTags, (Set<ItemLike>)items2, ingId, tags, fixedMats, inverse, (Object2BooleanMap<AntimatterToolType>)map);
        }

        @Override
        public void write(FriendlyByteBuf buffer, PropertyIngredient ingredient) {
            buffer.m_130070_(ingredient.id);
            buffer.m_130130_(ingredient.type.size());
            for (MaterialTypeItem<?> materialTypeItem : ingredient.type) {
                buffer.m_130070_(materialTypeItem.getId());
            }
            buffer.m_130130_(ingredient.itemTags.size());
            for (TagKey tagKey : ingredient.itemTags) {
                buffer.m_130085_(tagKey.f_203868_());
            }
            buffer.writeBoolean(ingredient.inverse);
            buffer.m_130130_(ingredient.tags.length);
            for (IMaterialTag tag : ingredient.tags) {
                buffer.m_130070_(tag.getId());
            }
            buffer.m_130130_(ingredient.optionalTools.size());
            for (Object2BooleanMap.Entry entry : ingredient.optionalTools.object2BooleanEntrySet()) {
                buffer.m_130070_(((AntimatterToolType)entry.getKey()).getId());
                buffer.writeBoolean(entry.getBooleanValue());
            }
            buffer.m_130130_(ingredient.fixedMats.size());
            for (Material material : ingredient.fixedMats) {
                buffer.m_130070_(material.getId());
            }
            buffer.m_130130_(ingredient.items.size());
            for (ItemLike itemLike : ingredient.items) {
                ResourceLocation name = AntimatterPlatformUtils.getIdFromItem(itemLike.m_5456_());
                if (name == null) continue;
                buffer.m_130070_(name.toString());
            }
            ItemStack[] items = ingredient.m_43908_();
            buffer.m_130130_(items.length);
            for (ItemStack stack : items) {
                buffer.m_130055_(stack);
            }
        }

        private static /* synthetic */ void lambda$parse$2(Set items2, JsonElement el) {
            if (AntimatterPlatformUtils.itemExists(new ResourceLocation(el.getAsString()))) {
                items2.add(AntimatterPlatformUtils.getItemFromID(new ResourceLocation(el.getAsString())));
            }
        }

        private static /* synthetic */ void lambda$parse$1(Set itemTags, JsonElement el) {
            itemTags.add(TagUtils.getItemTag(new ResourceLocation(el.getAsString())));
        }

        private static /* synthetic */ void lambda$parse$0(Set items, JsonElement el) {
            items.add(AntimatterAPI.get(MaterialTypeItem.class, el.getAsString()));
        }
    }

    public static class Builder {
        private Set<MaterialTypeItem<?>> type;
        private Set<TagKey<Item>> itemTags;
        private Set<ItemLike> items;
        private Set<Material> fixedMats;
        private final String id;
        private IMaterialTag[] tags = new IMaterialTag[0];
        private final Object2BooleanMap<AntimatterToolType> optionalTools = new Object2BooleanOpenHashMap();
        private boolean inverse = false;

        private Builder(String id) {
            this.id = id;
        }

        public Builder types(MaterialTypeItem<?> ... types) {
            this.type = new ObjectArraySet((Object[])types);
            return this;
        }

        public Builder tags(IMaterialTag ... tags) {
            this.tags = tags;
            return this;
        }

        public Builder mats(Material ... tags) {
            this.fixedMats = Sets.newHashSet((Object[])tags);
            return this;
        }

        @SafeVarargs
        public final Builder itemTags(TagKey<Item> ... tags) {
            this.itemTags = new ObjectArraySet((Object[])tags);
            return this;
        }

        public final Builder itemStacks(ItemLike ... items) {
            this.items = new ObjectArraySet((Object[])items);
            return this;
        }

        public Builder inverse() {
            this.inverse = true;
            return this;
        }

        public Builder tool(AntimatterToolType type, boolean has) {
            this.optionalTools.put((Object)type, has);
            return this;
        }

        public PropertyIngredient build() {
            return PropertyIngredient.build(this.type == null ? Collections.emptySet() : this.type, this.itemTags == null ? Collections.emptySet() : this.itemTags, this.items == null ? Collections.emptySet() : this.items, this.id, this.tags, this.fixedMats == null ? Collections.emptySet() : this.fixedMats, this.inverse, this.optionalTools);
        }
    }
}

