/*
 * Decompiled with CFR 0.152.
 */
package muramasa.antimatter.recipe.ingredient;

import com.google.common.collect.ImmutableSet;
import java.util.Set;
import muramasa.antimatter.recipe.ingredient.AbstractMapIngredient;
import muramasa.antimatter.recipe.ingredient.MapItemIngredient;
import muramasa.antimatter.recipe.ingredient.MapTagIngredient;
import muramasa.antimatter.util.AntimatterPlatformUtils;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.item.ItemStack;

public class MapItemStackIngredient
extends AbstractMapIngredient {
    public final ItemStack stack;
    private final CompoundTag tag;
    protected static final Set<String> CUSTOM_TAGS = ImmutableSet.of((Object)"nc", (Object)"inb");

    public MapItemStackIngredient(ItemStack stack, boolean insideMap) {
        super(insideMap);
        this.stack = stack;
        this.tag = MapItemStackIngredient.filterTags(stack.m_41783_());
    }

    @Override
    public boolean equals(Object o) {
        if (!super.equals(o)) {
            return false;
        }
        if (o instanceof MapTagIngredient) {
            MapTagIngredient m = (MapTagIngredient)o;
            return this.stack.m_41720_().m_204114_().m_203656_(m.loc);
        }
        if (o instanceof MapItemIngredient) {
            return ((MapItemIngredient)o).stack.equals(this.stack.m_41720_());
        }
        if (o instanceof MapItemStackIngredient) {
            MapItemStackIngredient s = (MapItemStackIngredient)o;
            return MapItemStackIngredient.compareStacks(this.stack, s.stack, this.tag, s.tag);
        }
        return false;
    }

    private static boolean compareStacks(ItemStack a, ItemStack b, CompoundTag aTag, CompoundTag bTag) {
        if (a.m_41720_() != b.m_41720_()) {
            return false;
        }
        if (aTag.m_128456_() != bTag.m_128456_()) {
            return false;
        }
        if (!aTag.equals((Object)bTag)) {
            return false;
        }
        return AntimatterPlatformUtils.areCapsCompatible(a, b);
    }

    protected static CompoundTag filterTags(CompoundTag nbt) {
        if (nbt == null) {
            return new CompoundTag();
        }
        CompoundTag newNbt = nbt.m_6426_();
        CUSTOM_TAGS.forEach(arg_0 -> ((CompoundTag)newNbt).m_128473_(arg_0));
        return newNbt;
    }

    @Override
    protected int hash() {
        CompoundTag newNbt;
        boolean nbt = this.stack.m_41782_();
        long tempHash = 1L;
        tempHash = 31L * tempHash + (long)AntimatterPlatformUtils.getIdFromItem(this.stack.m_41720_()).hashCode();
        if (nbt && this.stack.m_41783_() != null && !(newNbt = MapItemStackIngredient.filterTags(this.stack.m_41783_())).m_128456_()) {
            tempHash = 31L * tempHash + (long)newNbt.hashCode();
        }
        return (int)(tempHash ^ tempHash >>> 32);
    }
}

