/*
 * Decompiled with CFR 0.152.
 */
package muramasa.antimatter.recipe.ingredient;

import com.google.gson.JsonObject;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import muramasa.antimatter.capability.machine.MachineFluidHandler;
import muramasa.antimatter.material.Material;
import muramasa.antimatter.recipe.RecipeUtil;
import muramasa.antimatter.util.AntimatterPlatformUtils;
import muramasa.antimatter.util.TagUtils;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import tesseract.TesseractGraphWrappers;

public class FluidIngredient {
    private FluidStack[] stacks = new FluidStack[0];
    private TagKey<Fluid> tag;
    private long amount = 0L;
    private boolean evaluated = false;
    public static final FluidIngredient EMPTY = new FluidIngredient();

    private FluidIngredient() {
    }

    public FluidStack[] getStacks() {
        if (this.evaluated) {
            return this.stacks;
        }
        this.evaluated = true;
        if (this.tag != null) {
            ObjectArrayList list = new ObjectArrayList();
            Registry.f_122822_.m_206058_(this.tag).iterator().forEachRemaining(arg_0 -> this.lambda$getStacks$0((List)list, arg_0));
            this.stacks = list.toArray(new FluidStack[0]);
        }
        return this.stacks;
    }

    public TagKey<Fluid> getTag() {
        return this.tag;
    }

    public long getAmount() {
        return this.amount;
    }

    public int getAmountInMB() {
        return (int)(this.getAmount() / TesseractGraphWrappers.dropletMultiplier);
    }

    public FluidIngredient copy(long droplets) {
        FluidIngredient ing = new FluidIngredient();
        ing.stacks = (FluidStack[])Arrays.stream(this.stacks).map(t -> {
            FluidStack stack = t.copy();
            stack.setAmount(droplets);
            return stack;
        }).toArray(FluidStack[]::new);
        ing.evaluated = this.evaluated;
        ing.amount = droplets;
        ing.tag = this.tag;
        return ing;
    }

    public FluidIngredient copyMB(int amount) {
        return this.copy((long)amount * TesseractGraphWrappers.dropletMultiplier);
    }

    public void write(FriendlyByteBuf buffer) {
        this.getStacks();
        buffer.m_130130_(this.stacks.length);
        for (FluidStack stack : this.stacks) {
            AntimatterPlatformUtils.writeFluidStack(stack, buffer);
        }
    }

    public JsonObject toJson() {
        JsonObject json = new JsonObject();
        if (this.tag != null) {
            json.addProperty("fluidTag", Boolean.valueOf(true));
            json.addProperty("tag", this.tag.f_203868_().toString());
            json.addProperty("amount", (Number)this.amount);
        } else {
            json = RecipeUtil.fluidstackToJson(this.stacks[0]);
        }
        return json;
    }

    public static FluidIngredient of(FriendlyByteBuf buf) {
        int count = buf.m_130242_();
        FluidStack[] stacks = new FluidStack[count];
        for (int i = 0; i < count; ++i) {
            stacks[i] = AntimatterPlatformUtils.readFluidStack(buf);
        }
        FluidIngredient ing = new FluidIngredient();
        long amount = 0L;
        for (FluidStack stack : stacks) {
            if (stack.getRealAmount() <= amount) continue;
            amount = stack.getRealAmount();
        }
        ing.stacks = stacks;
        ing.evaluated = true;
        ing.amount = amount;
        return ing;
    }

    public static FluidIngredient of(ResourceLocation loc, long droplets) {
        Objects.requireNonNull(loc);
        FluidIngredient ing = new FluidIngredient();
        ing.tag = TagUtils.getFluidTag(loc);
        ing.amount = droplets;
        return ing;
    }

    public static FluidIngredient of(Material mat, long droplets) {
        return FluidIngredient.of(new ResourceLocation(AntimatterPlatformUtils.isForge() ? "forge" : "c", mat.getId()), droplets);
    }

    public static FluidIngredient ofMB(ResourceLocation loc, int amount) {
        return FluidIngredient.of(loc, (long)amount * TesseractGraphWrappers.dropletMultiplier);
    }

    public static FluidIngredient ofMB(Material mat, int amount) {
        return FluidIngredient.of(mat, (long)amount * TesseractGraphWrappers.dropletMultiplier);
    }

    public static FluidIngredient of(FluidStack stack) {
        Objects.requireNonNull(stack);
        FluidIngredient ing = new FluidIngredient();
        ing.stacks = new FluidStack[]{stack};
        ing.amount = stack.getRealAmount();
        return ing;
    }

    public List<FluidStack> drain(MachineFluidHandler<?> handler, boolean input, boolean simulate) {
        return this.drain(this.amount, handler, input, simulate);
    }

    public List<FluidStack> drain(long amount, MachineFluidHandler<?> handler, boolean input, boolean simulate) {
        long drained = amount;
        ObjectArrayList ret = new ObjectArrayList(1);
        IFluidHandler.FluidAction action = simulate ? IFluidHandler.FluidAction.SIMULATE : IFluidHandler.FluidAction.EXECUTE;
        for (FluidStack stack : this.stacks) {
            stack = stack.copy();
            stack.setAmount(drained);
            FluidStack drain = input ? handler.drainInput(stack, action) : handler.drain(stack, action);
            drained -= drain.getRealAmount();
            if (!drain.isEmpty()) {
                ret.add(drain);
            }
            if (drained == 0L) break;
        }
        return ret;
    }

    public long drainedAmount(long amount, MachineFluidHandler<?> handler, boolean input, boolean simulate) {
        return this.drain(amount, handler, input, simulate).stream().mapToLong(FluidStack::getRealAmount).sum();
    }

    private /* synthetic */ void lambda$getStacks$0(List list, Holder t) {
        FluidStack stack = new FluidStack((Fluid)t.m_203334_(), this.getAmountInMB());
        list.add(stack);
    }
}

