/*
 * Decompiled with CFR 0.152.
 */
package muramasa.antimatter.recipe.forge.condition;

import com.electronwill.nightconfig.core.CommentedConfig;
import com.electronwill.nightconfig.core.file.FileNotFoundAction;
import com.electronwill.nightconfig.toml.TomlParser;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraftforge.common.crafting.conditions.ICondition;
import net.minecraftforge.common.crafting.conditions.IConditionSerializer;
import net.minecraftforge.fml.loading.FMLPaths;

public class TomlConfigCondition
implements ICondition {
    private static final TomlParser PARSER = new TomlParser();
    private static final ResourceLocation NAME = new ResourceLocation("antimatter", "toml_config");
    private final String config;
    private final String configPath;

    public TomlConfigCondition(String config, String configPath) {
        this.config = config;
        this.configPath = configPath;
    }

    public ResourceLocation getID() {
        return NAME;
    }

    public boolean test() {
        if (this.config.isEmpty() || this.configPath.isEmpty()) {
            throw new JsonParseException("config and configPath cannot be empty!");
        }
        Path configFile = Path.of(FMLPaths.CONFIGDIR.get().toString(), this.config + ".toml");
        if (!Files.exists(configFile, new LinkOption[0])) {
            throw new JsonParseException("Config file " + configFile + " does not exist!");
        }
        CommentedConfig config1 = (CommentedConfig)PARSER.parse(configFile, FileNotFoundAction.READ_NOTHING);
        if (!config1.contains(this.configPath)) {
            throw new JsonParseException("Config path " + this.configPath + " not found!");
        }
        if (!(config1.get(this.configPath) instanceof Boolean)) {
            throw new JsonParseException("Config path " + this.configPath + " must be a boolean!");
        }
        return (Boolean)config1.get(this.configPath);
    }

    public static class Serializer
    implements IConditionSerializer<TomlConfigCondition> {
        public static final Serializer INSTANCE = new Serializer();

        public void write(JsonObject json, TomlConfigCondition value) {
            JsonObject object = new JsonObject();
            object.addProperty("config", value.config);
            object.addProperty("configPath", value.configPath);
            json.add("toml_config", (JsonElement)object);
        }

        public TomlConfigCondition read(JsonObject json) {
            JsonObject object = json.getAsJsonObject("toml_config");
            return new TomlConfigCondition(GsonHelper.m_13906_((JsonObject)object, (String)"config"), GsonHelper.m_13906_((JsonObject)object, (String)"configPath"));
        }

        public ResourceLocation getID() {
            return NAME;
        }
    }
}

