/*
 * Decompiled with CFR 0.152.
 */
package muramasa.antimatter.recipe.forge;

import com.google.gson.JsonObject;
import java.util.function.Consumer;
import muramasa.antimatter.datagen.builder.AntimatterShapedRecipeBuilder;
import muramasa.antimatter.recipe.forge.condition.ConfigCondition;
import muramasa.antimatter.recipe.forge.condition.TomlConfigCondition;
import net.minecraft.core.Registry;
import net.minecraft.data.recipes.FinishedRecipe;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraftforge.common.crafting.CompoundIngredient;
import net.minecraftforge.common.crafting.ConditionalRecipe;
import net.minecraftforge.common.crafting.CraftingHelper;
import net.minecraftforge.common.crafting.NBTIngredient;
import net.minecraftforge.common.crafting.conditions.ICondition;
import net.minecraftforge.fluids.FluidStack;

public class RecipeUtilImpl {
    public static boolean isNBTIngredient(Class<? extends Ingredient> clazz) {
        return clazz == NBTIngredient.class;
    }

    public static boolean isCompoundIngredient(Class<? extends Ingredient> clazz) {
        return clazz == CompoundIngredient.class;
    }

    public static void addConditionalRecipe(Consumer<FinishedRecipe> consumer, AntimatterShapedRecipeBuilder builtRecipe, Class configClass, String configFieldName, String recipeDomain, String recipeName) {
        ConditionalRecipe.builder().addCondition((ICondition)new ConfigCondition(configClass, configFieldName)).addRecipe(builtRecipe::build).build(consumer, recipeDomain, recipeName);
    }

    public static void addConditionalRecipe(Consumer<FinishedRecipe> consumer, AntimatterShapedRecipeBuilder builtRecipe, String config, String configField, String recipeDomain, String recipeName) {
        ConditionalRecipe.builder().addCondition((ICondition)new TomlConfigCondition(config, configField)).addRecipe(builtRecipe::build).build(consumer, recipeDomain, recipeName);
    }

    public static ItemStack getItemStack(JsonObject object, boolean readNBT) {
        return CraftingHelper.getItemStack((JsonObject)object, (boolean)readNBT);
    }

    public static JsonObject itemstackToJson(ItemStack stack) {
        JsonObject resultObj = new JsonObject();
        resultObj.addProperty("item", Registry.f_122827_.m_7981_((Object)stack.m_41720_()).toString());
        if (stack.m_41613_() > 1) {
            resultObj.addProperty("count", (Number)stack.m_41613_());
        }
        if (stack.m_41782_()) {
            CompoundTag nbt = stack.m_41783_();
            resultObj.addProperty("nbt", nbt.toString());
        }
        return resultObj;
    }

    public static JsonObject fluidstackToJson(FluidStack stack) {
        throw new AssertionError();
    }

    public static <T extends Ingredient> void write(FriendlyByteBuf buffer, T ingredient) {
        CraftingHelper.write((FriendlyByteBuf)buffer, ingredient);
    }

    public static Ingredient fromNetwork(FriendlyByteBuf buffer) {
        return Ingredient.m_43940_((FriendlyByteBuf)buffer);
    }
}

