/*
 * Decompiled with CFR 0.152.
 */
package muramasa.antimatter.recipe.container;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import muramasa.antimatter.AntimatterAPI;
import muramasa.antimatter.item.IContainerItem;
import muramasa.antimatter.util.AntimatterPlatformUtils;
import net.minecraft.core.NonNullList;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.Container;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.ShapedRecipe;
import net.minecraft.world.item.crafting.ShapelessRecipe;
import org.jetbrains.annotations.NotNull;

public class ContainerItemShapelessRecipe
extends ShapelessRecipe {
    public static final Serializer INSTANCE = new Serializer();

    public static void init() {
        AntimatterAPI.register(RecipeSerializer.class, "container_shapeless", "antimatter", INSTANCE);
    }

    public ContainerItemShapelessRecipe(ResourceLocation resourceLocation, String string, ItemStack itemStack, NonNullList<Ingredient> nonNullList) {
        super(resourceLocation, string, itemStack, nonNullList);
    }

    public RecipeSerializer<?> m_7707_() {
        return INSTANCE;
    }

    public NonNullList<ItemStack> getRemainingItems(@NotNull CraftingContainer container) {
        if (AntimatterPlatformUtils.isForge()) {
            return super.m_7457_((Container)container);
        }
        NonNullList nonnulllist = NonNullList.m_122780_((int)container.m_6643_(), (Object)ItemStack.f_41583_);
        for (int i = 0; i < nonnulllist.size(); ++i) {
            IContainerItem containerItem;
            ItemStack item = container.m_8020_(i);
            Item item2 = item.m_41720_();
            if (!(item2 instanceof IContainerItem) || !(containerItem = (IContainerItem)item2).hasContainerItem(item)) continue;
            nonnulllist.set(i, (Object)containerItem.getContainerItem(item));
        }
        return nonnulllist;
    }

    public static class Serializer
    implements RecipeSerializer<ContainerItemShapelessRecipe> {
        public ContainerItemShapelessRecipe fromJson(ResourceLocation recipeId, JsonObject json) {
            String string = GsonHelper.m_13851_((JsonObject)json, (String)"group", (String)"");
            NonNullList<Ingredient> nonNullList = Serializer.itemsFromJson(GsonHelper.m_13933_((JsonObject)json, (String)"ingredients"));
            if (nonNullList.isEmpty()) {
                throw new JsonParseException("No ingredients for shapeless recipe");
            }
            if (nonNullList.size() > 9) {
                throw new JsonParseException("Too many ingredients for shapeless recipe");
            }
            ItemStack itemStack = ShapedRecipe.m_151274_((JsonObject)GsonHelper.m_13930_((JsonObject)json, (String)"result"));
            return new ContainerItemShapelessRecipe(recipeId, string, itemStack, nonNullList);
        }

        private static NonNullList<Ingredient> itemsFromJson(JsonArray ingredientArray) {
            NonNullList nonNullList = NonNullList.m_122779_();
            for (int i = 0; i < ingredientArray.size(); ++i) {
                Ingredient ingredient = Ingredient.m_43917_((JsonElement)ingredientArray.get(i));
                if (ingredient.m_43947_()) continue;
                nonNullList.add((Object)ingredient);
            }
            return nonNullList;
        }

        public ContainerItemShapelessRecipe fromNetwork(ResourceLocation recipeId, FriendlyByteBuf buffer) {
            String string = buffer.m_130277_();
            int i = buffer.m_130242_();
            NonNullList nonNullList = NonNullList.m_122780_((int)i, (Object)Ingredient.f_43901_);
            for (int j = 0; j < nonNullList.size(); ++j) {
                nonNullList.set(j, (Object)Ingredient.m_43940_((FriendlyByteBuf)buffer));
            }
            ItemStack itemStack = buffer.m_130267_();
            return new ContainerItemShapelessRecipe(recipeId, string, itemStack, (NonNullList<Ingredient>)nonNullList);
        }

        public void toNetwork(FriendlyByteBuf buffer, ContainerItemShapelessRecipe recipe) {
            buffer.m_130070_(recipe.m_6076_());
            buffer.m_130130_(recipe.m_7527_().size());
            for (Ingredient ingredient : recipe.m_7527_()) {
                ingredient.m_43923_(buffer);
            }
            buffer.m_130055_(recipe.m_8043_());
        }
    }
}

