/*
 * Decompiled with CFR 0.152.
 */
package muramasa.antimatter.recipe;

import com.google.common.collect.ImmutableMap;
import java.util.Arrays;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nonnull;
import muramasa.antimatter.AntimatterAPI;
import muramasa.antimatter.material.Material;
import muramasa.antimatter.material.MaterialItem;
import muramasa.antimatter.material.MaterialTypeItem;
import muramasa.antimatter.pipe.PipeItemBlock;
import muramasa.antimatter.pipe.PipeSize;
import muramasa.antimatter.pipe.types.FluidPipe;
import muramasa.antimatter.pipe.types.ItemPipe;
import muramasa.antimatter.pipe.types.PipeType;
import muramasa.antimatter.recipe.ingredient.PropertyIngredient;
import muramasa.antimatter.recipe.material.MaterialRecipe;
import muramasa.antimatter.tool.AntimatterToolType;
import muramasa.antimatter.tool.armor.AntimatterArmorType;
import muramasa.antimatter.util.TagUtils;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.DyeItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;

public class RecipeBuilders {
    public static final MaterialRecipe.Provider ARMOR_BUILDER = MaterialRecipe.registerProvider("armor", "antimatter", id -> new MaterialRecipe.ItemBuilder(){

        @Override
        public ItemStack build(CraftingContainer inv, MaterialRecipe.Result mats) {
            return AntimatterAPI.get(AntimatterArmorType.class, id).getToolStack((Material)mats.mats.get("primary"));
        }

        @Override
        public Map<String, Object> getFromResult(@Nonnull ItemStack stack) {
            CompoundTag nbt = stack.m_41783_().m_128469_("td");
            Material primary = AntimatterAPI.get(Material.class, nbt.m_128461_("m"));
            return ImmutableMap.of((Object)"primary", (Object)(primary != null ? primary : Material.NULL));
        }
    });
    public static final MaterialRecipe.Provider ITEM_PIPE_BUILDER = MaterialRecipe.registerProvider("pipe", "antimatter", id -> new MaterialRecipe.ItemBuilder(){

        @Override
        public ItemStack build(CraftingContainer inv, MaterialRecipe.Result mats) {
            PipeSize size = PipeSize.valueOf(id.toUpperCase(Locale.ENGLISH));
            Material mat = (Material)mats.mats.get("primary");
            PipeType p = AntimatterAPI.get(ItemPipe.class, "item_" + mat.getId());
            int amount = size == PipeSize.TINY ? 12 : (size == PipeSize.SMALL ? 6 : (size == PipeSize.NORMAL ? 2 : 1));
            return new ItemStack((ItemLike)p.getBlock(size), amount);
        }

        @Override
        public Map<String, Object> getFromResult(@Nonnull ItemStack stack) {
            return ImmutableMap.of((Object)"primary", (Object)((PipeType)((PipeItemBlock)stack.m_41720_()).getPipe().getType()).getMaterial());
        }
    });
    public static final MaterialRecipe.Provider DUST_BUILDER = MaterialRecipe.registerProvider("dust", "antimatter", id -> new MaterialRecipe.ItemBuilder(){
        final MaterialTypeItem type;
        {
            this.type = AntimatterAPI.get(MaterialTypeItem.class, id);
        }

        @Override
        public ItemStack build(CraftingContainer inv, MaterialRecipe.Result mats) {
            Material mat = (Material)mats.mats.get("primary");
            return this.type.get(mat, 1);
        }

        @Override
        public Map<String, Object> getFromResult(@Nonnull ItemStack stack) {
            if (stack.m_41720_() instanceof MaterialItem) {
                return ImmutableMap.of((Object)"primary", (Object)((MaterialItem)stack.m_41720_()).getMaterial());
            }
            Material mat = this.type.getMaterialFromStack(stack);
            if (mat != null) {
                return ImmutableMap.of((Object)"primary", (Object)mat);
            }
            return null;
        }
    });
    public static final MaterialRecipe.Provider DUST_TWO_BUILDER = MaterialRecipe.registerProvider("dust_two", "antimatter", id -> new MaterialRecipe.ItemBuilder(){
        final MaterialTypeItem type;
        {
            this.type = AntimatterAPI.get(MaterialTypeItem.class, id);
        }

        @Override
        public ItemStack build(CraftingContainer inv, MaterialRecipe.Result mats) {
            Material mat = (Material)mats.mats.get("primary");
            return this.type.get(mat, 2);
        }

        @Override
        public Map<String, Object> getFromResult(@Nonnull ItemStack stack) {
            if (stack.m_41720_() instanceof MaterialItem) {
                return ImmutableMap.of((Object)"primary", (Object)((MaterialItem)stack.m_41720_()).getMaterial());
            }
            Material mat = this.type.getMaterialFromStack(stack);
            if (mat != null) {
                return ImmutableMap.of((Object)"primary", (Object)mat);
            }
            return null;
        }
    });
    public static final MaterialRecipe.Provider FLUID_PIPE_BUILDER = MaterialRecipe.registerProvider("fluid", "antimatter", id -> new MaterialRecipe.ItemBuilder(){

        @Override
        public ItemStack build(CraftingContainer inv, MaterialRecipe.Result mats) {
            PipeSize size = PipeSize.valueOf(id.toUpperCase(Locale.ENGLISH));
            Material mat = (Material)mats.mats.get("primary");
            PipeType p = AntimatterAPI.get(FluidPipe.class, "fluid_" + mat.getId());
            int amount = size == PipeSize.TINY ? 12 : (size == PipeSize.SMALL ? 6 : (size == PipeSize.NORMAL ? 2 : 1));
            return new ItemStack((ItemLike)p.getBlock(size), amount);
        }

        @Override
        public Map<String, Object> getFromResult(@Nonnull ItemStack stack) {
            return ImmutableMap.of((Object)"primary", (Object)((PipeType)((PipeItemBlock)stack.m_41720_()).getPipe().getType()).getMaterial());
        }
    });
    public static final MaterialRecipe.Provider TOOL_BUILDER = MaterialRecipe.registerProvider("tool", "antimatter", id -> new MaterialRecipe.ItemBuilder(){

        @Override
        public ItemStack build(CraftingContainer inv, MaterialRecipe.Result mats) {
            Material m = (Material)mats.mats.get("secondary");
            AntimatterToolType type = AntimatterAPI.get(AntimatterToolType.class, id);
            return type.getToolStack((Material)mats.mats.get("primary"), m == null ? Material.NULL : m);
        }

        @Override
        public Map<String, Object> getFromResult(@Nonnull ItemStack stack) {
            CompoundTag nbt = stack.m_41783_().m_128469_("td");
            Material primary = AntimatterAPI.get(Material.class, nbt.m_128461_("m"));
            Material secondary = AntimatterAPI.get(Material.class, nbt.m_128461_("sm"));
            return ImmutableMap.of((Object)"primary", (Object)(primary != null ? primary : Material.NULL), (Object)"secondary", (Object)(secondary != null ? secondary : Material.NULL));
        }
    });
    public static final MaterialRecipe.Provider PROBE_BUILDER = MaterialRecipe.registerProvider("probe", "antimatter", id -> new MaterialRecipe.ItemBuilder(){

        @Override
        public ItemStack build(CraftingContainer inv, MaterialRecipe.Result mats) {
            Object h = mats.mats.get("helmet");
            ItemStack helmet = ((ItemStack)h).m_41777_();
            CompoundTag nbt = helmet.m_41784_();
            if (nbt.m_128441_("theoneprobe") && nbt.m_128471_("theoneprobe")) {
                return ItemStack.f_41583_;
            }
            nbt.m_128379_("theoneprobe", true);
            return helmet;
        }

        @Override
        public Map<String, Object> getFromResult(@Nonnull ItemStack stack) {
            return ImmutableMap.of();
        }
    });
    public static final MaterialRecipe.Provider WOOD_TOOL_BUILDER = MaterialRecipe.registerProvider("wood_tool", "antimatter", id -> new MaterialRecipe.ItemBuilder(){

        @Override
        public ItemStack build(CraftingContainer inv, MaterialRecipe.Result mats) {
            Material m = (Material)mats.mats.get("secondary");
            AntimatterToolType type = AntimatterAPI.get(AntimatterToolType.class, id);
            ItemStack stack = type.getToolStack(Material.get("wood"), m == null ? Material.NULL : m);
            return stack;
        }

        @Override
        public Map<String, Object> getFromResult(@Nonnull ItemStack stack) {
            CompoundTag nbt = stack.m_41783_().m_128469_("td");
            Material primary = AntimatterAPI.get(Material.class, nbt.m_128461_("m"));
            Material secondary = AntimatterAPI.get(Material.class, nbt.m_128461_("sm"));
            return ImmutableMap.of((Object)"primary", (Object)(primary != null ? primary : Material.NULL), (Object)"secondary", (Object)(secondary != null ? secondary : Material.NULL));
        }
    });
    public static final MaterialRecipe.Provider CROWBAR_BUILDER = MaterialRecipe.registerProvider("crowbar", "antimatter", id -> new MaterialRecipe.ItemBuilder(){

        @Override
        public ItemStack build(CraftingContainer inv, MaterialRecipe.Result mats) {
            int dye = ((DyeColor)mats.mats.get((Object)"secondary")).m_41069_().f_76396_;
            AntimatterToolType type = AntimatterAPI.get(AntimatterToolType.class, id);
            ItemStack stack = type.getToolStack((Material)mats.mats.get("primary"), Material.NULL);
            stack.m_41737_("td").m_128405_("sc", dye);
            return stack;
        }

        @Override
        public Map<String, Object> getFromResult(@Nonnull ItemStack stack) {
            CompoundTag nbt = stack.m_41783_().m_128469_("td");
            Material primary = AntimatterAPI.get(Material.class, nbt.m_128461_("m"));
            int secondary = nbt.m_128451_("sc");
            Optional<DyeColor> color = Arrays.stream(DyeColor.values()).filter(t -> t.m_41069_().f_76396_ == secondary).findFirst();
            return ImmutableMap.of((Object)"primary", (Object)(primary != null ? primary : Material.NULL), (Object)"secondary", (Object)(color.isEmpty() ? Material.NULL : color.get()));
        }
    });

    public static void init() {
    }

    public static DyeColor getColor(ItemStack stack) {
        if (stack.m_41720_() instanceof DyeItem) {
            return ((DyeItem)stack.m_41720_()).m_41089_();
        }
        for (int i = 0; i < 15; ++i) {
            DyeColor color = DyeColor.m_41053_((int)i);
            String colorString = color.m_41065_();
            if (stack.m_204117_(TagUtils.getForgelikeItemTag("dyes/" + colorString))) {
                return color;
            }
            if (!stack.m_204117_(TagUtils.getForgelikeItemTag(colorString + "_dyes"))) continue;
            return color;
        }
        return null;
    }

    static {
        PropertyIngredient.addGetter(TagUtils.getForgelikeItemTag("dyes").f_203868_(), RecipeBuilders::getColor);
    }
}

