/*
 * Decompiled with CFR 0.152.
 */
package muramasa.antimatter.recipe;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import muramasa.antimatter.Ref;
import muramasa.antimatter.recipe.IRecipe;
import muramasa.antimatter.recipe.IRecipeValidator;
import muramasa.antimatter.recipe.RecipeTag;
import muramasa.antimatter.recipe.ingredient.FluidIngredient;
import muramasa.antimatter.recipe.ingredient.RecipeIngredient;
import muramasa.antimatter.recipe.map.RecipeMap;
import muramasa.antimatter.recipe.serializer.AntimatterRecipeSerializer;
import muramasa.antimatter.util.AntimatterPlatformUtils;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.Container;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraftforge.fluids.FluidStack;

public class Recipe
implements IRecipe {
    private final ItemStack[] itemsOutput;
    @Nonnull
    private final List<Ingredient> itemsInput;
    @Nonnull
    private final List<FluidIngredient> fluidsInput;
    private final FluidStack[] fluidsOutput;
    private final int duration;
    private final int special;
    private final long power;
    private final int amps;
    private int[] chances;
    private boolean hidden;
    private Set<RecipeTag> tags = new ObjectOpenHashSet();
    private Map<ItemStack, Integer> itemsWithChances = null;
    public ResourceLocation id;
    public String mapId;
    public final List<IRecipeValidator> validators = Collections.emptyList();
    private boolean valid;
    public static final RecipeType<IRecipe> RECIPE_TYPE = RecipeType.m_44119_((String)"antimatter_machine");

    public static void init() {
    }

    public Recipe(@Nonnull List<Ingredient> stacksInput, ItemStack[] stacksOutput, @Nonnull List<FluidIngredient> fluidsInput, FluidStack[] fluidsOutput, int duration, long power, int special, int amps) {
        this.itemsInput = ImmutableList.copyOf(stacksInput);
        this.itemsOutput = stacksOutput;
        this.duration = duration;
        this.power = power;
        this.special = special;
        this.fluidsInput = ImmutableList.copyOf(fluidsInput);
        this.amps = amps;
        this.fluidsOutput = fluidsOutput;
        this.valid = true;
    }

    @Override
    public boolean isValid() {
        return this.valid;
    }

    @Override
    public void invalidate() {
        if (this.id != null) {
            this.valid = false;
        }
    }

    @Override
    public int getAmps() {
        return this.amps;
    }

    @Override
    public void addChances(int[] chances) {
        this.chances = chances;
    }

    @Override
    public void setHidden(boolean hidden) {
        this.hidden = hidden;
    }

    @Override
    public void addTags(Set<RecipeTag> tags) {
        this.tags = tags;
    }

    @Override
    public boolean hasInputItems() {
        return this.itemsInput.size() > 0;
    }

    @Override
    public boolean hasOutputItems() {
        return this.itemsOutput != null && this.itemsOutput.length > 0;
    }

    @Override
    public boolean hasInputFluids() {
        return this.fluidsInput.size() > 0;
    }

    @Override
    public boolean hasOutputFluids() {
        return this.fluidsOutput != null && this.fluidsOutput.length > 0;
    }

    @Override
    public boolean hasChances() {
        return this.chances != null && this.chances.length == this.itemsOutput.length;
    }

    @Override
    public void setIds(ResourceLocation id, String map) {
        this.id = id;
        this.mapId = map;
    }

    @Override
    public void setId(ResourceLocation id) {
        this.id = id;
    }

    @Override
    public void setMapId(String mapId) {
        this.mapId = mapId;
    }

    @Override
    public void sortInputItems() {
        this.itemsInput.sort((a, b) -> {
            boolean a2;
            boolean a1 = RecipeMap.isIngredientSpecial(a);
            if (a1 == (a2 = RecipeMap.isIngredientSpecial(b))) {
                return 0;
            }
            if (a1) {
                return 1;
            }
            return -1;
        });
    }

    @Override
    @Nonnull
    public List<Ingredient> getInputItems() {
        return this.hasInputItems() ? this.itemsInput : Collections.emptyList();
    }

    @Nonnull
    public List<RecipeIngredient> getCastedInputs() {
        return this.hasInputItems() ? this.itemsInput.stream().filter(t -> t instanceof RecipeIngredient).map(t -> (RecipeIngredient)((Object)t)).collect(Collectors.toList()) : Collections.emptyList();
    }

    @Override
    @Nullable
    public ItemStack[] getOutputItems() {
        return this.getOutputItems(true);
    }

    @Override
    public ItemStack[] getOutputItems(boolean chance) {
        if (this.hasOutputItems()) {
            ItemStack[] outputs = (ItemStack[])this.itemsOutput.clone();
            if (this.chances != null) {
                ObjectArrayList evaluated = new ObjectArrayList();
                for (int i = 0; i < outputs.length; ++i) {
                    if (chance && Ref.RNG.nextInt(10000) >= this.chances[i]) continue;
                    evaluated.add(outputs[i].m_41777_());
                }
                outputs = evaluated.toArray(new ItemStack[0]);
            }
            return outputs;
        }
        return null;
    }

    @Override
    public ItemStack[] getFlatOutputItems() {
        if (this.hasOutputItems()) {
            ItemStack[] outputs = (ItemStack[])this.itemsOutput.clone();
            if (this.chances != null) {
                ObjectArrayList evaluated = new ObjectArrayList();
                for (int i = 0; i < outputs.length; ++i) {
                    if (this.chances[i] < 10000) continue;
                    evaluated.add(outputs[i]);
                }
                outputs = evaluated.toArray(new ItemStack[0]);
            }
            return outputs;
        }
        return null;
    }

    @Override
    public boolean hasSpecialIngredients() {
        for (Ingredient ingredient : this.itemsInput) {
            if (!RecipeMap.isIngredientSpecial(ingredient)) continue;
            return true;
        }
        return false;
    }

    @Override
    @Nonnull
    public List<FluidIngredient> getInputFluids() {
        return this.fluidsInput;
    }

    @Override
    @Nullable
    public FluidStack[] getOutputFluids() {
        return this.hasOutputFluids() ? (FluidStack[])this.fluidsOutput.clone() : null;
    }

    @Override
    public int getDuration() {
        return this.duration;
    }

    @Override
    public long getPower() {
        return this.power;
    }

    @Override
    @Nullable
    public int[] getChances() {
        return this.chances;
    }

    @Override
    public int getSpecialValue() {
        return this.special;
    }

    @Override
    public boolean isHidden() {
        return this.hidden;
    }

    @Override
    public Set<RecipeTag> getTags() {
        return this.tags;
    }

    @Override
    public Map<ItemStack, Integer> getChancesWithStacks() {
        if (this.itemsWithChances == null) {
            if (this.itemsOutput != null) {
                ImmutableMap.Builder map = ImmutableMap.builder();
                if (this.hasChances()) {
                    for (int i = 0; i < this.itemsOutput.length; ++i) {
                        map.put((Object)this.itemsOutput[i], (Object)this.chances[i]);
                    }
                } else {
                    for (ItemStack itemStack : this.itemsOutput) {
                        map.put((Object)itemStack, (Object)10000);
                    }
                }
                this.itemsWithChances = map.build();
            } else {
                this.itemsWithChances = ImmutableMap.of();
            }
        }
        return this.itemsWithChances;
    }

    public String toString() {
        int i;
        StringBuilder builder = new StringBuilder();
        if (this.itemsInput.size() > 0) {
            builder.append("\nInput Items: { ");
            for (i = 0; i < this.itemsInput.size(); ++i) {
                builder.append("\n Item ").append(i);
                builder.append(this.itemsInput.get(i).m_43942_());
                if (i == this.itemsInput.size() - 1) continue;
                builder.append(", ");
            }
            builder.append(" }\n");
        }
        if (this.itemsOutput != null) {
            builder.append("Output Items: { ");
            for (i = 0; i < this.itemsOutput.length; ++i) {
                builder.append(this.itemsOutput[i].m_41786_()).append(" x").append(this.itemsOutput[i].m_41613_());
                if (i == this.itemsOutput.length - 1) continue;
                builder.append(", ");
            }
            builder.append(" }\n");
        }
        if (this.fluidsInput != null) {
            builder.append("Input Fluids: { ");
            builder.append(" }\n");
        }
        if (this.fluidsOutput != null) {
            builder.append("Output Fluids: { ");
            for (i = 0; i < this.fluidsOutput.length; ++i) {
                builder.append(AntimatterPlatformUtils.getIdFromFluid(this.fluidsOutput[i].getFluid())).append(": ").append(this.fluidsOutput[i].getAmount()).append("mb");
                if (i == this.fluidsOutput.length - 1) continue;
                builder.append(", ");
            }
            builder.append(" }\n");
        }
        if (this.chances != null) {
            builder.append("Chances: { ");
            for (i = 0; i < this.chances.length; ++i) {
                builder.append((float)this.chances[i] / 100.0f).append("%");
                if (i == this.chances.length - 1) continue;
                builder.append(", ");
            }
            builder.append(" }\n");
        }
        builder.append("Special: ").append(this.special).append("\n");
        return builder.toString();
    }

    public boolean m_5818_(Container inv, Level worldIn) {
        return false;
    }

    public ItemStack m_5874_(Container inv) {
        return ItemStack.f_41583_;
    }

    public boolean m_8004_(int width, int height) {
        return false;
    }

    public ItemStack m_8043_() {
        return ItemStack.f_41583_;
    }

    @Override
    public String getMapId() {
        return this.mapId;
    }

    public ResourceLocation m_6423_() {
        return this.id != null ? this.id : new ResourceLocation("antimatter", "default");
    }

    public RecipeSerializer<?> m_7707_() {
        return AntimatterRecipeSerializer.INSTANCE;
    }

    @Nonnull
    public RecipeType<?> m_6671_() {
        return RECIPE_TYPE;
    }

    public boolean m_5598_() {
        return true;
    }

    @Override
    public List<IRecipeValidator> getValidators() {
        return this.validators;
    }
}

