/*
 * Decompiled with CFR 0.152.
 */
package muramasa.antimatter.recipe;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import muramasa.antimatter.recipe.IRecipeValidator;
import muramasa.antimatter.recipe.RecipeTag;
import muramasa.antimatter.recipe.RecipeUtil;
import muramasa.antimatter.recipe.ingredient.FluidIngredient;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.Container;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraftforge.fluids.FluidStack;

public interface IRecipe
extends Recipe<Container> {
    public boolean isValid();

    public void invalidate();

    public int getAmps();

    public void addChances(int[] var1);

    public void setHidden(boolean var1);

    public void addTags(Set<RecipeTag> var1);

    public boolean hasInputItems();

    public boolean hasOutputItems();

    public boolean hasInputFluids();

    public boolean hasOutputFluids();

    public boolean hasChances();

    public void setIds(ResourceLocation var1, String var2);

    public void setId(ResourceLocation var1);

    public void setMapId(String var1);

    public void sortInputItems();

    public List<Ingredient> getInputItems();

    public ItemStack[] getOutputItems();

    public ItemStack[] getOutputItems(boolean var1);

    public ItemStack[] getFlatOutputItems();

    public boolean hasSpecialIngredients();

    @Nonnull
    public List<FluidIngredient> getInputFluids();

    @Nullable
    public FluidStack[] getOutputFluids();

    public int getDuration();

    public long getPower();

    @Nullable
    public int[] getChances();

    default public long getTotalPower() {
        return (long)this.getDuration() * this.getPower();
    }

    public int getSpecialValue();

    public boolean isHidden();

    public Set<RecipeTag> getTags();

    public Map<ItemStack, Integer> getChancesWithStacks();

    public String getMapId();

    default public JsonObject toJson() {
        int n;
        JsonObject json = new JsonObject();
        JsonArray array = new JsonArray();
        for (Ingredient ingredient : this.getInputItems()) {
            array.add(ingredient.m_43942_());
        }
        if (!array.isEmpty()) {
            json.add("item_in", (JsonElement)array);
        }
        array = new JsonArray();
        if (this.getOutputItems(false) != null) {
            ItemStack[] itemStackArray = this.getOutputItems(false);
            int ingredient = itemStackArray.length;
            for (n = 0; n < ingredient; ++n) {
                ItemStack itemStack = itemStackArray[n];
                array.add((JsonElement)RecipeUtil.itemstackToJson(itemStack));
            }
        }
        if (!array.isEmpty()) {
            json.add("item_out", (JsonElement)array);
        }
        array = new JsonArray();
        for (FluidIngredient f : this.getInputFluids()) {
            array.add((JsonElement)f.toJson());
        }
        if (!array.isEmpty()) {
            json.add("fluid_in", (JsonElement)array);
        }
        array = new JsonArray();
        if (this.getOutputFluids() != null) {
            FluidStack[] fluidStackArray = this.getOutputFluids();
            int n2 = fluidStackArray.length;
            for (n = 0; n < n2; ++n) {
                FluidStack fluidStack = fluidStackArray[n];
                array.add((JsonElement)RecipeUtil.fluidstackToJson(fluidStack));
            }
        }
        if (!array.isEmpty()) {
            json.add("fluid_out", (JsonElement)array);
        }
        array = new JsonArray();
        json.addProperty("eu", (Number)this.getPower());
        json.addProperty("duration", (Number)this.getDuration());
        json.addProperty("amps", (Number)this.getAmps());
        json.addProperty("special", (Number)this.getSpecialValue());
        if (this.hasChances()) {
            int[] nArray = this.getChances();
            int n3 = nArray.length;
            for (n = 0; n < n3; ++n) {
                double d = nArray[n];
                array.add((Number)d);
            }
        }
        if (!array.isEmpty()) {
            json.add("chances", (JsonElement)array);
        }
        json.addProperty("recipeID", this.m_6423_().toString());
        json.addProperty("map", this.getMapId());
        return json;
    }

    public List<IRecipeValidator> getValidators();
}

