/*
 * Decompiled with CFR 0.152.
 */
package muramasa.antimatter.proxy;

import dev.architectury.injectables.annotations.ExpectPlatform;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import java.util.Set;
import muramasa.antimatter.AntimatterAPI;
import muramasa.antimatter.Data;
import muramasa.antimatter.block.BlockStorage;
import muramasa.antimatter.block.BlockSurfaceRock;
import muramasa.antimatter.client.AntimatterTextureStitcher;
import muramasa.antimatter.client.ModelUtils;
import muramasa.antimatter.client.tesr.MachineTESR;
import muramasa.antimatter.cover.CoverFactory;
import muramasa.antimatter.cover.ICover;
import muramasa.antimatter.data.AntimatterMaterialTypes;
import muramasa.antimatter.fluid.AntimatterFluid;
import muramasa.antimatter.gui.MenuHandler;
import muramasa.antimatter.machine.BlockMachine;
import muramasa.antimatter.machine.BlockMultiMachine;
import muramasa.antimatter.machine.types.Machine;
import muramasa.antimatter.material.MaterialType;
import muramasa.antimatter.ore.BlockOre;
import muramasa.antimatter.pipe.BlockPipe;
import muramasa.antimatter.proxy.IProxyHandler;
import muramasa.antimatter.proxy.forge.ClientHandlerImpl;
import muramasa.antimatter.registration.IColorHandler;
import muramasa.antimatter.util.AntimatterPlatformUtils;
import net.minecraft.client.Minecraft;
import net.minecraft.client.color.block.BlockColors;
import net.minecraft.client.color.item.ItemColors;
import net.minecraft.client.gui.screens.MenuScreens;
import net.minecraft.client.multiplayer.ClientPacketListener;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.material.Fluid;

public class ClientHandler
implements IProxyHandler {
    public ClientHandler() {
        AntimatterTextureStitcher.addStitcher(event -> AntimatterAPI.all(CoverFactory.class).forEach(cover -> {
            if (cover == ICover.emptyFactory) {
                return;
            }
            for (ResourceLocation resourceLocation : cover.getTextures()) {
                event.accept(resourceLocation);
            }
        }));
    }

    public static boolean isLocal() {
        Minecraft mc = Minecraft.m_91087_();
        if (mc == null) {
            return true;
        }
        ClientPacketListener listener = mc.m_91403_();
        if (listener == null) {
            return true;
        }
        return listener.m_6198_().m_129531_();
    }

    /*
     * WARNING - void declaration
     */
    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static <T extends BlockEntity> void registerBlockEntityRenderer(BlockEntityType<T> type, BlockEntityRendererProvider<T> renderProvider) {
        void var1_1;
        ClientHandlerImpl.registerBlockEntityRenderer(type, var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static <T extends Entity> void registerEntityRenderer(EntityType<T> type, EntityRendererProvider<T> renderProvider) {
        void var1_1;
        ClientHandlerImpl.registerEntityRenderer(type, var1_1);
    }

    public static void setup() {
        MaterialType.buildTooltips();
        AntimatterAPI.runLaterClient(() -> {
            ObjectOpenHashSet registered = new ObjectOpenHashSet();
            AntimatterAPI.all(MenuHandler.class, arg_0 -> ClientHandler.lambda$setup$2((Set)registered, arg_0));
        });
        AntimatterAPI.runLaterClient(() -> {
            ModelUtils.setRenderLayer(Data.PROXY_INSTANCE, RenderType.m_110463_());
            AntimatterAPI.all(BlockMachine.class, b -> ModelUtils.setRenderLayer(b, RenderType.m_110463_()));
            AntimatterAPI.all(BlockMultiMachine.class, b -> ModelUtils.setRenderLayer(b, RenderType.m_110463_()));
            AntimatterAPI.all(BlockOre.class, b -> ModelUtils.setRenderLayer(b, RenderType.m_110463_()));
            AntimatterAPI.all(BlockPipe.class, b -> ModelUtils.setRenderLayer(b, RenderType.m_110463_()));
            AntimatterAPI.all(BlockStorage.class).stream().filter(b -> b.getType() == AntimatterMaterialTypes.FRAME || b.getType() == AntimatterMaterialTypes.RAW_ORE_BLOCK).forEach(b -> ModelUtils.setRenderLayer(b, RenderType.m_110463_()));
            AntimatterAPI.all(BlockSurfaceRock.class).stream().forEach(b -> ModelUtils.setRenderLayer(b, RenderType.m_110463_()));
            AntimatterAPI.all(AntimatterFluid.class).forEach(f -> {
                ModelUtils.setRenderLayer((Fluid)f.getFluid(), RenderType.m_110466_());
                ModelUtils.setRenderLayer((Fluid)f.getFlowingFluid(), RenderType.m_110466_());
            });
        });
        AntimatterAPI.all(Machine.class).stream().filter(Machine::renderAsTesr).filter(Machine::renderContainerLiquids).map(Machine::getTileType).distinct().forEach(i -> ClientHandler.registerBlockEntityRenderer(i, MachineTESR::new));
    }

    public static void onItemColorHandler(ItemColors colors) {
        IColorHandler h;
        for (Item item : AntimatterAPI.all(Item.class)) {
            if (!(item instanceof IColorHandler) || !(h = (IColorHandler)item).registerColorHandlers()) continue;
            colors.m_92689_((stack, i) -> h.getItemColor(stack, null, i), new ItemLike[]{item});
        }
        for (Block block : AntimatterAPI.all(Block.class)) {
            if (!(block instanceof IColorHandler) || !(h = (IColorHandler)block).registerColorHandlers()) continue;
            colors.m_92689_((stack, i) -> h.getItemColor(stack, null, i), new ItemLike[]{block.m_5456_()});
        }
    }

    public static void onBlockColorHandler(BlockColors colors) {
        for (Block block : AntimatterAPI.all(Block.class)) {
            IColorHandler h;
            if (!(block instanceof IColorHandler) || !(h = (IColorHandler)block).registerColorHandlers()) continue;
            colors.m_92589_(h::getBlockColor, new Block[]{block});
        }
    }

    public static void onModelRegistry() {
    }

    @Override
    public Level getClientWorld() {
        return Minecraft.m_91087_().f_91073_;
    }

    @Override
    public Player getClientPlayer() {
        return Minecraft.m_91087_().f_91074_;
    }

    private static /* synthetic */ void lambda$setup$2(Set registered, MenuHandler h) {
        if (!registered.contains(AntimatterPlatformUtils.getIdFromMenuType(h.getContainerType()))) {
            registered.add(AntimatterPlatformUtils.getIdFromMenuType(h.getContainerType()));
            MenuScreens.m_96206_(h.getContainerType(), (MenuScreens.ScreenConstructor)AntimatterAPI.get(MenuScreens.ScreenConstructor.class, h.screenID(), h.screenDomain()));
        }
    }
}

