/*
 * Decompiled with CFR 0.152.
 */
package muramasa.antimatter.pipe.types;

import com.google.common.collect.ImmutableSet;
import com.mojang.datafixers.util.Pair;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import muramasa.antimatter.AntimatterAPI;
import muramasa.antimatter.material.Material;
import muramasa.antimatter.pipe.BlockPipe;
import muramasa.antimatter.pipe.PipeItemBlock;
import muramasa.antimatter.pipe.PipeSize;
import muramasa.antimatter.registration.IRegistryEntryProvider;
import muramasa.antimatter.registration.ISharedAntimatterObject;
import muramasa.antimatter.registration.RegistryType;
import muramasa.antimatter.tile.TileEntityBase;
import muramasa.antimatter.tile.pipe.TileEntityPipe;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;

public abstract class PipeType<T extends PipeType<T>>
implements IRegistryEntryProvider,
ISharedAntimatterObject {
    public final String domain;
    protected Material material;
    protected ImmutableSet<PipeSize> sizes = ImmutableSet.of();
    protected BlockEntityType<? extends TileEntityPipe<?>> tileType;
    protected Map<PipeSize, Block> registeredBlocks;
    private final TileEntityBase.BlockEntitySupplier<TileEntityPipe<?>, T> tileFunc;

    public PipeType(String domain, Material material, TileEntityBase.BlockEntitySupplier<TileEntityPipe<?>, T> func) {
        this.domain = domain;
        this.material = material;
        this.sizes(PipeSize.VALUES);
        this.tileFunc = func;
    }

    @Override
    public void onRegistryBuild(RegistryType registry) {
        if (registry != RegistryType.BLOCKS) {
            return;
        }
        Set<Block> blocks = this.getBlocks();
        this.registeredBlocks = blocks.stream().map(t -> new Pair((Object)((BlockPipe)t).getSize(), t)).collect(Collectors.toMap(Pair::getFirst, Pair::getSecond));
        this.tileType = new BlockEntityType((pos, state) -> this.tileFunc.create(this, pos, state), blocks, null);
        AntimatterAPI.registerTransferApiPipe(this.tileType);
        AntimatterAPI.register(BlockEntityType.class, this.getId(), this.getDomain(), this.getTileType());
    }

    public Block getBlock(PipeSize size) {
        return this.registeredBlocks.get(size);
    }

    public PipeItemBlock getBlockItem(PipeSize size) {
        return (PipeItemBlock)((Object)Item.f_41373_.get(this.getBlock(size)));
    }

    public abstract Set<Block> getBlocks();

    public abstract String getType();

    @Override
    public String getId() {
        return this.getType() + "_" + this.material.getId();
    }

    public abstract String getTypeName();

    public Material getMaterial() {
        return this.material;
    }

    public ImmutableSet<PipeSize> getSizes() {
        return this.sizes;
    }

    public BlockEntityType<?> getTileType() {
        return this.tileType;
    }

    public T sizes(PipeSize ... sizes) {
        this.sizes = ImmutableSet.copyOf((Object[])sizes);
        return (T)this;
    }
}

