/*
 * Decompiled with CFR 0.152.
 */
package muramasa.antimatter.pipe.types;

import java.util.Set;
import java.util.stream.Collectors;
import muramasa.antimatter.material.Material;
import muramasa.antimatter.material.MaterialTags;
import muramasa.antimatter.pipe.BlockItemPipe;
import muramasa.antimatter.pipe.PipeSize;
import muramasa.antimatter.pipe.types.PipeType;
import muramasa.antimatter.tile.pipe.TileEntityItemPipe;
import net.minecraft.world.level.block.Block;

public class ItemPipe<T extends ItemPipe<T>>
extends PipeType<T> {
    protected int[] caps;

    public ItemPipe(String domain, Material material) {
        super(domain, material, TileEntityItemPipe::new);
        material.flags(MaterialTags.ITEMPIPE);
        this.sizes(PipeSize.NORMAL, PipeSize.LARGE, PipeSize.HUGE);
    }

    @Override
    public String getType() {
        return "item_pipe";
    }

    @Override
    public String getTypeName() {
        return "item_pipe";
    }

    @Override
    public Set<Block> getBlocks() {
        return this.sizes.stream().map(s -> new BlockItemPipe<ItemPipe>(this, (PipeSize)s)).collect(Collectors.toSet());
    }

    public int getCapacity(PipeSize size) {
        return this.caps[size.ordinal()];
    }

    public T caps(int baseCap) {
        this.caps = new int[]{baseCap, baseCap * 2, baseCap * 3, baseCap * 4, baseCap * 5, baseCap * 6};
        return (T)this;
    }

    public T caps(int ... caps) {
        this.caps = caps;
        return (T)this;
    }
}

