/*
 * Decompiled with CFR 0.152.
 */
package muramasa.antimatter.pipe.types;

import java.util.Arrays;
import java.util.Set;
import java.util.stream.Collectors;
import muramasa.antimatter.material.Material;
import muramasa.antimatter.material.MaterialTags;
import muramasa.antimatter.pipe.BlockFluidPipe;
import muramasa.antimatter.pipe.PipeSize;
import muramasa.antimatter.pipe.types.PipeType;
import muramasa.antimatter.tile.pipe.TileEntityFluidPipe;
import net.minecraft.world.level.block.Block;

public class FluidPipe<T extends FluidPipe<T>>
extends PipeType<T> {
    protected int maxTemp;
    protected boolean gasProof;
    protected int[] caps;
    protected int[] pressures;

    public FluidPipe(String domain, Material material, int maxTemp, boolean gasProof) {
        super(domain, material, TileEntityFluidPipe::new);
        this.maxTemp = maxTemp;
        this.gasProof = gasProof;
        material.flags(MaterialTags.FLUIDPIPE);
        this.sizes(PipeSize.TINY, PipeSize.SMALL, PipeSize.NORMAL, PipeSize.LARGE, PipeSize.HUGE);
    }

    @Override
    public String getTypeName() {
        return "fluid_pipe";
    }

    @Override
    public String getType() {
        return "fluid_pipe";
    }

    @Override
    public Set<Block> getBlocks() {
        return this.sizes.stream().map(s -> new BlockFluidPipe<FluidPipe>(this, (PipeSize)s)).collect(Collectors.toSet());
    }

    public int getTemperature() {
        return this.maxTemp;
    }

    public boolean isGasProof() {
        return this.gasProof;
    }

    public int getCapacity(PipeSize size) {
        return this.caps[size.ordinal()];
    }

    public int getPressure(PipeSize size) {
        return this.pressures[size.ordinal()];
    }

    public T caps(int baseCap) {
        this.caps = new int[]{baseCap, baseCap, baseCap, baseCap, baseCap, baseCap};
        return (T)this;
    }

    public T caps(int ... caps) {
        this.caps = caps;
        return (T)this;
    }

    public T pressures(int basePressure) {
        this.pressures = new int[]{basePressure /= 20, basePressure * 2, basePressure * 3, basePressure * 4, basePressure * 5, basePressure * 6};
        return (T)this;
    }

    public T pressures(int ... pressures) {
        this.pressures = Arrays.stream(pressures).map(t -> t / 20).toArray();
        return (T)this;
    }
}

