/*
 * Decompiled with CFR 0.152.
 */
package muramasa.antimatter.pipe.types;

import java.util.Set;
import java.util.stream.Collectors;
import muramasa.antimatter.machine.Tier;
import muramasa.antimatter.material.Material;
import muramasa.antimatter.material.MaterialTags;
import muramasa.antimatter.pipe.BlockCable;
import muramasa.antimatter.pipe.PipeSize;
import muramasa.antimatter.pipe.types.PipeType;
import muramasa.antimatter.tile.pipe.TileEntityCable;
import net.minecraft.world.level.block.Block;

public class Cable<T extends Cable<T>>
extends PipeType<T> {
    protected int loss;
    protected Tier tier;
    protected int[] amps;

    public Cable(String domain, Material material, int loss, Tier tier) {
        super(domain, material, TileEntityCable::new);
        this.loss = loss;
        this.tier = tier;
        material.flags(MaterialTags.CABLE);
    }

    @Override
    public String getType() {
        return "cable";
    }

    @Override
    public String getTypeName() {
        return "energy";
    }

    @Override
    public Set<Block> getBlocks() {
        return this.sizes.stream().map(s -> new BlockCable<Cable>(this, (PipeSize)s, true)).collect(Collectors.toSet());
    }

    public int getLoss() {
        return this.loss;
    }

    public Tier getTier() {
        return this.tier;
    }

    public int getAmps(PipeSize size) {
        return this.amps[size.ordinal()];
    }

    public T amps(int baseAmps) {
        this.amps = new int[]{baseAmps, baseAmps * 2, baseAmps * 4, baseAmps * 8, baseAmps * 12, baseAmps * 16};
        return (T)this;
    }

    public T amps(int ... amps) {
        this.amps = amps;
        return (T)this;
    }
}

