/*
 * Decompiled with CFR 0.152.
 */
package muramasa.antimatter.pipe;

import java.util.Locale;
import muramasa.antimatter.registration.IAntimatterObject;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.world.phys.AABB;

public enum PipeSize implements IAntimatterObject
{
    VTINY(1),
    TINY(2),
    SMALL(4),
    NORMAL(8),
    LARGE(12),
    HUGE(16);

    public static final PipeSize[] VALUES;
    private final int cableThickness;
    private final AABB AABB;

    private PipeSize(int cableThickness) {
        this.cableThickness = cableThickness;
        float offset = 0.0625f * (float)this.ordinal();
        this.AABB = new AABB(0.4375 - (double)offset, 0.4375 - (double)offset, 0.4375 - (double)offset, 0.5625 + (double)offset, 0.5625 + (double)offset, 0.5625 + (double)offset);
    }

    @Override
    public String getId() {
        return this.name().toLowerCase(Locale.ENGLISH);
    }

    public Component getDisplayName() {
        return new TranslatableComponent("pipe." + this.getId());
    }

    public int getCableThickness() {
        return this.cableThickness;
    }

    public AABB getAABB() {
        return this.AABB;
    }

    static {
        VALUES = PipeSize.values();
    }
}

