/*
 * Decompiled with CFR 0.152.
 */
package muramasa.antimatter.pipe;

import com.google.common.collect.ImmutableMap;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import muramasa.antimatter.AntimatterAPI;
import muramasa.antimatter.Data;
import muramasa.antimatter.Ref;
import muramasa.antimatter.block.AntimatterItemBlock;
import muramasa.antimatter.capability.ICoverHandler;
import muramasa.antimatter.client.AntimatterModelManager;
import muramasa.antimatter.cover.CoverFactory;
import muramasa.antimatter.cover.ICover;
import muramasa.antimatter.cover.IHaveCover;
import muramasa.antimatter.data.AntimatterDefaultTools;
import muramasa.antimatter.data.AntimatterMaterials;
import muramasa.antimatter.datagen.builder.AntimatterBlockModelBuilder;
import muramasa.antimatter.datagen.builder.AntimatterItemModelBuilder;
import muramasa.antimatter.datagen.builder.VariantBlockStateBuilder;
import muramasa.antimatter.datagen.providers.AntimatterBlockStateProvider;
import muramasa.antimatter.datagen.providers.AntimatterItemModelProvider;
import muramasa.antimatter.dynamic.BlockDynamic;
import muramasa.antimatter.dynamic.ModelConfig;
import muramasa.antimatter.pipe.PipeItemBlock;
import muramasa.antimatter.pipe.PipeSize;
import muramasa.antimatter.pipe.types.PipeType;
import muramasa.antimatter.registration.IColorHandler;
import muramasa.antimatter.registration.IItemBlockProvider;
import muramasa.antimatter.registration.ISharedAntimatterObject;
import muramasa.antimatter.texture.Texture;
import muramasa.antimatter.tile.TileEntityTickable;
import muramasa.antimatter.tile.pipe.TileEntityPipe;
import muramasa.antimatter.tool.AntimatterToolType;
import muramasa.antimatter.util.AntimatterCapUtils;
import muramasa.antimatter.util.AntimatterPlatformUtils;
import muramasa.antimatter.util.Utils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.EntityCollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public abstract class BlockPipe<T extends PipeType<T>>
extends BlockDynamic
implements IItemBlockProvider,
EntityBlock,
IColorHandler,
SimpleWaterloggedBlock,
ISharedAntimatterObject {
    protected T type;
    protected PipeSize size;
    protected final int modelId;
    protected Texture side;
    protected Texture[] faces;
    public static final BooleanProperty TICKING = BooleanProperty.m_61465_((String)"ticking");

    public BlockPipe(String prefix, T type, PipeSize size, int modelId) {
        this(prefix, type, size, modelId, ((PipeType)type).getMaterial() == AntimatterMaterials.Wood ? BlockBehaviour.Properties.m_60939_((Material)Material.f_76320_).m_60918_(SoundType.f_56736_).m_60913_(1.0f, 3.0f).m_60955_() : BlockBehaviour.Properties.m_60939_((Material)Data.WRENCH_MATERIAL).m_60913_(1.0f, 3.0f).m_60955_().m_60999_());
    }

    public BlockPipe(String prefix, T type, PipeSize size, int modelId, BlockBehaviour.Properties properties) {
        super(((PipeType)type).domain, prefix + "_" + size.getId(), properties);
        this.type = type;
        this.size = size;
        this.side = new Texture(((PipeType)type).getMaterial().getSet().getDomain(), ((PipeType)type).getMaterial().getSet().getPath() + "/pipe/pipe_side");
        this.faces = new Texture[]{new Texture(((PipeType)type).getMaterial().getSet().getDomain(), ((PipeType)type).getMaterial().getSet().getPath() + "/pipe/pipe_vtiny"), new Texture(((PipeType)type).getMaterial().getSet().getDomain(), ((PipeType)type).getMaterial().getSet().getPath() + "/pipe/pipe_tiny"), new Texture(((PipeType)type).getMaterial().getSet().getDomain(), ((PipeType)type).getMaterial().getSet().getPath() + "/pipe/pipe_small"), new Texture(((PipeType)type).getMaterial().getSet().getDomain(), ((PipeType)type).getMaterial().getSet().getPath() + "/pipe/pipe_normal"), new Texture(((PipeType)type).getMaterial().getSet().getDomain(), ((PipeType)type).getMaterial().getSet().getPath() + "/pipe/pipe_large"), new Texture(((PipeType)type).getMaterial().getSet().getDomain(), ((PipeType)type).getMaterial().getSet().getPath() + "/pipe/pipe_huge")};
        AntimatterAPI.register(BlockPipe.class, this);
        this.m_49959_((BlockState)((BlockState)((BlockState)this.m_49965_().m_61090_()).m_61124_((Property)BlockStateProperties.f_61362_, (Comparable)Boolean.valueOf(false))).m_61124_((Property)TICKING, (Comparable)Boolean.valueOf(false)));
        this.modelId = modelId;
        this.buildShapes();
    }

    private void buildShapes() {
        this.recursiveShapeBuild(0, (byte)0);
        this.shapes.put(this.getPipeID(0, 0), (Object)Shapes.m_83064_((AABB)this.size.getAABB()));
    }

    public void m_6810_(BlockState state, Level worldIn, BlockPos pos, BlockState newState, boolean isMoving) {
        if (state.m_155947_() && state.m_60713_(newState.m_60734_()) && state.equals(newState.m_61124_((Property)TICKING, (Comparable)Boolean.valueOf((Boolean)newState.m_61143_((Property)TICKING) == false)))) {
            worldIn.m_46747_(pos);
        } else if (!state.m_60713_(newState.m_60734_())) {
            BlockEntity tile = worldIn.m_7702_(pos);
            if (tile == null) {
                return;
            }
            TileEntityPipe pipe = (TileEntityPipe)tile;
            pipe.coverHandler.ifPresent(t -> t.getDrops().forEach(stack -> Containers.m_18992_((Level)worldIn, (double)pipe.m_58899_().m_123341_(), (double)pipe.m_58899_().m_123342_(), (double)pipe.m_58899_().m_123343_(), (ItemStack)stack)));
            super.m_6810_(state, worldIn, pos, newState, isMoving);
        }
    }

    private void recursiveShapeBuild(int index, byte acc) {
        if (index > 5) {
            this.shapes.put(this.getPipeID(acc, 0), (Object)this.makeShapes(acc));
            return;
        }
        this.recursiveShapeBuild(index + 1, (byte)(acc | 1 << index));
        this.recursiveShapeBuild(index + 1, acc);
    }

    private VoxelShape makeShapes(byte which) {
        float offset = 0.0625f * (float)this.size.ordinal();
        VoxelShape shape = Shapes.m_83064_((AABB)this.size.getAABB());
        if ((which & 1) > 0) {
            shape = Shapes.m_83110_((VoxelShape)shape, (VoxelShape)Shapes.m_83048_((double)(0.4375 - (double)offset), (double)0.0, (double)(0.4375 - (double)offset), (double)(0.5625 + (double)offset), (double)(0.4375 - (double)offset), (double)(0.5625 + (double)offset)));
        }
        if ((which & 2) > 0) {
            shape = Shapes.m_83110_((VoxelShape)shape, (VoxelShape)Shapes.m_83048_((double)(0.4375 - (double)offset), (double)(0.5625 + (double)offset), (double)(0.4375 - (double)offset), (double)(0.5625 + (double)offset), (double)1.0, (double)(0.5625 + (double)offset)));
        }
        if ((which & 4) > 0) {
            shape = Shapes.m_83110_((VoxelShape)shape, (VoxelShape)Shapes.m_83048_((double)(0.4375 - (double)offset), (double)(0.4375 - (double)offset), (double)0.0, (double)(0.5625 + (double)offset), (double)(0.5625 + (double)offset), (double)(0.4375 - (double)offset)));
        }
        if ((which & 8) > 0) {
            shape = Shapes.m_83110_((VoxelShape)shape, (VoxelShape)Shapes.m_83048_((double)(0.4375 - (double)offset), (double)(0.4375 - (double)offset), (double)(0.5625 + (double)offset), (double)(0.5625 + (double)offset), (double)(0.5625 + (double)offset), (double)1.0));
        }
        if ((which & 0x10) > 0) {
            shape = Shapes.m_83110_((VoxelShape)shape, (VoxelShape)Shapes.m_83048_((double)0.0, (double)(0.4375 - (double)offset), (double)(0.4375 - (double)offset), (double)(0.4375 - (double)offset), (double)(0.5625 + (double)offset), (double)(0.5625 + (double)offset)));
        }
        if ((which & 0x20) > 0) {
            shape = Shapes.m_83110_((VoxelShape)shape, (VoxelShape)Shapes.m_83048_((double)(0.5625 + (double)offset), (double)(0.4375 - (double)offset), (double)(0.4375 - (double)offset), (double)1.0, (double)(0.5625 + (double)offset), (double)(0.5625 + (double)offset)));
        }
        return shape;
    }

    public T getType() {
        return this.type;
    }

    public PipeSize getSize() {
        return this.size;
    }

    public int getRGB() {
        return ((PipeType)this.type).getMaterial().getRGB();
    }

    public int getModelId() {
        return this.modelId;
    }

    public Texture getSide() {
        return this.side;
    }

    public Texture getFace() {
        return this.faces[this.size.ordinal()];
    }

    @Override
    public AntimatterItemBlock getItemBlock() {
        return new PipeItemBlock(this);
    }

    public AntimatterToolType getToolType() {
        return AntimatterDefaultTools.WRENCH;
    }

    public void m_6402_(Level worldIn, BlockPos pos, BlockState state, @Nullable LivingEntity placer, ItemStack stack) {
        TileEntityPipe<?> tile = BlockPipe.getTilePipe((BlockGetter)worldIn, pos);
        if (tile != null) {
            for (Direction side : Ref.DIRS) {
                TileEntityPipe<?> neighbour = tile.getPipe(side);
                if (neighbour == null || !neighbour.connects(side.m_122424_())) continue;
                tile.setConnection(side);
            }
        }
    }

    public boolean onBlockPlacedTo(Level world, BlockPos pos, Direction face) {
        TileEntityPipe<?> tile = BlockPipe.getTilePipe((BlockGetter)world, pos);
        if (tile != null) {
            if (!world.m_8055_(pos.m_142300_(face.m_122424_())).m_155947_()) {
                return false;
            }
            tile.setConnection(face.m_122424_());
            return true;
        }
        return false;
    }

    public void m_6861_(BlockState state, Level worldIn, BlockPos pos, Block blockIn, BlockPos fromPos, boolean isMoving) {
        TileEntityPipe tile;
        super.m_6861_(state, worldIn, pos, blockIn, fromPos, isMoving);
        if (!worldIn.f_46443_ && (tile = (TileEntityPipe)worldIn.m_7702_(pos)) != null) {
            tile.onBlockUpdate(fromPos);
        }
    }

    public void onNeighborChange(BlockState state, LevelReader world, BlockPos pos, BlockPos neighbor) {
        TileEntityPipe tile;
        if (!world.m_5776_() && (tile = (TileEntityPipe)world.m_7702_(pos)) != null) {
            tile.onBlockUpdate(neighbor);
        }
    }

    public BlockState m_7417_(BlockState stateIn, Direction facing, BlockState facingState, LevelAccessor worldIn, BlockPos currentPos, BlockPos facingPos) {
        this.onNeighborChange(stateIn, (LevelReader)worldIn, currentPos, facingPos);
        return stateIn;
    }

    @Nonnull
    public InteractionResult m_6227_(BlockState state, Level world, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        TileEntityPipe tile = (TileEntityPipe)world.m_7702_(pos);
        if (tile == null) {
            return InteractionResult.PASS;
        }
        if (!world.f_46443_ && hand == InteractionHand.MAIN_HAND) {
            AntimatterToolType type;
            ItemStack stack = player.m_21120_(hand);
            if (stack.m_41720_() instanceof IHaveCover) {
                CoverFactory factory = ((IHaveCover)stack.m_41720_()).getCover();
                Direction dir = Utils.getInteractSide(hit);
                boolean ok = AntimatterCapUtils.getCoverHandler(tile, Utils.getInteractSide(hit)).map(i -> i.placeCover(player, Utils.getInteractSide(hit), stack, factory.get().get((ICoverHandler<?>)i, ((IHaveCover)stack.m_41720_()).getTier(), dir, factory))).orElse(false);
                if (ok) {
                    return InteractionResult.SUCCESS;
                }
            }
            if ((type = Utils.getToolType(player)) == null) {
                return InteractionResult.PASS;
            }
            if (type == AntimatterDefaultTools.CROWBAR) {
                if (!player.m_6047_()) {
                    if (AntimatterCapUtils.getCoverHandler(tile, hit.m_82434_()).map(h -> h.removeCover(player, Utils.getInteractSide(hit), false)).orElse(false).booleanValue()) {
                        Utils.damageStack(stack, hand, (LivingEntity)player);
                        return InteractionResult.SUCCESS;
                    }
                    return InteractionResult.PASS;
                }
                if (AntimatterCapUtils.getCoverHandler(tile, hit.m_82434_()).map(h -> h.moveCover(player, hit.m_82434_(), Utils.getInteractSide(hit))).orElse(false).booleanValue()) {
                    Utils.damageStack(stack, (LivingEntity)player);
                    return InteractionResult.SUCCESS;
                }
                return InteractionResult.PASS;
            }
            if (type == AntimatterDefaultTools.SCREWDRIVER || type == AntimatterDefaultTools.ELECTRIC_SCREWDRIVER) {
                if (player.m_6047_()) {
                    AntimatterPlatformUtils.openGui((ServerPlayer)player, tile, extra -> extra.m_130064_(pos));
                    Utils.damageStack(stack, hand, (LivingEntity)player);
                    return InteractionResult.SUCCESS;
                }
                ICover instance = AntimatterCapUtils.getCoverHandler(tile, hit.m_82434_()).map(h -> h.get(Utils.getInteractSide(hit))).orElse(ICover.empty);
                if (!player.m_6047_()) {
                    if (!instance.isEmpty() && instance.openGui(player, Utils.getInteractSide(hit))) {
                        Utils.damageStack(stack, hand, (LivingEntity)player);
                        return InteractionResult.SUCCESS;
                    }
                    return InteractionResult.PASS;
                }
            }
            if (this.getToolType().equals(type)) {
                Direction side = Utils.getInteractSide(hit);
                if (tile.blocksSide(side)) {
                    return InteractionResult.CONSUME;
                }
                tile.toggleConnection(side);
                Utils.damageStack(stack, hand, (LivingEntity)player);
                return InteractionResult.SUCCESS;
            }
        }
        return InteractionResult.PASS;
    }

    @Override
    public VoxelShape m_5940_(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        int config;
        VoxelShape shape;
        EntityCollisionContext cont;
        Entity entity;
        if (context instanceof EntityCollisionContext && (entity = (cont = (EntityCollisionContext)context).m_193113_()) instanceof Player) {
            Player player = (Player)entity;
            if (Utils.isPlayerHolding(player, InteractionHand.MAIN_HAND, this.getToolType(), AntimatterDefaultTools.CROWBAR, AntimatterDefaultTools.SCREWDRIVER)) {
                return Shapes.m_83144_();
            }
            if (!player.m_21205_().m_41619_() && player.m_21205_().m_41720_() instanceof IHaveCover) {
                return Shapes.m_83144_();
            }
            BlockPipe<?> pipe = null;
            if (player.m_21205_().m_41720_() instanceof PipeItemBlock) {
                pipe = ((PipeItemBlock)player.m_21205_().m_41720_()).getPipe();
            }
            if (player.m_21206_().m_41720_() instanceof PipeItemBlock) {
                pipe = ((PipeItemBlock)player.m_21206_().m_41720_()).getPipe();
            }
            if (this.getClass().isInstance(pipe)) {
                return Shapes.m_83144_();
            }
        }
        return (shape = (VoxelShape)this.shapes.get(config = this.getConfig(state, world, new BlockPos.MutableBlockPos(pos.m_123341_(), pos.m_123342_(), pos.m_123343_()), pos).getConfig()[0])) != null ? shape : Shapes.m_83144_();
    }

    public int getPipeID(int config, int cull) {
        return (this.size.ordinal() + 1) * 100 + (this.getModelId() + 1) * 1000 + (cull == 0 ? 0 : 10000) + config;
    }

    @Nullable
    private static TileEntityPipe<?> getTilePipe(BlockGetter world, BlockPos pos) {
        BlockEntity tile = world.m_7702_(pos);
        return tile instanceof TileEntityPipe ? (TileEntityPipe)tile : null;
    }

    @Override
    public ModelConfig getConfig(BlockState state, BlockGetter world, BlockPos.MutableBlockPos mut, BlockPos pos) {
        int ct = 0;
        TileEntityPipe<?> tile = BlockPipe.getTilePipe(world, pos);
        if (tile != null) {
            for (int s = 0; s < 6; ++s) {
                if (!tile.canConnect(s)) continue;
                ct += 1 << s;
            }
        }
        return this.config.set(pos, new int[]{this.getPipeID(ct, 0)});
    }

    @Override
    public int getBlockColor(BlockState state, @Nullable BlockGetter world, @Nullable BlockPos pos, int i) {
        return this.getRGB();
    }

    @Override
    public int getItemColor(ItemStack stack, @Nullable Block block, int i) {
        return this.getRGB();
    }

    @Override
    public void onItemModelBuild(ItemLike item, AntimatterItemModelProvider prov) {
        ((AntimatterItemModelBuilder)((AntimatterItemModelBuilder)prov.getBuilder(item).parent(prov.existing("antimatter", "block/pipe/" + this.getSize().getId() + "/line_inv"))).texture("all", this.getSide())).texture("overlay", this.getFace());
    }

    @Override
    public void onBlockModelBuild(Block block, AntimatterBlockStateProvider prov) {
        prov.getVariantBuilder(block).forAllStates(s -> new VariantBlockStateBuilder.VariantBuilder().modelFile(this.getPipeConfig(prov.getBuilder(block))).uvLock());
    }

    public String getModelLoc(String shape, int cull) {
        return "antimatter:block/pipe/" + this.getSize().getId() + "/" + shape + (cull == 0 ? "" : (shape.equals("base") ? "" : "_culled"));
    }

    public AntimatterBlockModelBuilder getPipeConfig(AntimatterBlockModelBuilder builder) {
        builder.model(this.getModelLoc("base", 0), (ImmutableMap<String, Texture>)ImmutableMap.of((Object)"all", (Object)((Object)this.getSide()), (Object)"overlay", (Object)((Object)this.getFace())));
        builder.staticConfigId("pipe");
        builder.particle(this.getFace());
        builder.config(this.getPipeID(0, 0), this.getModelLoc("base", 0), c -> c.tex((ImmutableMap<String, Texture>)ImmutableMap.of((Object)"all", (Object)((Object)this.getSide()), (Object)"overlay", (Object)((Object)this.getFace()))));
        builder.config(this.getPipeID(1, 0), this.getModelLoc("single", 0), c -> c.tex((ImmutableMap<String, Texture>)ImmutableMap.of((Object)"all", (Object)((Object)this.getSide()), (Object)"overlay", (Object)((Object)this.getFace()))).rot(-90, 0, 0));
        builder.config(this.getPipeID(2, 0), this.getModelLoc("single", 0), c -> c.tex((ImmutableMap<String, Texture>)ImmutableMap.of((Object)"all", (Object)((Object)this.getSide()), (Object)"overlay", (Object)((Object)this.getFace()))).rot(90, 0, 0));
        builder.config(this.getPipeID(4, 0), this.getModelLoc("single", 0), c -> c.tex((ImmutableMap<String, Texture>)ImmutableMap.of((Object)"all", (Object)((Object)this.getSide()), (Object)"overlay", (Object)((Object)this.getFace()))));
        builder.config(this.getPipeID(8, 0), this.getModelLoc("single", 0), c -> c.tex((ImmutableMap<String, Texture>)ImmutableMap.of((Object)"all", (Object)((Object)this.getSide()), (Object)"overlay", (Object)((Object)this.getFace()))).rot(0, 180, 0));
        builder.config(this.getPipeID(16, 0), this.getModelLoc("single", 0), c -> c.tex((ImmutableMap<String, Texture>)ImmutableMap.of((Object)"all", (Object)((Object)this.getSide()), (Object)"overlay", (Object)((Object)this.getFace()))).rot(0, 90, 0));
        builder.config(this.getPipeID(32, 0), this.getModelLoc("single", 0), c -> c.tex((ImmutableMap<String, Texture>)ImmutableMap.of((Object)"all", (Object)((Object)this.getSide()), (Object)"overlay", (Object)((Object)this.getFace()))).rot(0, -90, 0));
        builder.config(this.getPipeID(3, 0), this.getModelLoc("line", 0), c -> c.tex((ImmutableMap<String, Texture>)ImmutableMap.of((Object)"all", (Object)((Object)this.getSide()), (Object)"overlay", (Object)((Object)this.getFace()))).rot(90, 0, 0));
        builder.config(this.getPipeID(12, 0), this.getModelLoc("line", 0), c -> c.tex((ImmutableMap<String, Texture>)ImmutableMap.of((Object)"all", (Object)((Object)this.getSide()), (Object)"overlay", (Object)((Object)this.getFace()))));
        builder.config(this.getPipeID(48, 0), this.getModelLoc("line", 0), c -> c.tex((ImmutableMap<String, Texture>)ImmutableMap.of((Object)"all", (Object)((Object)this.getSide()), (Object)"overlay", (Object)((Object)this.getFace()))).rot(0, 90, 0));
        builder.config(this.getPipeID(5, 0), this.getModelLoc("elbow", 0), c -> c.tex((ImmutableMap<String, Texture>)ImmutableMap.of((Object)"all", (Object)((Object)this.getSide()), (Object)"overlay", (Object)((Object)this.getFace()))).rot(0, 0, -90));
        builder.config(this.getPipeID(6, 0), this.getModelLoc("elbow", 0), c -> c.tex((ImmutableMap<String, Texture>)ImmutableMap.of((Object)"all", (Object)((Object)this.getSide()), (Object)"overlay", (Object)((Object)this.getFace()))).rot(0, 0, 90));
        builder.config(this.getPipeID(9, 0), this.getModelLoc("elbow", 0), c -> c.tex((ImmutableMap<String, Texture>)ImmutableMap.of((Object)"all", (Object)((Object)this.getSide()), (Object)"overlay", (Object)((Object)this.getFace()))).rot(0, 180, -90));
        builder.config(this.getPipeID(10, 0), this.getModelLoc("elbow", 0), c -> c.tex((ImmutableMap<String, Texture>)ImmutableMap.of((Object)"all", (Object)((Object)this.getSide()), (Object)"overlay", (Object)((Object)this.getFace()))).rot(0, 180, 90));
        builder.config(this.getPipeID(17, 0), this.getModelLoc("elbow", 0), c -> c.tex((ImmutableMap<String, Texture>)ImmutableMap.of((Object)"all", (Object)((Object)this.getSide()), (Object)"overlay", (Object)((Object)this.getFace()))).rot(90, 180, 0));
        builder.config(this.getPipeID(18, 0), this.getModelLoc("elbow", 0), c -> c.tex((ImmutableMap<String, Texture>)ImmutableMap.of((Object)"all", (Object)((Object)this.getSide()), (Object)"overlay", (Object)((Object)this.getFace()))).rot(-90, 180, 0));
        builder.config(this.getPipeID(20, 0), this.getModelLoc("elbow", 0), c -> c.tex((ImmutableMap<String, Texture>)ImmutableMap.of((Object)"all", (Object)((Object)this.getSide()), (Object)"overlay", (Object)((Object)this.getFace()))).rot(0, 90, 0));
        builder.config(this.getPipeID(24, 0), this.getModelLoc("elbow", 0), c -> c.tex((ImmutableMap<String, Texture>)ImmutableMap.of((Object)"all", (Object)((Object)this.getSide()), (Object)"overlay", (Object)((Object)this.getFace()))).rot(0, -180, 0));
        builder.config(this.getPipeID(33, 0), this.getModelLoc("elbow", 0), c -> c.tex((ImmutableMap<String, Texture>)ImmutableMap.of((Object)"all", (Object)((Object)this.getSide()), (Object)"overlay", (Object)((Object)this.getFace()))).rot(-90, 0, 0));
        builder.config(this.getPipeID(34, 0), this.getModelLoc("elbow", 0), c -> c.tex((ImmutableMap<String, Texture>)ImmutableMap.of((Object)"all", (Object)((Object)this.getSide()), (Object)"overlay", (Object)((Object)this.getFace()))).rot(90, 0, 0));
        builder.config(this.getPipeID(36, 0), this.getModelLoc("elbow", 0), c -> c.tex((ImmutableMap<String, Texture>)ImmutableMap.of((Object)"all", (Object)((Object)this.getSide()), (Object)"overlay", (Object)((Object)this.getFace()))));
        builder.config(this.getPipeID(40, 0), this.getModelLoc("elbow", 0), c -> c.tex((ImmutableMap<String, Texture>)ImmutableMap.of((Object)"all", (Object)((Object)this.getSide()), (Object)"overlay", (Object)((Object)this.getFace()))).rot(0, -90, 0));
        builder.config(this.getPipeID(7, 0), this.getModelLoc("side", 0), c -> c.tex((ImmutableMap<String, Texture>)ImmutableMap.of((Object)"all", (Object)((Object)this.getSide()), (Object)"overlay", (Object)((Object)this.getFace()))).rot(-90, 0, 0));
        builder.config(this.getPipeID(11, 0), this.getModelLoc("side", 0), c -> c.tex((ImmutableMap<String, Texture>)ImmutableMap.of((Object)"all", (Object)((Object)this.getSide()), (Object)"overlay", (Object)((Object)this.getFace()))).rot(90, 0, 0));
        builder.config(this.getPipeID(13, 0), this.getModelLoc("side", 0), c -> c.tex((ImmutableMap<String, Texture>)ImmutableMap.of((Object)"all", (Object)((Object)this.getSide()), (Object)"overlay", (Object)((Object)this.getFace()))).rot(0, 0, 180));
        builder.config(this.getPipeID(14, 0), this.getModelLoc("side", 0), c -> c.tex((ImmutableMap<String, Texture>)ImmutableMap.of((Object)"all", (Object)((Object)this.getSide()), (Object)"overlay", (Object)((Object)this.getFace()))));
        builder.config(this.getPipeID(19, 0), this.getModelLoc("side", 0), c -> c.tex((ImmutableMap<String, Texture>)ImmutableMap.of((Object)"all", (Object)((Object)this.getSide()), (Object)"overlay", (Object)((Object)this.getFace()))).rot(90, 0, 90));
        builder.config(this.getPipeID(28, 0), this.getModelLoc("side", 0), c -> c.tex((ImmutableMap<String, Texture>)ImmutableMap.of((Object)"all", (Object)((Object)this.getSide()), (Object)"overlay", (Object)((Object)this.getFace()))).rot(0, 0, 90));
        builder.config(this.getPipeID(35, 0), this.getModelLoc("side", 0), c -> c.tex((ImmutableMap<String, Texture>)ImmutableMap.of((Object)"all", (Object)((Object)this.getSide()), (Object)"overlay", (Object)((Object)this.getFace()))).rot(90, 0, -90));
        builder.config(this.getPipeID(44, 0), this.getModelLoc("side", 0), c -> c.tex((ImmutableMap<String, Texture>)ImmutableMap.of((Object)"all", (Object)((Object)this.getSide()), (Object)"overlay", (Object)((Object)this.getFace()))).rot(0, 0, -90));
        builder.config(this.getPipeID(49, 0), this.getModelLoc("side", 0), c -> c.tex((ImmutableMap<String, Texture>)ImmutableMap.of((Object)"all", (Object)((Object)this.getSide()), (Object)"overlay", (Object)((Object)this.getFace()))).rot(0, 90, 180));
        builder.config(this.getPipeID(50, 0), this.getModelLoc("side", 0), c -> c.tex((ImmutableMap<String, Texture>)ImmutableMap.of((Object)"all", (Object)((Object)this.getSide()), (Object)"overlay", (Object)((Object)this.getFace()))).rot(0, 90, 0));
        builder.config(this.getPipeID(52, 0), this.getModelLoc("side", 0), c -> c.tex((ImmutableMap<String, Texture>)ImmutableMap.of((Object)"all", (Object)((Object)this.getSide()), (Object)"overlay", (Object)((Object)this.getFace()))).rot(0, 90, -90));
        builder.config(this.getPipeID(56, 0), this.getModelLoc("side", 0), c -> c.tex((ImmutableMap<String, Texture>)ImmutableMap.of((Object)"all", (Object)((Object)this.getSide()), (Object)"overlay", (Object)((Object)this.getFace()))).rot(0, 90, 90));
        builder.config(this.getPipeID(21, 0), this.getModelLoc("corner", 0), c -> c.tex((ImmutableMap<String, Texture>)ImmutableMap.of((Object)"all", (Object)((Object)this.getSide()), (Object)"overlay", (Object)((Object)this.getFace()))).rot(0, 0, 180));
        builder.config(this.getPipeID(22, 0), this.getModelLoc("corner", 0), c -> c.tex((ImmutableMap<String, Texture>)ImmutableMap.of((Object)"all", (Object)((Object)this.getSide()), (Object)"overlay", (Object)((Object)this.getFace()))).rot(0, 90, 0));
        builder.config(this.getPipeID(25, 0), this.getModelLoc("corner", 0), c -> c.tex((ImmutableMap<String, Texture>)ImmutableMap.of((Object)"all", (Object)((Object)this.getSide()), (Object)"overlay", (Object)((Object)this.getFace()))).rot(0, -270, 180));
        builder.config(this.getPipeID(26, 0), this.getModelLoc("corner", 0), c -> c.tex((ImmutableMap<String, Texture>)ImmutableMap.of((Object)"all", (Object)((Object)this.getSide()), (Object)"overlay", (Object)((Object)this.getFace()))).rot(0, 180, 0));
        builder.config(this.getPipeID(41, 0), this.getModelLoc("corner", 0), c -> c.tex((ImmutableMap<String, Texture>)ImmutableMap.of((Object)"all", (Object)((Object)this.getSide()), (Object)"overlay", (Object)((Object)this.getFace()))).rot(0, -180, 180));
        builder.config(this.getPipeID(42, 0), this.getModelLoc("corner", 0), c -> c.tex((ImmutableMap<String, Texture>)ImmutableMap.of((Object)"all", (Object)((Object)this.getSide()), (Object)"overlay", (Object)((Object)this.getFace()))).rot(0, -90, 0));
        builder.config(this.getPipeID(37, 0), this.getModelLoc("corner", 0), c -> c.tex((ImmutableMap<String, Texture>)ImmutableMap.of((Object)"all", (Object)((Object)this.getSide()), (Object)"overlay", (Object)((Object)this.getFace()))).rot(0, -90, 180));
        builder.config(this.getPipeID(38, 0), this.getModelLoc("corner", 0), c -> c.tex((ImmutableMap<String, Texture>)ImmutableMap.of((Object)"all", (Object)((Object)this.getSide()), (Object)"overlay", (Object)((Object)this.getFace()))));
        builder.config(this.getPipeID(23, 0), this.getModelLoc("arrow", 0), c -> c.tex((ImmutableMap<String, Texture>)ImmutableMap.of((Object)"all", (Object)((Object)this.getSide()), (Object)"overlay", (Object)((Object)this.getFace()))).rot(0, 0, 90));
        builder.config(this.getPipeID(27, 0), this.getModelLoc("arrow", 0), c -> c.tex((ImmutableMap<String, Texture>)ImmutableMap.of((Object)"all", (Object)((Object)this.getSide()), (Object)"overlay", (Object)((Object)this.getFace()))).rot(0, -270, 90));
        builder.config(this.getPipeID(29, 0), this.getModelLoc("arrow", 0), c -> c.tex((ImmutableMap<String, Texture>)ImmutableMap.of((Object)"all", (Object)((Object)this.getSide()), (Object)"overlay", (Object)((Object)this.getFace()))).rot(0, 90, 180));
        builder.config(this.getPipeID(30, 0), this.getModelLoc("arrow", 0), c -> c.tex((ImmutableMap<String, Texture>)ImmutableMap.of((Object)"all", (Object)((Object)this.getSide()), (Object)"overlay", (Object)((Object)this.getFace()))).rot(0, 90, 0));
        builder.config(this.getPipeID(39, 0), this.getModelLoc("arrow", 0), c -> c.tex((ImmutableMap<String, Texture>)ImmutableMap.of((Object)"all", (Object)((Object)this.getSide()), (Object)"overlay", (Object)((Object)this.getFace()))).rot(0, -90, 90));
        builder.config(this.getPipeID(43, 0), this.getModelLoc("arrow", 0), c -> c.tex((ImmutableMap<String, Texture>)ImmutableMap.of((Object)"all", (Object)((Object)this.getSide()), (Object)"overlay", (Object)((Object)this.getFace()))).rot(0, -180, 90));
        builder.config(this.getPipeID(45, 0), this.getModelLoc("arrow", 0), c -> c.tex((ImmutableMap<String, Texture>)ImmutableMap.of((Object)"all", (Object)((Object)this.getSide()), (Object)"overlay", (Object)((Object)this.getFace()))).rot(0, -90, 180));
        builder.config(this.getPipeID(46, 0), this.getModelLoc("arrow", 0), c -> c.tex((ImmutableMap<String, Texture>)ImmutableMap.of((Object)"all", (Object)((Object)this.getSide()), (Object)"overlay", (Object)((Object)this.getFace()))).rot(0, -90, 0));
        builder.config(this.getPipeID(53, 0), this.getModelLoc("arrow", 0), c -> c.tex((ImmutableMap<String, Texture>)ImmutableMap.of((Object)"all", (Object)((Object)this.getSide()), (Object)"overlay", (Object)((Object)this.getFace()))).rot(180, 180, 0));
        builder.config(this.getPipeID(54, 0), this.getModelLoc("arrow", 0), c -> c.tex((ImmutableMap<String, Texture>)ImmutableMap.of((Object)"all", (Object)((Object)this.getSide()), (Object)"overlay", (Object)((Object)this.getFace()))));
        builder.config(this.getPipeID(57, 0), this.getModelLoc("arrow", 0), c -> c.tex((ImmutableMap<String, Texture>)ImmutableMap.of((Object)"all", (Object)((Object)this.getSide()), (Object)"overlay", (Object)((Object)this.getFace()))).rot(180, 0, 0));
        builder.config(this.getPipeID(58, 0), this.getModelLoc("arrow", 0), c -> c.tex((ImmutableMap<String, Texture>)ImmutableMap.of((Object)"all", (Object)((Object)this.getSide()), (Object)"overlay", (Object)((Object)this.getFace()))).rot(0, 180, 0));
        builder.config(this.getPipeID(15, 0), this.getModelLoc("cross", 0), c -> c.tex((ImmutableMap<String, Texture>)ImmutableMap.of((Object)"all", (Object)((Object)this.getSide()), (Object)"overlay", (Object)((Object)this.getFace()))).rot(0, 0, 90));
        builder.config(this.getPipeID(51, 0), this.getModelLoc("cross", 0), c -> c.tex((ImmutableMap<String, Texture>)ImmutableMap.of((Object)"all", (Object)((Object)this.getSide()), (Object)"overlay", (Object)((Object)this.getFace()))).rot(90, 0, 0));
        builder.config(this.getPipeID(60, 0), this.getModelLoc("cross", 0), c -> c.tex((ImmutableMap<String, Texture>)ImmutableMap.of((Object)"all", (Object)((Object)this.getSide()), (Object)"overlay", (Object)((Object)this.getFace()))));
        builder.config(this.getPipeID(31, 0), this.getModelLoc("five", 0), c -> c.tex((ImmutableMap<String, Texture>)ImmutableMap.of((Object)"all", (Object)((Object)this.getSide()), (Object)"overlay", (Object)((Object)this.getFace()))).rot(0, 0, 90));
        builder.config(this.getPipeID(47, 0), this.getModelLoc("five", 0), c -> c.tex((ImmutableMap<String, Texture>)ImmutableMap.of((Object)"all", (Object)((Object)this.getSide()), (Object)"overlay", (Object)((Object)this.getFace()))).rot(0, 0, -90));
        builder.config(this.getPipeID(55, 0), this.getModelLoc("five", 0), c -> c.tex((ImmutableMap<String, Texture>)ImmutableMap.of((Object)"all", (Object)((Object)this.getSide()), (Object)"overlay", (Object)((Object)this.getFace()))).rot(-90, 0, 0));
        builder.config(this.getPipeID(59, 0), this.getModelLoc("five", 0), c -> c.tex((ImmutableMap<String, Texture>)ImmutableMap.of((Object)"all", (Object)((Object)this.getSide()), (Object)"overlay", (Object)((Object)this.getFace()))).rot(90, 0, 0));
        builder.config(this.getPipeID(61, 0), this.getModelLoc("five", 0), c -> c.tex((ImmutableMap<String, Texture>)ImmutableMap.of((Object)"all", (Object)((Object)this.getSide()), (Object)"overlay", (Object)((Object)this.getFace()))).rot(180, 0, 0));
        builder.config(this.getPipeID(62, 0), this.getModelLoc("five", 0), c -> c.tex((ImmutableMap<String, Texture>)ImmutableMap.of((Object)"all", (Object)((Object)this.getSide()), (Object)"overlay", (Object)((Object)this.getFace()))));
        builder.config(this.getPipeID(63, 0), this.getModelLoc("all", 0), c -> c.tex((ImmutableMap<String, Texture>)ImmutableMap.of((Object)"all", (Object)((Object)this.getSide()), (Object)"overlay", (Object)((Object)this.getFace()))));
        return (AntimatterBlockModelBuilder)builder.loader(AntimatterModelManager.LOADER_PIPE);
    }

    @Override
    public List<String> getInfo(List<String> info, Level world, BlockState state, BlockPos pos) {
        super.getInfo(info, world, state, pos);
        info.add("Pipe Type: " + ((PipeType)this.getType()).getId());
        info.add("Pipe Material: " + ((PipeType)this.getType()).getMaterial().getId());
        info.add("Pipe Size: " + this.getSize().getId());
        return info;
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{BlockStateProperties.f_61362_});
        builder.m_61104_(new Property[]{TICKING});
    }

    public FluidState m_5888_(BlockState state) {
        return (Boolean)state.m_61143_((Property)BlockStateProperties.f_61362_) != false ? Fluids.f_76193_.m_76068_(false) : super.m_5888_(state);
    }

    public BlockState m_5573_(BlockPlaceContext context) {
        FluidState fluidstate = context.m_43725_().m_6425_(context.m_8083_());
        return (BlockState)super.m_49966_().m_61124_((Property)BlockStateProperties.f_61362_, (Comparable)Boolean.valueOf(fluidstate.m_76152_() == Fluids.f_76193_));
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return ((PipeType)this.type).getTileType().m_155264_(pos, state);
    }

    @Nullable
    public <TILE extends BlockEntity> BlockEntityTicker<TILE> m_142354_(Level level, BlockState state, BlockEntityType<TILE> type) {
        if (((Boolean)state.m_61143_((Property)TICKING)).booleanValue() && !level.m_5776_()) {
            return TileEntityTickable::commonTick;
        }
        return null;
    }
}

