/*
 * Decompiled with CFR 0.152.
 */
package muramasa.antimatter.pipe;

import java.util.List;
import javax.annotation.Nullable;
import muramasa.antimatter.pipe.BlockPipe;
import muramasa.antimatter.pipe.PipeSize;
import muramasa.antimatter.pipe.types.FluidPipe;
import muramasa.antimatter.pipe.types.PipeType;
import muramasa.antimatter.tile.pipe.TileEntityFluidPipe;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import tesseract.FluidPlatformUtils;
import tesseract.TesseractGraphWrappers;
import tesseract.api.ITickingController;
import tesseract.api.fluid.FluidHolder;

public class BlockFluidPipe<T extends FluidPipe<T>>
extends BlockPipe<T> {
    public BlockFluidPipe(T type, PipeSize size) {
        super(((PipeType)type).getId(), type, size, 0);
    }

    @Override
    public List<String> getInfo(List<String> info, Level world, BlockState state, BlockPos pos) {
        if (world.f_46443_) {
            return info;
        }
        ITickingController controller = TesseractGraphWrappers.FLUID.getController(world, pos.m_121878_());
        controller.getInfo(pos.m_121878_(), info);
        info.add("Pressure: " + ((FluidPipe)this.getType()).getPressure(this.getSize()));
        info.add("Capacity: " + ((FluidPipe)this.getType()).getCapacity(this.getSize()));
        info.add("Max temperature: " + ((FluidPipe)this.getType()).getTemperature());
        info.add(((FluidPipe)this.getType()).isGasProof() ? "Gas proof." : "Cannot handle gas.");
        return info;
    }

    public void m_5871_(ItemStack stack, @Nullable BlockGetter worldIn, List<Component> tooltip, TooltipFlag flagIn) {
        super.m_5871_(stack, worldIn, tooltip, flagIn);
        tooltip.add((Component)new TranslatableComponent("antimatter.tooltip.pressure").m_130946_(": " + ((FluidPipe)this.getType()).getPressure(this.getSize())));
        tooltip.add((Component)new TranslatableComponent("antimatter.tooltip.capacity").m_130946_(": " + ((FluidPipe)this.getType()).getCapacity(this.getSize())));
        tooltip.add((Component)new TranslatableComponent("antimatter.tooltip.max_temperature").m_130946_(": " + ((FluidPipe)this.getType()).getTemperature()));
        if (!Screen.m_96638_()) {
            tooltip.add((Component)new TranslatableComponent("antimatter.tooltip.more").m_130940_(ChatFormatting.DARK_AQUA));
        } else {
            tooltip.add((Component)new TextComponent("----------"));
            tooltip.add((Component)new TranslatableComponent("antimatter.pipe.fluid.info").m_130940_(ChatFormatting.DARK_AQUA));
            tooltip.add((Component)new TextComponent("----------"));
        }
    }

    public void m_7892_(BlockState state, Level worldIn, BlockPos pos, Entity entityIn) {
        super.m_7892_(state, worldIn, pos, entityIn);
        if (!(entityIn instanceof LivingEntity)) {
            return;
        }
        TileEntityFluidPipe pipe = (TileEntityFluidPipe)worldIn.m_7702_(pos);
        FluidHolder holder = pipe.getHolder();
        if (holder == null) {
            return;
        }
        long max = 0L;
        for (FluidHolder.SetHolder fluid : holder.getFluids()) {
            max = Math.max(max, (long)FluidPlatformUtils.getFluidTemperature((Fluid)fluid.fluid));
        }
        if (max >= 395L) {
            entityIn.m_6469_(DamageSource.f_19309_, (float)Mth.m_14053_((long)((max + 200L - 395L) / 100L), (long)2L, (long)20L));
        }
    }
}

