/*
 * Decompiled with CFR 0.152.
 */
package muramasa.antimatter.pipe;

import java.util.List;
import javax.annotation.Nullable;
import muramasa.antimatter.data.AntimatterDefaultTools;
import muramasa.antimatter.pipe.BlockPipe;
import muramasa.antimatter.pipe.PipeSize;
import muramasa.antimatter.pipe.types.Cable;
import muramasa.antimatter.pipe.types.PipeType;
import muramasa.antimatter.texture.Texture;
import muramasa.antimatter.tile.pipe.TileEntityCable;
import muramasa.antimatter.tool.AntimatterToolType;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import tesseract.TesseractGraphWrappers;
import tesseract.api.ITickingController;
import tesseract.api.gt.GTController;

public class BlockCable<T extends Cable<T>>
extends BlockPipe<T> {
    public final boolean insulated;

    public BlockCable(T type, PipeSize size, boolean insulated) {
        super(((PipeType)type).getId(), type, size, 2);
        this.insulated = insulated;
        String prefix = insulated ? "cable" : "wire";
        this.side = new Texture("antimatter", "block/pipe/" + prefix + "_side");
        this.faces = new Texture[]{new Texture("antimatter", "block/pipe/" + prefix + "_vtiny"), new Texture("antimatter", "block/pipe/" + prefix + "_tiny"), new Texture("antimatter", "block/pipe/" + prefix + "_small"), new Texture("antimatter", "block/pipe/" + prefix + "_normal"), new Texture("antimatter", "block/pipe/" + prefix + "_large"), new Texture("antimatter", "block/pipe/" + prefix + "_huge")};
    }

    public int getFlammability(BlockState state, BlockGetter world, BlockPos pos, Direction face) {
        return 300;
    }

    public boolean isFlammable(BlockState state, BlockGetter world, BlockPos pos, Direction face) {
        return true;
    }

    @Override
    public AntimatterToolType getToolType() {
        return AntimatterDefaultTools.WIRE_CUTTER;
    }

    public boolean isFireSource(BlockState state, LevelReader world, BlockPos pos, Direction side) {
        return true;
    }

    @Override
    public int getBlockColor(BlockState state, @Nullable BlockGetter world, @Nullable BlockPos pos, int i) {
        if (!(state.m_60734_() instanceof BlockCable) && world == null || pos == null) {
            return -1;
        }
        return this.insulated ? (i == 1 ? this.getRGB() : -1) : (i == 0 || i == 1 ? this.getRGB() : -1);
    }

    @Override
    public int getItemColor(ItemStack stack, @Nullable Block block, int i) {
        return this.insulated ? (i == 1 ? this.getRGB() : -1) : this.getRGB();
    }

    public void m_7892_(BlockState state, Level worldIn, BlockPos pos, Entity entityIn) {
        super.m_7892_(state, worldIn, pos, entityIn);
        if (worldIn.f_46443_) {
            return;
        }
        if (this.insulated) {
            return;
        }
        if (entityIn instanceof LivingEntity) {
            LivingEntity entity = (LivingEntity)entityIn;
            BlockEntity blockEntity = worldIn.m_7702_(pos);
            if (blockEntity instanceof TileEntityCable) {
                TileEntityCable cable = (TileEntityCable)blockEntity;
                ITickingController iTickingController = TesseractGraphWrappers.GT_ENERGY.getController(worldIn, pos.m_121878_());
                if (iTickingController instanceof GTController) {
                    GTController c = (GTController)iTickingController;
                    if (c.cableIsActive.contains(pos.m_121878_())) {
                        entity.m_6469_(DamageSource.f_19318_, (float)((Cable)this.getType()).getTier().getIntegerId());
                    }
                }
            }
        }
    }

    @Override
    public List<String> getInfo(List<String> info, Level world, BlockState state, BlockPos pos) {
        if (world.f_46443_) {
            return info;
        }
        ITickingController controller = TesseractGraphWrappers.GT_ENERGY.getController(world, pos.m_121878_());
        if (controller != null) {
            controller.getInfo(pos.m_121878_(), info);
        }
        return info;
    }

    public void m_5871_(ItemStack stack, @Nullable BlockGetter worldIn, List<Component> tooltip, TooltipFlag flagIn) {
        super.m_5871_(stack, worldIn, tooltip, flagIn);
        tooltip.add((Component)new TranslatableComponent("generic.amp").m_130946_(": ").m_7220_((Component)new TextComponent("" + ((Cable)this.type).getAmps(this.size)).m_130940_(ChatFormatting.GREEN)));
        tooltip.add((Component)new TranslatableComponent("generic.voltage").m_130946_(": ").m_7220_((Component)new TextComponent("" + ((Cable)this.type).getTier().getVoltage()).m_130940_(ChatFormatting.BLUE)));
        tooltip.add((Component)new TranslatableComponent("generic.loss").m_130946_(": ").m_7220_((Component)new TextComponent("" + ((Cable)this.type).getLoss()).m_130940_(ChatFormatting.BLUE)));
        if (!Screen.m_96638_()) {
            tooltip.add((Component)new TranslatableComponent("antimatter.tooltip.more").m_130940_(ChatFormatting.DARK_AQUA));
        } else {
            tooltip.add((Component)new TextComponent("----------"));
            tooltip.add((Component)new TranslatableComponent("antimatter.pipe.cable.info").m_130940_(ChatFormatting.DARK_AQUA));
            tooltip.add((Component)new TextComponent("----------"));
        }
    }
}

