/*
 * Decompiled with CFR 0.152.
 */
package muramasa.antimatter.ore;

import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.function.Supplier;
import muramasa.antimatter.AntimatterAPI;
import muramasa.antimatter.block.BlockStone;
import muramasa.antimatter.material.Material;
import muramasa.antimatter.registration.IRegistryEntryProvider;
import muramasa.antimatter.registration.ISharedAntimatterObject;
import muramasa.antimatter.registration.RegistryType;
import muramasa.antimatter.texture.Texture;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockState;

public class StoneType
implements ISharedAntimatterObject,
IRegistryEntryProvider {
    private final String domain;
    private final String id;
    private boolean gravity;
    private boolean requiresTool;
    public boolean generateBlock;
    public boolean generateOre = true;
    private final Material material;
    private Texture[] textures;
    private final SoundType soundType;
    private BlockState state;
    private Supplier<BlockState> stateSupplier;
    private int harvestLevel;
    private int fallingDustColor;
    private float hardness;
    private float resistence;
    private TagKey<Block> toolType;
    private net.minecraft.world.level.material.Material blockMaterial;
    private boolean sandLike = false;

    public StoneType(String domain, String id, Material material, Texture texture, SoundType soundType, boolean generateBlock) {
        this.domain = domain;
        this.id = id;
        this.material = material;
        this.textures = new Texture[]{texture};
        this.soundType = soundType;
        this.generateBlock = generateBlock;
        this.gravity = false;
        this.harvestLevel = 0;
        this.requiresTool = true;
        this.hardness = 1.5f;
        this.resistence = 6.0f;
        this.toolType = BlockTags.f_144282_;
        this.fallingDustColor = -16777216;
        this.blockMaterial = net.minecraft.world.level.material.Material.f_76278_;
    }

    public StoneType setHarvestLevel(int harvestLevel) {
        this.harvestLevel = harvestLevel;
        return this;
    }

    public StoneType setHardnessAndResistance(float hardnessAndResistence) {
        this.hardness = hardnessAndResistence;
        this.resistence = hardnessAndResistence;
        return this;
    }

    public StoneType setHardnessAndResistance(float hardness, float resistence) {
        this.hardness = hardness;
        this.resistence = resistence;
        return this;
    }

    public StoneType setGravity(boolean gravity) {
        this.gravity = gravity;
        return this;
    }

    public StoneType setRequiresTool(boolean requiresTool) {
        this.requiresTool = requiresTool;
        return this;
    }

    public StoneType setFallingDustColor(int fallingDustColor) {
        this.fallingDustColor = fallingDustColor;
        return this;
    }

    public StoneType setSandLike(boolean sandLike) {
        this.sandLike = sandLike;
        return this;
    }

    public StoneType setGenerateOre(boolean generateOre) {
        this.generateOre = generateOre;
        return this;
    }

    public StoneType setType(TagKey<Block> type) {
        this.toolType = type;
        return this;
    }

    public StoneType setBlockMaterial(net.minecraft.world.level.material.Material material) {
        this.blockMaterial = material;
        return this;
    }

    public StoneType setTextures(Texture ... textures) {
        this.textures = textures;
        return this;
    }

    @Override
    public void onRegistryBuild(RegistryType registry) {
        if (this.generateBlock && registry == RegistryType.BLOCKS) {
            this.setState(new BlockStone(this));
        }
    }

    @Override
    public String getDomain() {
        return this.domain;
    }

    @Override
    public String getId() {
        return this.id;
    }

    public Material getMaterial() {
        return this.material;
    }

    public BlockState getState() {
        return this.state;
    }

    public Texture getTexture() {
        return this.textures[0];
    }

    public Texture[] getTextures() {
        return this.textures;
    }

    public SoundType getSoundType() {
        return this.soundType;
    }

    public TagKey<Block> getToolType() {
        return this.toolType;
    }

    public int getFallingDustColor() {
        return this.fallingDustColor;
    }

    public net.minecraft.world.level.material.Material getBlockMaterial() {
        return this.blockMaterial;
    }

    public boolean doesGenerateBlock() {
        return this.generateBlock;
    }

    public boolean doesGenerateOre() {
        return this.generateOre;
    }

    public boolean doesRequireTool() {
        return this.requiresTool;
    }

    public boolean isSandLike() {
        return this.sandLike;
    }

    public StoneType setState(Block block) {
        this.state = block.m_49966_();
        return this;
    }

    public StoneType setState(BlockState blockState) {
        this.state = blockState;
        return this;
    }

    public StoneType setStateSupplier(Supplier<BlockState> blockState) {
        this.stateSupplier = blockState;
        return this;
    }

    public int getHarvestLevel() {
        return this.harvestLevel;
    }

    public float getHardness() {
        return this.hardness;
    }

    public float getResistence() {
        return this.resistence;
    }

    public boolean getGravity() {
        return this.gravity;
    }

    public static Collection<Collection<Texture>> getAllTextures() {
        ObjectArrayList textures = new ObjectArrayList();
        for (StoneType type : StoneType.getAllGeneratingBlock()) {
            textures.add(Arrays.asList(type.getTextures()));
        }
        return textures;
    }

    public static StoneType[] getAllGeneratingBlock() {
        return (StoneType[])AntimatterAPI.all(StoneType.class).stream().filter(s -> s.generateBlock).toArray(StoneType[]::new);
    }

    public void initSuppliedState() {
        if (this.state == null && this.stateSupplier != null) {
            this.state = this.stateSupplier.get();
        }
    }

    public static StoneType get(String id) {
        return AntimatterAPI.get(StoneType.class, id);
    }
}

