/*
 * Decompiled with CFR 0.152.
 */
package muramasa.antimatter.ore;

import java.util.LinkedHashMap;
import java.util.Map;
import muramasa.antimatter.block.BlockStone;
import muramasa.antimatter.block.BlockStoneSlab;
import muramasa.antimatter.block.BlockStoneStair;
import muramasa.antimatter.block.BlockStoneWall;
import muramasa.antimatter.material.Material;
import muramasa.antimatter.ore.StoneType;
import muramasa.antimatter.registration.RegistryType;
import muramasa.antimatter.texture.Texture;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SoundType;

public class CobbleStoneType
extends StoneType {
    String beginningPath;
    Map<String, Block> blocks = new LinkedHashMap<String, Block>();
    public static final String[] SUFFIXES = new String[]{"bricks_chiseled", "bricks_cracked", "bricks_mossy", "cobble_mossy", "bricks", "cobble", "smooth", ""};
    public static final String[] SLAB_SUFFIXES = new String[]{"bricks_mossy_slab", "cobble_mossy_slab", "bricks_slab", "cobble_slab", "smooth_slab", "slab"};
    public static final String[] STAIR_SUFFIXES = new String[]{"bricks_mossy_stairs", "cobble_mossy_stairs", "bricks_stairs", "cobble_stairs", "smooth_stairs", "stairs"};
    public static final String[] WALL_SUFFIXES = new String[]{"bricks_mossy_wall", "cobble_mossy_wall", "bricks_wall", "cobble_wall", "smooth_wall", "wall"};

    public CobbleStoneType(String domain, String id, Material material, String beginningPath, SoundType soundType, boolean generateBlock) {
        super(domain, id, material, new Texture(domain, beginningPath + id + "/stone"), soundType, generateBlock);
        this.beginningPath = beginningPath;
    }

    @Override
    public void onRegistryBuild(RegistryType registry) {
        if (registry == RegistryType.BLOCKS && this.generateBlock) {
            for (int i = 0; i < SUFFIXES.length; ++i) {
                BlockStone stone;
                if (i == 7) {
                    stone = new BlockStone(this);
                    this.setState(stone);
                } else {
                    stone = new BlockStone(this, SUFFIXES[i]);
                }
                this.blocks.put(SUFFIXES[i], stone);
                if (i < 2) continue;
                int i2 = i - 2;
                this.blocks.put(SLAB_SUFFIXES[i2], (Block)new BlockStoneSlab(this, SUFFIXES[i]));
                this.blocks.put(STAIR_SUFFIXES[i2], (Block)new BlockStoneStair(this, SUFFIXES[i], stone));
                this.blocks.put(WALL_SUFFIXES[i2], (Block)new BlockStoneWall(this, SUFFIXES[i]));
            }
        }
    }

    public String getBeginningPath() {
        return this.beginningPath;
    }

    public Block getBlock(String name) {
        return this.blocks.get(name);
    }

    public Map<String, Block> getBlocks() {
        return this.blocks;
    }
}

