/*
 * Decompiled with CFR 0.152.
 */
package muramasa.antimatter.ore;

import java.util.List;
import java.util.Random;
import javax.annotation.Nonnull;
import muramasa.antimatter.AntimatterConfig;
import muramasa.antimatter.data.AntimatterMaterials;
import muramasa.antimatter.material.Material;
import muramasa.antimatter.material.MaterialTags;
import muramasa.antimatter.material.MaterialType;
import muramasa.antimatter.ore.BlockMaterialStone;
import muramasa.antimatter.ore.StoneType;
import muramasa.antimatter.registration.IModelProvider;
import muramasa.antimatter.registration.ISharedAntimatterObject;
import muramasa.antimatter.registration.ITextureProvider;
import muramasa.antimatter.texture.Texture;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.entity.item.FallingBlockEntity;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Fallable;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.ticks.ScheduledTick;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.apache.commons.lang3.ArrayUtils;
import org.jetbrains.annotations.Nullable;

public class BlockOre
extends BlockMaterialStone
implements ITextureProvider,
IModelProvider,
ISharedAntimatterObject,
Fallable {
    private final MaterialType<?> oreType;

    public BlockOre(String domain, Material material, StoneType stoneType, MaterialType<?> oreType, BlockBehaviour.Properties properties) {
        super(domain, oreType.getId() + "_" + material.getId() + "_" + stoneType.getId(), material, stoneType, BlockOre.getOreProperties(properties, stoneType));
        this.oreType = oreType;
    }

    public BlockOre(String domain, Material material, StoneType stoneType, MaterialType<?> oreType) {
        this(domain, material, stoneType, oreType, BlockOre.getOreProperties(BlockBehaviour.Properties.m_60939_((net.minecraft.world.level.material.Material)stoneType.getBlockMaterial()), stoneType));
    }

    @Nonnull
    public String m_7705_() {
        return this.getId();
    }

    public MaterialType<?> getOreType() {
        return this.oreType;
    }

    public void m_49811_(CreativeModeTab group, NonNullList<ItemStack> items) {
        if (this.stoneType.getId().equals("stone")) {
            items.add((Object)new ItemStack((ItemLike)this));
        }
    }

    public void m_6807_(BlockState state, Level worldIn, BlockPos pos, BlockState oldState, boolean isMoving) {
        if (this.stoneType.getGravity()) {
            worldIn.m_183326_().m_183393_(new ScheduledTick((Object)this, pos, (long)this.getFallDelay(), 0L));
        }
    }

    public BlockState m_7417_(BlockState stateIn, Direction facing, BlockState facingState, LevelAccessor worldIn, BlockPos currentPos, BlockPos facingPos) {
        if (this.stoneType.getGravity()) {
            worldIn.m_183326_().m_183393_(new ScheduledTick((Object)this, currentPos, (long)this.getFallDelay(), 0L));
        }
        return super.m_7417_(stateIn, facing, facingState, worldIn, currentPos, facingPos);
    }

    public void m_7458_(BlockState state, ServerLevel worldIn, BlockPos pos, Random rand) {
        if (this.stoneType.getGravity() && (worldIn.m_46859_(pos.m_7495_()) || BlockOre.canFallThrough(worldIn.m_8055_(pos.m_7495_())) && pos.m_123342_() >= worldIn.m_141937_())) {
            FallingBlockEntity fallingBlockEntity = FallingBlockEntity.m_201971_((Level)worldIn, (BlockPos)pos, (BlockState)state);
            this.onStartFalling(fallingBlockEntity);
        }
    }

    protected void onStartFalling(FallingBlockEntity fallingEntity) {
    }

    protected int getFallDelay() {
        return 2;
    }

    public static boolean canFallThrough(BlockState state) {
        net.minecraft.world.level.material.Material material = state.m_60767_();
        return state.m_60795_() || state.m_204336_(BlockTags.f_13076_) || material.m_76332_() || material.m_76336_();
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_7100_(BlockState stateIn, Level worldIn, BlockPos pos, Random rand) {
        BlockPos blockpos;
        if (this.stoneType.getGravity() && rand.nextInt(16) == 0 && (worldIn.m_46859_(blockpos = pos.m_7495_()) || BlockOre.canFallThrough(worldIn.m_8055_(blockpos)))) {
            double d0 = (double)pos.m_123341_() + rand.nextDouble();
            double d1 = (double)pos.m_123342_() - 0.05;
            double d2 = (double)pos.m_123343_() + rand.nextDouble();
            worldIn.m_7106_((ParticleOptions)new BlockParticleOption(ParticleTypes.f_123814_, stateIn), d0, d1, d2, 0.0, 0.0, 0.0);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public int getDustColor(BlockState state, BlockGetter reader, BlockPos pos) {
        return this.stoneType.getFallingDustColor();
    }

    @Override
    public Texture[] getTextures() {
        Texture ore = this.getMaterial().getSet().getTexture(this.getOreType(), 0);
        if (this.getStoneType().getTextures().length == 6) {
            Texture[] ores = new Texture[]{ore, ore, ore, ore, ore, ore};
            return (Texture[])ArrayUtils.addAll((Object[])this.getStoneType().getTextures(), (Object[])ores);
        }
        return new Texture[]{this.getStoneType().getTexture(), ore};
    }

    public static BlockBehaviour.Properties getOreProperties(BlockBehaviour.Properties properties, StoneType type) {
        if (AntimatterConfig.WORLD.ORE_VEIN_SPECTATOR_DEBUG) {
            properties.m_60955_().m_60953_(b -> 15);
        }
        properties.m_60913_(type.getHardness() * 2.0f, type.getResistence() / 2.0f).m_60918_(type.getSoundType());
        if (type.doesRequireTool()) {
            properties.m_60999_();
        }
        return properties;
    }

    public int getExpDrop(BlockState state, LevelReader world, BlockPos pos, int fortune, int silktouch) {
        if (silktouch == 0 && this.material.has(MaterialTags.EXP_RANGE)) {
            List self = BlockOre.m_49869_((BlockState)state, (ServerLevel)((ServerLevel)world), (BlockPos)pos, (BlockEntity)world.m_7702_(pos));
            if (self.stream().anyMatch(i -> i.m_41720_() == this.m_5456_())) {
                return 0;
            }
            return MaterialTags.EXP_RANGE.get(this.material).m_142270_(((ServerLevel)world).m_5822_());
        }
        return 0;
    }

    @Override
    public int getBlockColor(BlockState state, @Nullable BlockGetter world, @Nullable BlockPos pos, int i) {
        if (i == 1 && this.material == AntimatterMaterials.Iron) {
            return 14860458;
        }
        return super.getBlockColor(state, world, pos, i);
    }

    @Override
    public int getItemColor(ItemStack stack, @Nullable Block block, int i) {
        if (i == 1 && this.material == AntimatterMaterials.Iron) {
            return 14860458;
        }
        return super.getItemColor(stack, block, i);
    }
}

