/*
 * Decompiled with CFR 0.152.
 */
package muramasa.antimatter.network.packets;

import com.teamresourceful.resourcefullib.common.networking.base.PacketContext;
import com.teamresourceful.resourcefullib.common.networking.base.PacketHandler;
import muramasa.antimatter.capability.IGuiHandler;
import muramasa.antimatter.gui.container.IAntimatterContainer;
import muramasa.antimatter.gui.event.IGuiEvent;
import muramasa.antimatter.network.AntimatterNetwork;
import muramasa.antimatter.network.packets.AbstractGuiEventPacket;
import muramasa.antimatter.util.Utils;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.entity.BlockEntity;

public class TileGuiEventPacket
extends AbstractGuiEventPacket<TileGuiEventPacket> {
    public static final Handler HANDLER = new Handler();

    public TileGuiEventPacket(IGuiEvent event, BlockPos pos) {
        super(event, pos, AntimatterNetwork.TILE_GUI_PACKET_ID);
    }

    public PacketHandler<TileGuiEventPacket> getHandler() {
        return HANDLER;
    }

    public static TileGuiEventPacket decode(FriendlyByteBuf buf) {
        return new TileGuiEventPacket(IGuiEvent.IGuiEventFactory.read(buf), buf.m_130135_());
    }

    private static class Handler
    implements PacketHandler<TileGuiEventPacket> {
        private Handler() {
        }

        public void encode(TileGuiEventPacket msg, FriendlyByteBuf buf) {
            msg.event.getFactory().write(msg.event, buf);
            buf.m_130064_(msg.pos);
        }

        public TileGuiEventPacket decode(FriendlyByteBuf buf) {
            return new TileGuiEventPacket(IGuiEvent.IGuiEventFactory.read(buf), buf.m_130135_());
        }

        public PacketContext handle(TileGuiEventPacket msg) {
            return (sender, level) -> {
                BlockEntity tile;
                if (sender != null && (tile = Utils.getTile((BlockGetter)sender.m_183503_(), msg.pos)) instanceof IGuiHandler) {
                    if (msg.event.forward()) {
                        ((IGuiHandler)tile).onGuiEvent(msg.event, sender);
                    } else {
                        msg.event.handle(sender, ((IAntimatterContainer)sender.f_36096_).source());
                    }
                }
            };
        }
    }
}

