/*
 * Decompiled with CFR 0.152.
 */
package muramasa.antimatter.network.packets;

import com.teamresourceful.resourcefullib.common.networking.base.PacketContext;
import com.teamresourceful.resourcefullib.common.networking.base.PacketHandler;
import java.util.Optional;
import muramasa.antimatter.capability.ICoverHandler;
import muramasa.antimatter.gui.container.IAntimatterContainer;
import muramasa.antimatter.gui.event.IGuiEvent;
import muramasa.antimatter.network.AntimatterNetwork;
import muramasa.antimatter.network.packets.AbstractGuiEventPacket;
import muramasa.antimatter.util.AntimatterCapUtils;
import muramasa.antimatter.util.Utils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.entity.BlockEntity;

public class CoverGuiEventPacket
extends AbstractGuiEventPacket<CoverGuiEventPacket> {
    public static final Handler HANDLER = new Handler();
    Direction facing;

    public CoverGuiEventPacket(IGuiEvent event, BlockPos pos, Direction facing) {
        super(event, pos, AntimatterNetwork.COVER_GUI_PACKET_ID);
        this.facing = facing;
    }

    public PacketHandler<CoverGuiEventPacket> getHandler() {
        return HANDLER;
    }

    private static class Handler
    implements PacketHandler<CoverGuiEventPacket> {
        private Handler() {
        }

        public void encode(CoverGuiEventPacket msg, FriendlyByteBuf buf) {
            msg.event.getFactory().write(msg.event, buf);
            buf.m_130064_(msg.pos);
            buf.m_130068_((Enum)msg.facing);
        }

        public CoverGuiEventPacket decode(FriendlyByteBuf buf) {
            return new CoverGuiEventPacket(IGuiEvent.IGuiEventFactory.read(buf), buf.m_130135_(), (Direction)buf.m_130066_(Direction.class));
        }

        public PacketContext handle(CoverGuiEventPacket msg) {
            return (sender, level) -> {
                if (sender != null) {
                    BlockEntity tile = Utils.getTile((BlockGetter)sender.m_183503_(), msg.pos);
                    if (tile == null) {
                        throw new RuntimeException("Somehow you got an incorrect packet, CoverGuiEventPacket::handleClient missing Entity!");
                    }
                    Optional<ICoverHandler<?>> coverHandler = AntimatterCapUtils.getCoverHandler(tile, msg.facing);
                    if (msg.event.forward()) {
                        coverHandler.ifPresent(ch -> ch.get(msg.facing).onGuiEvent(msg.event, sender));
                    } else {
                        msg.event.handle(sender, ((IAntimatterContainer)sender.f_36096_).source());
                    }
                }
            };
        }
    }
}

