/*
 * Decompiled with CFR 0.152.
 */
package muramasa.antimatter.network.packets;

import com.teamresourceful.resourcefullib.common.networking.base.PacketContext;
import com.teamresourceful.resourcefullib.common.networking.base.PacketHandler;
import io.netty.buffer.ByteBuf;
import java.util.List;
import muramasa.antimatter.gui.GuiInstance;
import muramasa.antimatter.gui.ICanSyncData;
import muramasa.antimatter.gui.container.AntimatterContainer;
import muramasa.antimatter.gui.container.IAntimatterContainer;
import muramasa.antimatter.network.AntimatterNetwork;
import muramasa.antimatter.network.packets.GuiSyncPacket;
import net.minecraft.client.Minecraft;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.AbstractContainerMenu;

public class ClientboundGuiSyncPacket
extends GuiSyncPacket<ClientboundGuiSyncPacket> {
    public static final ClientHandler HANDLER = new ClientHandler();

    public ClientboundGuiSyncPacket(List<GuiInstance.SyncHolder> data) {
        super(data);
    }

    public ClientboundGuiSyncPacket(ByteBuf data) {
        super(data);
    }

    public ResourceLocation getID() {
        return AntimatterNetwork.GUI_SYNC_PACKET_ID;
    }

    public PacketHandler<ClientboundGuiSyncPacket> getHandler() {
        return HANDLER;
    }

    private static class ClientHandler
    implements PacketHandler<ClientboundGuiSyncPacket> {
        private ClientHandler() {
        }

        public void encode(ClientboundGuiSyncPacket msg, FriendlyByteBuf buf) {
            buf.m_130130_(msg.data.length);
            for (GuiInstance.SyncHolder data : msg.data) {
                buf.m_130130_(data.index);
                data.writer.accept(buf, data.current);
            }
        }

        public ClientboundGuiSyncPacket decode(FriendlyByteBuf buf) {
            return new ClientboundGuiSyncPacket(buf.copy());
        }

        public PacketContext handle(ClientboundGuiSyncPacket msg) {
            return (sender, level) -> {
                AbstractContainerMenu c = Minecraft.m_91087_().f_91074_.f_36096_;
                if (c instanceof IAntimatterContainer) {
                    ((AntimatterContainer)c).handler.receivePacket(msg, ICanSyncData.SyncDirection.SERVER_TO_CLIENT);
                }
            };
        }
    }
}

