/*
 * Decompiled with CFR 0.152.
 */
package muramasa.antimatter.mixin.forge.client;

import java.util.Collections;
import java.util.List;
import java.util.Random;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import muramasa.antimatter.client.baked.IAntimatterBakedModel;
import muramasa.antimatter.client.forge.AntimatterModelProperties;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.client.model.data.EmptyModelData;
import net.minecraftforge.client.model.data.IDynamicBakedModel;
import net.minecraftforge.client.model.data.IModelData;
import net.minecraftforge.client.model.data.ModelDataMap;
import org.jetbrains.annotations.NotNull;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;

@Mixin(value={IAntimatterBakedModel.class})
public interface IAntimatterBakedModelMixin
extends IDynamicBakedModel {
    @Shadow
    public boolean hasOnlyGeneralQuads();

    @Shadow
    public List<BakedQuad> getQuads(BlockState var1, @Nullable Direction var2, @Nonnull Random var3, @Nonnull BlockAndTintGetter var4, @Nonnull BlockPos var5);

    @Shadow
    public TextureAtlasSprite getParticleIcon(@Nonnull BlockAndTintGetter var1, @Nonnull BlockPos var2);

    @NotNull
    default public List<BakedQuad> getQuads(@Nullable BlockState state, @Nullable Direction side, @Nonnull Random rand, @Nonnull IModelData data) {
        BlockAndTintGetter world = (BlockAndTintGetter)data.getData(AntimatterModelProperties.WORLD);
        BlockPos pos = (BlockPos)data.getData(AntimatterModelProperties.POS);
        if (world == null || pos == null) {
            return Collections.emptyList();
        }
        return this.getQuads(state, side, rand, world, pos);
    }

    @NotNull
    default public IModelData getModelData(@NotNull BlockAndTintGetter level, @NotNull BlockPos pos, @NotNull BlockState state, @NotNull IModelData modelData) {
        IModelData d = super.getModelData(level, pos, state, modelData);
        if (d == EmptyModelData.INSTANCE) {
            d = new ModelDataMap.Builder().build();
        }
        d.setData(AntimatterModelProperties.WORLD, (Object)level);
        d.setData(AntimatterModelProperties.POS, (Object)pos);
        return d;
    }

    default public TextureAtlasSprite getParticleIcon(@NotNull IModelData data) {
        BlockAndTintGetter world = (BlockAndTintGetter)data.getData(AntimatterModelProperties.WORLD);
        BlockPos pos = (BlockPos)data.getData(AntimatterModelProperties.POS);
        if (world == null || pos == null) {
            return super.getParticleIcon(data);
        }
        return this.getParticleIcon(world, pos);
    }
}

