/*
 * Decompiled with CFR 0.152.
 */
package muramasa.antimatter.material.tags;

import it.unimi.dsi.fastutil.objects.Object2ObjectArrayMap;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.List;
import java.util.Map;
import muramasa.antimatter.material.Material;
import muramasa.antimatter.material.MaterialTag;

public class ListMaterialTag<T>
extends MaterialTag {
    private final Map<Material, List<T>> mapping = new Object2ObjectArrayMap();

    public ListMaterialTag(String id) {
        super(id);
    }

    public ListMaterialTag<T> add(Material mat, List<T> map) {
        if (!mat.enabled) {
            return this;
        }
        if (!this.mapping.containsKey(mat)) {
            super.add(mat);
        }
        this.mapping.put(mat, map);
        return this;
    }

    public ListMaterialTag<T> add(Material mat, T map) {
        if (!mat.enabled) {
            return this;
        }
        if (!this.mapping.containsKey(mat)) {
            super.add(mat);
            this.mapping.put(mat, (List<T>)new ObjectArrayList());
        }
        this.mapping.get(mat).add(map);
        return this;
    }

    public Map<Material, List<T>> getAll() {
        return this.mapping;
    }

    public List<T> getList(Material mat) {
        return this.mapping.get(mat);
    }
}

