/*
 * Decompiled with CFR 0.152.
 */
package muramasa.antimatter.material;

import muramasa.antimatter.AntimatterAPI;
import muramasa.antimatter.material.MaterialType;
import muramasa.antimatter.registration.IAntimatterObject;
import muramasa.antimatter.texture.Texture;

public class TextureSet
implements IAntimatterObject {
    public static final TextureSet NONE = new TextureSet("antimatter", "none");
    public static final TextureSet DULL = new TextureSet("antimatter", "dull");
    public static final TextureSet METALLIC = new TextureSet("antimatter", "metallic");
    public static final TextureSet SHINY = new TextureSet("antimatter", "shiny");
    public static final TextureSet ROUGH = new TextureSet("antimatter", "rough");
    public static final TextureSet MAGNETIC = new TextureSet("antimatter", "magnetic");
    public static final TextureSet DIAMOND = new TextureSet("antimatter", "diamond");
    public static final TextureSet RUBY = new TextureSet("antimatter", "ruby");
    public static final TextureSet LAPIS = new TextureSet("antimatter", "lapis");
    public static final TextureSet GEM_H = new TextureSet("antimatter", "gem_h");
    public static final TextureSet GEM_V = new TextureSet("antimatter", "gem_v");
    public static final TextureSet GARNET = new TextureSet("antimatter", "garnet");
    public static final TextureSet QUARTZ = new TextureSet("antimatter", "quartz");
    public static final TextureSet FINE = new TextureSet("antimatter", "fine");
    public static final TextureSet FLINT = new TextureSet("antimatter", "flint");
    public static final TextureSet LIGNITE = new TextureSet("antimatter", "lignite");
    public static final TextureSet WOOD = new TextureSet("antimatter", "wood");
    public static final TextureSet REDSTONE = new TextureSet("antimatter", "redstone");
    private String domain;
    private String id;

    public TextureSet(String domain, String id) {
        this.domain = domain;
        this.id = id;
        AntimatterAPI.register(TextureSet.class, this);
    }

    @Override
    public String getDomain() {
        return this.domain;
    }

    @Override
    public String getId() {
        return this.id;
    }

    public Texture getTexture(MaterialType<?> type, int layer) {
        StringBuilder builder = new StringBuilder();
        builder.append("material/");
        if (!type.ignoreTextureSets()) {
            builder.append(this.id).append("/");
        }
        builder.append(type.getId()).append(layer == 0 ? "" : "_overlay");
        return new Texture(type.ignoreTextureSets() ? "antimatter" : this.domain, builder.toString());
    }

    public String getPath() {
        return "material/" + this.id;
    }

    public Texture[] getTextures(MaterialType<?> type) {
        Texture[] textures = new Texture[type.getLayers()];
        for (int i = 0; i < type.getLayers(); ++i) {
            textures[i] = this.getTexture(type, i);
        }
        return textures;
    }

    public static void init() {
    }
}

