/*
 * Decompiled with CFR 0.152.
 */
package muramasa.antimatter.material;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.google.common.collect.ImmutableMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectLinkedOpenHashSet;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;
import muramasa.antimatter.AntimatterAPI;
import muramasa.antimatter.AntimatterConfig;
import muramasa.antimatter.material.IMaterialTag;
import muramasa.antimatter.material.Material;
import muramasa.antimatter.material.MaterialItem;
import muramasa.antimatter.recipe.ingredient.RecipeIngredient;
import muramasa.antimatter.registration.IRegistryEntryProvider;
import muramasa.antimatter.registration.ISharedAntimatterObject;
import muramasa.antimatter.registration.RegistryType;
import muramasa.antimatter.util.TagUtils;
import muramasa.antimatter.util.Utils;
import net.minecraft.network.chat.Component;
import net.minecraft.tags.TagKey;
import net.minecraft.util.Tuple;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class MaterialType<T>
implements IMaterialTag,
ISharedAntimatterObject,
IRegistryEntryProvider {
    protected final String id;
    protected int layers;
    protected long unitValue;
    protected boolean generating = true;
    protected boolean blockType;
    protected boolean visible;
    protected boolean splitName;
    protected final Set<Material> materials = new ObjectLinkedOpenHashSet();
    protected final Map<MaterialType<?>, TagKey<?>> tagMap = new Object2ObjectOpenHashMap();
    protected T getter;
    private boolean hidden = false;
    protected final BiMap<Material, Supplier<Item>> replacements = HashBiMap.create();
    protected final Set<IMaterialTag> dependents = new ObjectLinkedOpenHashSet();
    protected boolean hasRegistered;
    protected boolean ignoreTextureSets = false;
    public static ImmutableMap<Item, Tuple<MaterialType, Material>> tooltipCache;

    public MaterialType(String id, int layers, boolean visible, long unitValue) {
        this.id = id;
        this.visible = visible;
        this.unitValue = unitValue;
        this.layers = layers;
        this.splitName = id.contains("_");
        this.tagMap.put(this, this.tagFromString(Utils.getConventionalMaterialType(this)));
        this.register(MaterialType.class, this.getId());
    }

    protected TagKey<?> tagFromString(String name) {
        return TagUtils.getForgelikeItemTag(name);
    }

    public MaterialType<T> nonGen() {
        this.generating = false;
        return this;
    }

    public void dependents(IMaterialTag ... tags) {
        this.dependents.addAll(Arrays.asList(tags));
    }

    public void replacement(Material mat, Supplier<Item> replacement) {
        if (!mat.enabled) {
            return;
        }
        this.replacements.put((Object)mat, replacement);
        this.add(mat);
        AntimatterAPI.addReplacement(this.getMaterialTag(mat), replacement);
    }

    public Material getMaterialFromStack(ItemStack stack) {
        Item item = stack.m_41720_();
        if (item instanceof MaterialItem) {
            MaterialItem item2 = (MaterialItem)item;
            if (item2.getType() == this) {
                return item2.getMaterial();
            }
            return null;
        }
        for (Map.Entry entry : this.replacements.entrySet()) {
            Item item3 = (Item)((Supplier)entry.getValue()).get();
            if (item3 != stack.m_41720_()) continue;
            return (Material)entry.getKey();
        }
        for (TagKey tagKey : stack.m_41720_().m_204114_().m_203616_().toList()) {
            Material material;
            String prefix = this.getTag().f_203868_().m_135815_() + "/";
            if (!tagKey.f_203868_().m_135827_().equals(this.getTag().f_203868_().m_135827_()) || !tagKey.f_203868_().m_135815_().contains(prefix) || (material = Material.get(tagKey.f_203868_().m_135815_().replace(prefix, ""))) == Material.NULL) continue;
            return material;
        }
        stack.m_41720_().m_204114_().m_203616_().forEach(t -> {});
        return null;
    }

    public boolean hidden() {
        return this.hidden;
    }

    public MaterialType<T> setHidden() {
        this.hidden = true;
        return this;
    }

    public boolean ignoreTextureSets() {
        return this.ignoreTextureSets;
    }

    public MaterialType<T> setIgnoreTextureSets() {
        this.ignoreTextureSets = true;
        return this;
    }

    public TagKey<Item> getMaterialTag(Material m) {
        return this.tagFromString(String.join((CharSequence)"", Utils.getConventionalMaterialType(this), "/", this.getId().equals("raw_ore_block") ? "raw_" : "", m.getId()));
    }

    public RecipeIngredient getMaterialIngredient(Material m, int count) {
        return RecipeIngredient.of(this.getMaterialTag(m), count);
    }

    public MaterialType<T> blockType() {
        this.blockType = true;
        this.tagMap.put(this, TagUtils.getForgelikeBlockTag(Utils.getConventionalMaterialType(this)));
        return this;
    }

    public MaterialType<T> unSplitName() {
        this.splitName = false;
        this.tagMap.put(this, this.tagFromString(Utils.getConventionalMaterialType(this)));
        return this;
    }

    @Override
    public String getId() {
        return this.id;
    }

    public long getUnitValue() {
        return this.unitValue;
    }

    public int getLayers() {
        return this.layers;
    }

    public <T> TagKey<T> getTag() {
        return this.tagMap.get(this);
    }

    public MaterialType<T> set(T getter) {
        this.getter = getter;
        return this;
    }

    @Override
    public Set<IMaterialTag> dependents() {
        return this.dependents;
    }

    public T get() {
        return this.getter;
    }

    @Override
    public Set<Material> all() {
        return this.materials;
    }

    public boolean isVisible() {
        return this.visible || AntimatterConfig.CLIENT.SHOW_ALL_MATERIAL_ITEMS;
    }

    public boolean allowGen(Material material) {
        return this.generating && this.materials.contains(material) && AntimatterAPI.getReplacement(this, material, new String[0]) == null;
    }

    public boolean isSplitName() {
        return this.splitName;
    }

    public String toString() {
        return this.getId();
    }

    public BiMap<Material, Supplier<Item>> getReplacements() {
        return this.replacements;
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void buildTooltips() {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        AntimatterAPI.all(MaterialType.class, (T t) -> {
            BiMap map = t.getReplacements().inverse();
            for (Map.Entry entry : map.entrySet()) {
                builder.put((Object)((Item)((Supplier)entry.getKey()).get()), (Object)new Tuple(t, (Object)((Material)entry.getValue())));
            }
        });
        tooltipCache = builder.build();
    }

    public static void addTooltip(ItemStack stack, List<Component> tooltips, Player player, TooltipFlag flag) {
        if (player == null) {
            return;
        }
        if (tooltipCache == null) {
            return;
        }
        Tuple mat = (Tuple)tooltipCache.get((Object)stack.m_41720_());
        if (mat == null) {
            Item item = stack.m_41720_();
            if (item instanceof MaterialItem) {
                MaterialItem item2 = (MaterialItem)item;
                MaterialItem.addTooltipsForMaterialItems(stack, item2.material, item2.type, player.f_19853_, tooltips, flag);
            }
            return;
        }
        MaterialItem.addTooltipsForMaterialItems(stack, (Material)mat.m_14419_(), (MaterialType)mat.m_14418_(), player.f_19853_, tooltips, flag);
    }

    @Override
    public void onRegistryBuild(RegistryType registry) {
    }

    protected boolean doRegister() {
        boolean old = this.hasRegistered;
        this.hasRegistered = true;
        return !old;
    }
}

