/*
 * Decompiled with CFR 0.152.
 */
package muramasa.antimatter.material;

import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import muramasa.antimatter.Ref;
import muramasa.antimatter.data.AntimatterMaterialTypes;
import muramasa.antimatter.data.AntimatterStoneTypes;
import muramasa.antimatter.item.ItemBasic;
import muramasa.antimatter.material.Material;
import muramasa.antimatter.material.MaterialTags;
import muramasa.antimatter.material.MaterialType;
import muramasa.antimatter.material.MaterialTypeBlock;
import muramasa.antimatter.ore.StoneType;
import muramasa.antimatter.registration.IColorHandler;
import muramasa.antimatter.registration.IModelProvider;
import muramasa.antimatter.registration.ISharedAntimatterObject;
import muramasa.antimatter.registration.ITextureProvider;
import muramasa.antimatter.texture.Texture;
import muramasa.antimatter.util.AntimatterPlatformUtils;
import muramasa.antimatter.util.TagUtils;
import muramasa.antimatter.util.Utils;
import muramasa.antimatter.worldgen.WorldGenHelper;
import net.minecraft.ChatFormatting;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.BlockPos;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.TagKey;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.AbstractCauldronBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.LayeredCauldronBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.Property;

public class MaterialItem
extends ItemBasic<MaterialItem>
implements ISharedAntimatterObject,
IColorHandler,
ITextureProvider,
IModelProvider {
    protected Material material;
    protected MaterialType<?> type;

    public MaterialItem(String domain, MaterialType<?> type, Material material, Item.Properties properties) {
        super(domain, type.getId() + "_" + material.getId(), MaterialItem.class, properties);
        this.material = material;
        this.type = type;
    }

    public MaterialItem(String domain, MaterialType<?> type, Material material) {
        this(domain, type, material, new Item.Properties().m_41491_(Ref.TAB_MATERIALS));
    }

    public MaterialType<?> getType() {
        return this.type;
    }

    public Material getMaterial() {
        return this.material;
    }

    public void m_6787_(CreativeModeTab group, NonNullList<ItemStack> items) {
        if (this.m_41389_(group) && this.getType().isVisible()) {
            items.add((Object)new ItemStack((ItemLike)this));
        }
    }

    public void m_7373_(ItemStack stack, @Nullable Level world, List<Component> tooltip, TooltipFlag flag) {
        if (this.type == AntimatterMaterialTypes.ROCK) {
            tooltip.add((Component)new TranslatableComponent("antimatter.tooltip.occurrence").m_7220_((Component)new TextComponent(this.material.getDisplayName().getString()).m_130940_(ChatFormatting.YELLOW)));
        }
    }

    public static void addTooltipsForMaterialItems(ItemStack stack, Material mat, MaterialType<?> type, @Nullable Level world, List<Component> tooltip, TooltipFlag flag) {
        if (!mat.getChemicalFormula().isEmpty()) {
            if (Screen.m_96638_()) {
                tooltip.add((Component)new TranslatableComponent("antimatter.tooltip.chemical_formula").m_130946_(": ").m_7220_((Component)new TextComponent(mat.getChemicalFormula()).m_130940_(ChatFormatting.DARK_AQUA)));
                tooltip.add((Component)new TranslatableComponent("antimatter.tooltip.mass").m_130946_(": ").m_7220_((Component)new TextComponent("" + mat.getMass()).m_130940_(ChatFormatting.DARK_AQUA)));
                tooltip.add((Component)new TranslatableComponent("antimatter.tooltip.material_modid", new Object[]{AntimatterPlatformUtils.getModName(mat.materialDomain())}));
            } else {
                tooltip.add((Component)new TranslatableComponent("antimatter.tooltip.formula").m_130940_(ChatFormatting.AQUA).m_130940_(ChatFormatting.ITALIC));
            }
        }
    }

    public InteractionResult m_6225_(UseOnContext context) {
        if (this.type == AntimatterMaterialTypes.ROCK) {
            return this.tryPlace(new BlockPlaceContext(context));
        }
        return super.m_6225_(context);
    }

    public InteractionResult tryPlace(BlockPlaceContext context) {
        if (!context.m_7059_()) {
            return InteractionResult.FAIL;
        }
        BlockState existing = context.m_43725_().m_8055_(context.m_8083_().m_7495_());
        StoneType type = WorldGenHelper.STONE_MAP.get((Object)existing) != null ? (StoneType)WorldGenHelper.STONE_MAP.get((Object)existing) : AntimatterStoneTypes.STONE;
        BlockState blockstate = ((MaterialTypeBlock.IOreGetter)AntimatterMaterialTypes.ROCK.get()).get(this.material, type).asState();
        if (blockstate == null) {
            return InteractionResult.FAIL;
        }
        if (!context.m_43725_().m_7731_(context.m_8083_(), blockstate, 11)) {
            return InteractionResult.FAIL;
        }
        BlockPos blockpos = context.m_8083_();
        Level world = context.m_43725_();
        Player playerentity = context.m_43723_();
        ItemStack itemstack = context.m_43722_();
        BlockState blockstate1 = world.m_8055_(blockpos);
        Block block = blockstate1.m_60734_();
        if (block == blockstate.m_60734_()) {
            blockstate1 = this.updateBlockStateFromTag(blockpos, world, itemstack, blockstate1);
            this.onBlockPlaced(blockpos, world, playerentity, itemstack, blockstate1);
            block.m_6402_(world, blockpos, blockstate1, (LivingEntity)playerentity, itemstack);
            if (playerentity instanceof ServerPlayer) {
                CriteriaTriggers.f_10591_.m_59469_((ServerPlayer)playerentity, blockpos, itemstack);
            }
        }
        if (!context.m_43723_().m_7500_()) {
            context.m_43722_().m_41774_(1);
        }
        SoundType soundtype = blockstate1.m_60827_();
        world.m_5594_(playerentity, blockpos, blockstate.m_60734_().m_49962_(blockstate1).m_56777_(), SoundSource.BLOCKS, (soundtype.m_56773_() + 1.0f) / 2.0f, soundtype.m_56774_() * 0.8f);
        return InteractionResult.m_19078_((boolean)world.f_46443_);
    }

    protected boolean onBlockPlaced(BlockPos pos, Level worldIn, @Nullable Player player, ItemStack stack, BlockState state) {
        return BlockItem.m_40582_((Level)worldIn, (Player)player, (BlockPos)pos, (ItemStack)stack);
    }

    private BlockState updateBlockStateFromTag(BlockPos p_219985_1_, Level p_219985_2_, ItemStack p_219985_3_, BlockState p_219985_4_) {
        BlockState blockstate = p_219985_4_;
        CompoundTag compoundnbt = p_219985_3_.m_41783_();
        if (compoundnbt != null) {
            CompoundTag compoundnbt1 = compoundnbt.m_128469_("BlockStateTag");
            StateDefinition statecontainer = p_219985_4_.m_60734_().m_49965_();
            for (String s : compoundnbt1.m_128431_()) {
                Property property = statecontainer.m_61081_(s);
                if (property == null) continue;
                String s1 = compoundnbt1.m_128423_(s).m_7916_();
                blockstate = MaterialItem.updateState(blockstate, property, s1);
            }
        }
        if (blockstate != p_219985_4_) {
            p_219985_2_.m_7731_(p_219985_1_, blockstate, 2);
        }
        return blockstate;
    }

    private static <T extends Comparable<T>> BlockState updateState(BlockState state, Property<T> property, String value) {
        return property.m_6215_(value).map(p_219986_2_ -> (BlockState)state.m_61124_(property, p_219986_2_)).orElse(state);
    }

    public static InteractionResult interactWithCauldron(BlockState state, Level world, BlockPos pos, Player player, InteractionHand hand, ItemStack stack) {
        int level;
        if (world.m_5776_()) {
            return InteractionResult.PASS;
        }
        MaterialItem item = (MaterialItem)stack.m_41720_();
        MaterialType<?> type = item.getType();
        if (state.m_60734_() instanceof AbstractCauldronBlock && (level = ((Integer)state.m_61143_((Property)LayeredCauldronBlock.f_153514_)).intValue()) > 0) {
            Material material = ((MaterialItem)stack.m_41720_()).getMaterial();
            if (type == AntimatterMaterialTypes.DUST_IMPURE || type == AntimatterMaterialTypes.DUST_PURE) {
                if (material.has(AntimatterMaterialTypes.DUST)) {
                    stack.m_41774_(1);
                    if (!player.m_36356_(AntimatterMaterialTypes.DUST.get(material, 1))) {
                        player.m_36176_(AntimatterMaterialTypes.DUST.get(material, 1), false);
                    }
                    LayeredCauldronBlock.m_153559_((BlockState)state, (Level)world, (BlockPos)pos);
                    world.m_5594_(null, pos, SoundEvents.f_11778_, SoundSource.BLOCKS, 1.0f, 1.0f);
                    return InteractionResult.SUCCESS;
                }
            } else if (type == AntimatterMaterialTypes.CRUSHED && material.has(AntimatterMaterialTypes.CRUSHED_PURIFIED)) {
                Material oreByProduct;
                stack.m_41774_(1);
                if (!player.m_36356_(AntimatterMaterialTypes.CRUSHED_PURIFIED.get(material, 1))) {
                    player.m_36176_(AntimatterMaterialTypes.CRUSHED_PURIFIED.get(material, 1), false);
                }
                Material material2 = oreByProduct = material.getByProducts().size() >= 1 ? material.getByProducts().get(0) : material;
                if (oreByProduct.has(AntimatterMaterialTypes.DUST) && world.f_46441_.nextInt(100) < 50 && !player.m_36356_(AntimatterMaterialTypes.DUST_TINY.get(oreByProduct, 1))) {
                    player.m_36176_(AntimatterMaterialTypes.DUST_TINY.get(oreByProduct, 1), false);
                }
                LayeredCauldronBlock.m_153559_((BlockState)state, (Level)world, (BlockPos)pos);
                world.m_5594_(null, pos, SoundEvents.f_11778_, SoundSource.BLOCKS, 1.0f, 1.0f);
                return InteractionResult.SUCCESS;
            }
        }
        return InteractionResult.PASS;
    }

    public TagKey<Item> getTag() {
        return TagUtils.getForgelikeItemTag(String.join((CharSequence)"", Utils.getConventionalMaterialType(this.type), "/", this.material.getId()));
    }

    public static boolean hasType(ItemStack stack, MaterialType<?> type) {
        return stack.m_41720_() instanceof MaterialItem && ((MaterialItem)stack.m_41720_()).getType() == type;
    }

    public static boolean hasMaterial(ItemStack stack, Material material) {
        return stack.m_41720_() instanceof MaterialItem && ((MaterialItem)stack.m_41720_()).getMaterial() == material;
    }

    public static MaterialType<?> getType(ItemStack stack) {
        if (!(stack.m_41720_() instanceof MaterialItem)) {
            return null;
        }
        return ((MaterialItem)stack.m_41720_()).getType();
    }

    public static Material getMaterial(ItemStack stack) {
        if (!(stack.m_41720_() instanceof MaterialItem)) {
            return null;
        }
        return ((MaterialItem)stack.m_41720_()).getMaterial();
    }

    public static boolean doesShowExtendedHighlight(ItemStack stack) {
        return MaterialItem.hasType(stack, AntimatterMaterialTypes.PLATE);
    }

    @Override
    public int getItemColor(ItemStack stack, @Nullable Block block, int i) {
        return i == 0 ? this.material.getRGB() : -1;
    }

    @Override
    public Texture[] getTextures() {
        return this.getMaterial().getSet().getTextures(this.getType());
    }

    public int getBurnTime(ItemStack stack, @Nullable RecipeType<?> recipeType) {
        Integer burnTime;
        Map<MaterialType<?>, Integer> map = MaterialTags.FURNACE_FUELS.getMap(this.material);
        if (map != null && (burnTime = map.get(this.type)) != null) {
            return burnTime;
        }
        return -1;
    }
}

