/*
 * Decompiled with CFR 0.152.
 */
package muramasa.antimatter.material;

import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.List;
import java.util.stream.Collectors;
import muramasa.antimatter.AntimatterAPI;
import muramasa.antimatter.data.AntimatterMaterialTypes;
import muramasa.antimatter.item.ItemFluidCell;
import muramasa.antimatter.material.Element;
import muramasa.antimatter.material.IMaterialTag;
import muramasa.antimatter.material.MaterialStack;
import muramasa.antimatter.material.MaterialTags;
import muramasa.antimatter.material.MaterialTypeFluid;
import muramasa.antimatter.material.TextureSet;
import muramasa.antimatter.registration.ISharedAntimatterObject;
import muramasa.antimatter.util.Utils;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.fluids.FluidStack;
import org.apache.commons.lang3.tuple.Pair;
import tesseract.TesseractGraphWrappers;

public class Material
implements ISharedAntimatterObject {
    public static final Material NULL = AntimatterAPI.register(Material.class, new Material("antimatter", "null", 0xFFFFFF, TextureSet.NONE, new String[0]));
    private final String domain;
    private final String id;
    private Component displayName;
    private String displayNameString;
    private final int rgb;
    private final TextureSet set;
    private Element element;
    private String chemicalFormula = null;
    private int massMultiplier = 1;
    private int massDivider = 1;
    public final boolean enabled;

    public Material(String domain, String id, int rgb, TextureSet set, String ... modIds) {
        this.domain = domain;
        this.id = id;
        this.rgb = rgb;
        this.set = set;
        if (modIds != null && modIds.length > 0) {
            for (String modId : modIds) {
                if (AntimatterAPI.isModLoaded(modId)) continue;
                this.enabled = false;
                return;
            }
        }
        this.enabled = true;
        MaterialTags.ORE_MULTI.add(this, 1);
        MaterialTags.SMELTING_MULTI.add(this, 1);
        MaterialTags.BY_PRODUCT_MULTI.add(this, 1);
        MaterialTags.SMELT_INTO.add(this, this);
        MaterialTags.DIRECT_SMELT_INTO.add(this, this);
        MaterialTags.ARC_SMELT_INTO.add(this, this);
        MaterialTags.MACERATE_INTO.add(this, this);
        MaterialTags.PROCESS_INTO.add(this, (Pair<List<MaterialStack>, Integer>)Pair.of((Object)new ObjectArrayList(), (Object)-1));
        MaterialTags.BYPRODUCTS.add(this, (Material)new ObjectArrayList());
    }

    public static void init() {
    }

    public String materialDomain() {
        return this.domain;
    }

    @Override
    public boolean shouldRegister() {
        return this.enabled;
    }

    public Material(String domain, String id, int rgb, TextureSet set, Element element, String ... modIds) {
        this(domain, id, rgb, set, modIds);
        this.element = element;
    }

    @Override
    public String getId() {
        return this.id;
    }

    public String toString() {
        return Utils.lowerUnderscoreToUpperSpaced(this.getId());
    }

    public boolean has(IMaterialTag ... tags) {
        for (IMaterialTag t : tags) {
            if (t.all().contains(this)) continue;
            return false;
        }
        return true;
    }

    public Material setDisplayName(String displayNameString) {
        this.displayNameString = displayNameString;
        return this;
    }

    public Material setMassMultiplierAndDivider(int massMultiplier, int massDivider) {
        this.massMultiplier = massMultiplier;
        this.massDivider = massDivider;
        return this;
    }

    public String getDisplayNameString() {
        return this.displayNameString;
    }

    public Material flags(IMaterialTag ... tags) {
        if (!this.enabled) {
            return this;
        }
        for (IMaterialTag t : tags) {
            if (!this.has(t)) {
                t.add(this);
            }
            this.flags((IMaterialTag[])t.dependents().stream().filter(d -> !this.has((IMaterialTag)d)).toArray(IMaterialTag[]::new));
        }
        return this;
    }

    public void remove(IMaterialTag ... tags) {
        if (!this.enabled) {
            return;
        }
        for (IMaterialTag t : tags) {
            t.remove(this);
        }
    }

    public void setChemicalFormula() {
        if (!this.enabled) {
            return;
        }
        if (this.chemicalFormula != null && this.element != null) {
            return;
        }
        if (this.element != null) {
            this.chemicalFormula = this.element.getElement();
        } else if (!((List)MaterialTags.PROCESS_INTO.get(this).getLeft()).isEmpty()) {
            ((List)MaterialTags.PROCESS_INTO.get(this).getLeft()).forEach(t -> t.m.setChemicalFormula());
            this.chemicalFormula = String.join((CharSequence)"", ((List)MaterialTags.PROCESS_INTO.get(this).getLeft()).stream().map(MaterialStack::toString).collect(Collectors.joining()));
        }
    }

    public Component getDisplayName() {
        return this.displayName == null ? (this.displayName = new TranslatableComponent("material." + this.getId())) : this.displayName;
    }

    public int getRGB() {
        return this.rgb;
    }

    public TextureSet getSet() {
        return this.set;
    }

    public long getProtons() {
        if (this.element != null) {
            return this.element.getProtons();
        }
        if (((List)MaterialTags.PROCESS_INTO.get(this).getLeft()).size() <= 0) {
            return Element.Tc.getProtons();
        }
        long rAmount = 0L;
        long tAmount = 0L;
        for (MaterialStack stack : (List)MaterialTags.PROCESS_INTO.get(this).getLeft()) {
            tAmount += (long)stack.s;
            rAmount += (long)stack.s * stack.m.getProtons();
        }
        return this.getMultiplier() * rAmount / (tAmount * 18144000L);
    }

    public long getNeutrons() {
        if (this.element != null) {
            return this.element.getNeutrons();
        }
        if (((List)MaterialTags.PROCESS_INTO.get(this).getLeft()).size() <= 0) {
            return Element.Tc.getNeutrons();
        }
        long rAmount = 0L;
        long tAmount = 0L;
        for (MaterialStack stack : (List)MaterialTags.PROCESS_INTO.get(this).getLeft()) {
            tAmount += (long)stack.s;
            rAmount += (long)stack.s * stack.m.getNeutrons();
        }
        return this.getMultiplier() * rAmount / (tAmount * 18144000L);
    }

    public long getMass() {
        if (this.element != null) {
            return this.element.getMass();
        }
        if (((List)MaterialTags.PROCESS_INTO.get(this).getLeft()).size() <= 0) {
            return Element.Tc.getMass();
        }
        long rAmount = 0L;
        long tAmount = 0L;
        for (MaterialStack stack : (List)MaterialTags.PROCESS_INTO.get(this).getLeft()) {
            tAmount += (long)stack.s;
            rAmount += (long)stack.s * stack.m.getMass();
        }
        return this.getMultiplier() * rAmount / (tAmount * 18144000L);
    }

    public long getDensity() {
        if (this.element != null) {
            return this.element.getDensity();
        }
        if (((List)MaterialTags.PROCESS_INTO.get(this).getLeft()).size() <= 0) {
            return Element.Tc.getDensity();
        }
        long rAmount = 0L;
        long tAmount = 0L;
        for (MaterialStack stack : (List)MaterialTags.PROCESS_INTO.get(this).getLeft()) {
            tAmount += (long)stack.s;
            rAmount += (long)stack.s * stack.m.getDensity();
        }
        return this.getMultiplier() * rAmount / (tAmount * 18144000L);
    }

    public long getHardness() {
        if (this.element != null) {
            return this.element.getHardness();
        }
        if (((List)MaterialTags.PROCESS_INTO.get(this).getLeft()).size() <= 0) {
            return Element.Tc.getHardness();
        }
        long rAmount = 0L;
        long tAmount = 0L;
        for (MaterialStack stack : (List)MaterialTags.PROCESS_INTO.get(this).getLeft()) {
            tAmount += (long)stack.s;
            rAmount += (long)stack.s * stack.m.getHardness();
        }
        return this.getMultiplier() * rAmount / (tAmount * 18144000L);
    }

    private long getMultiplier() {
        return 18144000L * (long)this.massMultiplier / (long)this.massDivider;
    }

    public Element getElement() {
        return this.element;
    }

    public String getChemicalFormula() {
        return this.chemicalFormula == null ? "" : this.chemicalFormula;
    }

    public Fluid getLiquid() {
        return ((MaterialTypeFluid.IFluidGetter)AntimatterMaterialTypes.LIQUID.get()).get(this, 1L).getFluid();
    }

    public Fluid getGas() {
        return ((MaterialTypeFluid.IFluidGetter)AntimatterMaterialTypes.GAS.get()).get(this, 1L).getFluid();
    }

    public Fluid getPlasma() {
        return ((MaterialTypeFluid.IFluidGetter)AntimatterMaterialTypes.PLASMA.get()).get(this, 1L).getFluid();
    }

    public FluidStack getLiquid(long droplets) {
        if (!this.has(AntimatterMaterialTypes.LIQUID)) {
            throw new RuntimeException("Material: " + this.getId() + " does not have liquid");
        }
        return ((MaterialTypeFluid.IFluidGetter)AntimatterMaterialTypes.LIQUID.get()).get(this, droplets);
    }

    public FluidStack getGas(long droplets) {
        if (!this.has(AntimatterMaterialTypes.GAS)) {
            throw new RuntimeException("Material: " + this.getId() + " does not have gas");
        }
        return ((MaterialTypeFluid.IFluidGetter)AntimatterMaterialTypes.GAS.get()).get(this, droplets);
    }

    public FluidStack getPlasma(long droplets) {
        if (!this.has(AntimatterMaterialTypes.PLASMA)) {
            throw new RuntimeException("Material: " + this.getId() + " does not have plasma");
        }
        return ((MaterialTypeFluid.IFluidGetter)AntimatterMaterialTypes.PLASMA.get()).get(this, droplets);
    }

    public FluidStack getLiquid(int mb) {
        return this.getLiquid((long)mb * TesseractGraphWrappers.dropletMultiplier);
    }

    public FluidStack getGas(int mb) {
        return this.getGas((long)mb * TesseractGraphWrappers.dropletMultiplier);
    }

    public FluidStack getPlasma(int mb) {
        return this.getPlasma((long)mb * TesseractGraphWrappers.dropletMultiplier);
    }

    public List<MaterialStack> getProcessInto() {
        return (List)MaterialTags.PROCESS_INTO.get(this).getLeft();
    }

    public List<Material> getByProducts() {
        return MaterialTags.BYPRODUCTS.getList(this);
    }

    public boolean hasByProducts() {
        return MaterialTags.BYPRODUCTS.getList(this).size() > 0;
    }

    public ItemStack getCell(int amount, ItemFluidCell cell) {
        return Utils.ca(amount, cell.fill(this.getLiquid()));
    }

    public ItemStack getCellGas(int amount, ItemFluidCell cell) {
        return Utils.ca(amount, cell.fill(this.getGas()));
    }

    public ItemStack getCellPlasma(int amount, ItemFluidCell cell) {
        return Utils.ca(amount, cell.fill(this.getPlasma()));
    }

    public static Material get(String id) {
        Material material = AntimatterAPI.get(Material.class, id);
        return material == null ? NULL : material;
    }

    public int hashCode() {
        return this.id.hashCode();
    }
}

