/*
 * Decompiled with CFR 0.152.
 */
package muramasa.antimatter.machine.types;

import muramasa.antimatter.Data;
import muramasa.antimatter.gui.GuiInstance;
import muramasa.antimatter.gui.ICanSyncData;
import muramasa.antimatter.gui.IGuiElement;
import muramasa.antimatter.gui.widget.InfoRenderWidget;
import muramasa.antimatter.gui.widget.WidgetSupplier;
import muramasa.antimatter.integration.jeirei.renderer.IInfoRenderer;
import muramasa.antimatter.machine.MachineFlag;
import muramasa.antimatter.machine.types.Machine;
import muramasa.antimatter.tile.TileEntityTank;
import net.minecraftforge.fluids.FluidStack;

public class TankMachine
extends Machine<TankMachine> {
    public TankMachine(String domain, String name) {
        super(domain, name);
        this.setTile(TileEntityTank::new);
        this.addFlags(MachineFlag.ITEM, MachineFlag.FLUID, MachineFlag.COVERABLE);
        this.setGUI(Data.BASIC_MENU_HANDLER);
        this.frontCovers();
        this.allowFrontIO();
    }

    @Override
    protected void setupGui() {
        super.setupGui();
        this.addGuiCallback(t -> t.addWidget(TankRenderWidget.build().onlyIf(h -> h.handler instanceof TileEntityTank)));
    }

    public static class TankRenderWidget
    extends InfoRenderWidget<TankRenderWidget> {
        public FluidStack stack = FluidStack.EMPTY;

        protected TankRenderWidget(GuiInstance gui, IGuiElement parent, IInfoRenderer<TankRenderWidget> renderer) {
            super(gui, parent, renderer);
        }

        @Override
        public void init() {
            super.init();
            TileEntityTank tank = (TileEntityTank)this.gui.handler;
            this.gui.syncFluidStack(() -> tank.fluidHandler.map(t -> t.getFluidInTank(0)).orElse(FluidStack.EMPTY), f -> {
                this.stack = f;
            }, ICanSyncData.SyncDirection.SERVER_TO_CLIENT);
        }

        public static WidgetSupplier build() {
            return TankRenderWidget.builder((a, b) -> new TankRenderWidget((GuiInstance)a, (IGuiElement)b, (IInfoRenderer)((Object)a.handler)));
        }
    }
}

