/*
 * Decompiled with CFR 0.152.
 */
package muramasa.antimatter.machine.types;

import java.util.Arrays;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;
import muramasa.antimatter.AntimatterAPI;
import muramasa.antimatter.Data;
import muramasa.antimatter.gui.BarDir;
import muramasa.antimatter.gui.widget.ProgressWidget;
import muramasa.antimatter.machine.BlockMachine;
import muramasa.antimatter.machine.BlockMultiMachine;
import muramasa.antimatter.machine.MachineFlag;
import muramasa.antimatter.machine.MachineState;
import muramasa.antimatter.machine.Tier;
import muramasa.antimatter.machine.types.Machine;
import muramasa.antimatter.machine.types.MultiMachine;
import muramasa.antimatter.structure.Pattern;
import muramasa.antimatter.structure.PatternBuilder;
import muramasa.antimatter.texture.Texture;
import muramasa.antimatter.tile.multi.TileEntityBasicMultiMachine;
import muramasa.antimatter.util.AntimatterPlatformUtils;

public class BasicMultiMachine<T extends BasicMultiMachine<T>>
extends Machine<T> {
    @Override
    public BlockMachine getBlockState(Tier tier) {
        if (this.tileType == null) {
            return null;
        }
        return AntimatterAPI.get(BlockMultiMachine.class, this.getId() + "_" + tier.getId(), this.getDomain());
    }

    public BasicMultiMachine(String domain, String name) {
        super(domain, name);
        this.setTile(TileEntityBasicMultiMachine::new);
        this.setBlock(BlockMultiMachine::new);
        this.setItemBlockClass(() -> BlockMultiMachine.class);
        this.addFlags(MachineFlag.MULTI, MachineFlag.COVERABLE);
        this.setClientTick();
        this.setGUI(Data.BASIC_MENU_HANDLER);
        this.covers(null);
        this.baseTexture((Machine type, Tier tier) -> {
            Texture[] textureArray;
            if (type.getTiers().size() > 1) {
                Texture[] textureArray2 = new Texture[1];
                textureArray = textureArray2;
                textureArray2[0] = new Texture(domain, "block/machine/base/" + type.getId() + "_" + tier.getId());
            } else {
                Texture[] textureArray3 = new Texture[1];
                textureArray = textureArray3;
                textureArray3[0] = new Texture(domain, "block/machine/base/" + type.getId());
            }
            return textureArray;
        });
    }

    @Override
    protected void setupGui() {
        super.setupGui();
        if (!(this instanceof MultiMachine)) {
            this.addGuiCallback(t -> t.addWidget(ProgressWidget.build(BarDir.LEFT, true)));
        }
    }

    @Override
    public List<Texture> getTextures() {
        List<Texture> textures = super.getTextures();
        this.getTiers().forEach(t -> textures.addAll(Arrays.asList(this.getBaseTexture((Tier)t))));
        this.getTiers().forEach(t -> textures.addAll(Arrays.asList(this.getOverlayTextures(MachineState.INVALID_STRUCTURE, (Tier)t))));
        return textures;
    }

    public final void setStructurePattern(Function<PatternBuilder, Pattern> patterns) {
        this.setStructurePattern(patterns.apply(new PatternBuilder()));
    }

    public final void setStructurePattern(Pattern ... patterns) {
        if (AntimatterAPI.getSIDE().isClient()) {
            if (patterns.length <= 0) {
                return;
            }
            AntimatterPlatformUtils.addMultiMachineInfo(this, Arrays.stream(patterns).collect(Collectors.toList()));
        }
    }
}

