/*
 * Decompiled with CFR 0.152.
 */
package muramasa.antimatter.machine;

import muramasa.antimatter.AntimatterAPI;
import muramasa.antimatter.registration.ISharedAntimatterObject;
import muramasa.antimatter.texture.Texture;
import net.minecraft.ChatFormatting;

public class Tier
implements ISharedAntimatterObject {
    public static Tier ULV = new Tier("antimatter", "ulv", 8, ChatFormatting.WHITE, 0);
    public static Tier LV = new Tier("antimatter", "lv", 32, ChatFormatting.WHITE, 1);
    public static Tier MV = new Tier("antimatter", "mv", 128, ChatFormatting.WHITE, 2);
    public static Tier HV = new Tier("antimatter", "hv", 512, ChatFormatting.YELLOW, 3);
    public static Tier EV = new Tier("antimatter", "ev", 2048, ChatFormatting.AQUA, 4);
    public static Tier IV = new Tier("antimatter", "iv", 8192, ChatFormatting.LIGHT_PURPLE, 5);
    public static Tier LUV = new Tier("antimatter", "luv", 32768, ChatFormatting.LIGHT_PURPLE, 6);
    public static Tier ZPM = new Tier("antimatter", "zpm", 131072, ChatFormatting.LIGHT_PURPLE, 7);
    public static Tier UV = new Tier("antimatter", "uv", 524288, ChatFormatting.LIGHT_PURPLE, 8);
    public static Tier MAX = new Tier("antimatter", "max", Integer.MAX_VALUE, ChatFormatting.LIGHT_PURPLE, 14);
    public static Tier BRONZE = new Tier("antimatter", "bronze", 0, ChatFormatting.WHITE);
    public static Tier STEEL = new Tier("antimatter", "steel", 0, ChatFormatting.WHITE);
    public static Tier NONE = new Tier("antimatter", "none", 0, ChatFormatting.WHITE);
    private final String domain;
    private final String id;
    private final int voltage;
    private final int tierNumber;
    private final ChatFormatting rarityColor;
    private final String baseTexture;

    public Tier(String domain, String id, int voltage, ChatFormatting rarityColor) {
        this(domain, id, voltage, rarityColor, 1);
    }

    public Tier(String domain, String id, int voltage, ChatFormatting rarityColor, int tierNumber) {
        this.domain = domain;
        this.id = id;
        this.voltage = voltage;
        this.rarityColor = rarityColor;
        this.baseTexture = "block/machine/base/" + id;
        this.tierNumber = tierNumber;
        AntimatterAPI.register(Tier.class, this);
    }

    @Override
    public String getId() {
        return this.id;
    }

    public int getIntegerId() {
        return this.tierNumber;
    }

    public int getVoltage() {
        return this.voltage;
    }

    public ChatFormatting getRarityFormatting() {
        return this.rarityColor;
    }

    public Texture getBaseTexture(String domain) {
        return new Texture(domain, this.baseTexture);
    }

    public static Tier[] getSteam() {
        return new Tier[]{BRONZE, STEEL};
    }

    public static Tier[] getStandard() {
        return new Tier[]{LV, MV, HV, EV, IV};
    }

    public static Tier[] getAllElectric() {
        return new Tier[]{ULV, LV, MV, HV, EV, IV, LUV, ZPM, UV, MAX};
    }

    public static Tier[] getBasic() {
        return new Tier[]{BRONZE, STEEL, LV, MV, HV, EV, IV};
    }

    public static Tier getMax() {
        return IV;
    }

    public static Texture[] getTextures(String domain, Tier ... tiers) {
        Texture[] textures = new Texture[tiers.length];
        for (int i = 0; i < tiers.length; ++i) {
            textures[i] = tiers[i].getBaseTexture(domain);
        }
        return textures;
    }

    public static Tier getTier(int voltage) {
        for (Tier tier : Tier.getAllElectric()) {
            if (voltage > tier.getVoltage()) continue;
            return tier;
        }
        return ULV;
    }
}

