/*
 * Decompiled with CFR 0.152.
 */
package muramasa.antimatter.machine;

import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import java.util.Collection;
import java.util.Set;
import muramasa.antimatter.machine.types.Machine;

public enum MachineFlag {
    BASIC,
    STEAM,
    MULTI,
    HATCH,
    FAKE_INPUTS,
    ITEM,
    ITEM_INPUT,
    ITEM_OUTPUT,
    CELL,
    CELL_INPUT,
    CELL_OUTPUT,
    FLUID_INPUT,
    FLUID_OUTPUT,
    FLUID,
    ENERGY,
    RF,
    HEAT,
    RECIPE,
    GUI,
    GENERATOR,
    COVERABLE;

    public static final MachineFlag[] VALUES;
    private final Set<Machine<?>> types = new ObjectOpenHashSet();

    public void add(Machine<?> machine) {
        this.types.add(machine);
    }

    public void remove(Machine<?> machine) {
        this.types.remove(machine);
    }

    public Set<Machine<?>> getTypes() {
        return this.types;
    }

    public static Collection<Machine<?>> getTypes(MachineFlag ... flags) {
        ObjectArrayList types = new ObjectArrayList();
        for (MachineFlag flag : flags) {
            types.addAll(flag.getTypes());
        }
        return types;
    }

    static {
        VALUES = MachineFlag.values();
    }
}

